/*
 * Decompiled with CFR 0.152.
 */
package smartin.miapi.client.model;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.ConduitRenderer;
import net.minecraft.core.BlockPos;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.ConduitBlockEntity;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import org.joml.Matrix4f;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;
import org.joml.Vector3f;
import org.joml.Vector3fc;
import smartin.miapi.client.model.MiapiModel;
import smartin.miapi.item.modular.Transform;

@OnlyIn(value=Dist.CLIENT)
public class ConduitRendererEntity
implements MiapiModel {
    Transform transform;
    ConduitRenderer renderer;
    ConduitBlockEntity conduitBlockEntity;
    private final ModelPart conduitEye;
    private final ModelPart conduitWind;
    private final ModelPart conduitShell;
    private final ModelPart conduit;

    public ConduitRendererEntity(Transform transform) {
        this.transform = transform;
        this.conduitBlockEntity = new ConduitBlockEntity(BlockPos.ZERO, Blocks.CONDUIT.defaultBlockState());
        this.conduitEye = ConduitRendererEntity.getEyeTexturedModelData().bakeRoot();
        this.conduitWind = ConduitRendererEntity.getWindTexturedModelData().bakeRoot();
        this.conduitShell = ConduitRendererEntity.getShellTexturedModelData().bakeRoot();
        this.conduit = ConduitRendererEntity.getPlainTexturedModelData().bakeRoot();
    }

    public static LayerDefinition getEyeTexturedModelData() {
        MeshDefinition modelData = new MeshDefinition();
        PartDefinition modelPartData = modelData.getRoot();
        modelPartData.addOrReplaceChild("eye", CubeListBuilder.create().texOffs(0, 0).addBox(-4.0f, -4.0f, 0.0f, 8.0f, 8.0f, 0.0f, new CubeDeformation(0.01f)), PartPose.ZERO);
        return LayerDefinition.create((MeshDefinition)modelData, (int)16, (int)16);
    }

    public static LayerDefinition getWindTexturedModelData() {
        MeshDefinition modelData = new MeshDefinition();
        PartDefinition modelPartData = modelData.getRoot();
        modelPartData.addOrReplaceChild("wind", CubeListBuilder.create().texOffs(0, 0).addBox(-8.0f, -8.0f, -8.0f, 16.0f, 16.0f, 16.0f), PartPose.ZERO);
        return LayerDefinition.create((MeshDefinition)modelData, (int)64, (int)32);
    }

    public static LayerDefinition getShellTexturedModelData() {
        MeshDefinition modelData = new MeshDefinition();
        PartDefinition modelPartData = modelData.getRoot();
        modelPartData.addOrReplaceChild("shell", CubeListBuilder.create().texOffs(0, 0).addBox(-3.0f, -3.0f, -3.0f, 6.0f, 6.0f, 6.0f), PartPose.ZERO);
        return LayerDefinition.create((MeshDefinition)modelData, (int)32, (int)16);
    }

    public static LayerDefinition getPlainTexturedModelData() {
        MeshDefinition modelData = new MeshDefinition();
        PartDefinition modelPartData = modelData.getRoot();
        modelPartData.addOrReplaceChild("shell", CubeListBuilder.create().texOffs(0, 0).addBox(-4.0f, -4.0f, -4.0f, 8.0f, 8.0f, 8.0f), PartPose.ZERO);
        return LayerDefinition.create((MeshDefinition)modelData, (int)32, (int)16);
    }

    @Override
    public void render(PoseStack matrices, ItemStack stack, ItemDisplayContext transformationMode, float f, MultiBufferSource vertexConsumers, LivingEntity entity, int light, int overlay) {
        f = 0.0f;
        float h = this.conduitBlockEntity.getActiveRotation(f) * 57.295776f;
        float g = (float)this.conduitBlockEntity.tickCount + f;
        float k = Mth.sin((float)(g * 0.1f)) / 2.0f + 0.5f;
        k += k * k;
        matrices.pushPose();
        this.transform.applyPosition(matrices);
        matrices.pushPose();
        matrices.translate(0.5f, 0.3f + k * 0.2f, 0.5f);
        Vector3f vector3f = new Vector3f(0.5f, 1.0f, 0.5f).normalize();
        matrices.mulPose(new Quaternionf().rotationAxis(h * ((float)Math.PI / 180), (Vector3fc)vector3f));
        this.conduit.render(matrices, ConduitRenderer.ACTIVE_SHELL_TEXTURE.buffer(vertexConsumers, RenderType::entityCutoutNoCull), light, overlay);
        matrices.popPose();
        int l = this.conduitBlockEntity.tickCount / 66 % 3;
        matrices.pushPose();
        matrices.translate(0.5f, 0.5f, 0.5f);
        if (l == 1) {
            matrices.mulPose(new Quaternionf().rotationX(1.5707964f));
        } else if (l == 2) {
            matrices.mulPose(new Quaternionf().rotationZ(1.5707964f));
        }
        VertexConsumer vertexConsumer2 = (l == 1 ? ConduitRenderer.VERTICAL_WIND_TEXTURE : ConduitRenderer.WIND_TEXTURE).buffer(vertexConsumers, RenderType::entityCutoutNoCull);
        this.conduitWind.render(matrices, vertexConsumer2, light, overlay);
        matrices.popPose();
        matrices.pushPose();
        matrices.translate(0.5f, 0.5f, 0.5f);
        matrices.scale(0.875f, 0.875f, 0.875f);
        matrices.mulPose(new Quaternionf().rotationXYZ((float)Math.PI, 0.0f, (float)Math.PI));
        matrices.popPose();
        matrices.pushPose();
        matrices.translate(0.5f, 0.3f + k * 0.2f, 0.5f);
        matrices.scale(0.5f, 0.5f, 0.5f);
        Matrix4f matrix4f = matrices.last().pose();
        float dir = matrix4f.getTranslation(new Vector3f()).x() > 0.0f ? 1.0f : -1.0f;
        matrix4f.rotate((Quaternionfc)matrix4f.getUnnormalizedRotation(new Quaternionf()).invert());
        matrix4f.rotate((float)Math.PI, (Vector3fc)new Vector3f(1.0f, 0.0f, 0.0f));
        this.conduitEye.render(matrices, (this.conduitBlockEntity.isHunting() ? ConduitRenderer.OPEN_EYE_TEXTURE : ConduitRenderer.CLOSED_EYE_TEXTURE).buffer(vertexConsumers, RenderType::entityCutoutNoCull), 0xF000F0, overlay);
        matrices.popPose();
        matrices.popPose();
    }
}

