/*
 * Decompiled with CFR 0.152.
 */
package smartin.miapi.client.model;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import org.joml.Quaternionf;
import smartin.miapi.client.model.MiapiModel;

@OnlyIn(value=Dist.CLIENT)
public class CrystalModel
implements MiapiModel {
    LayerDefinition modelData;
    ResourceLocation TEXTURE = ResourceLocation.parse((String)"textures/entity/end_crystal/end_crystal.png");
    RenderType END_CRYSTAL = RenderType.entityCutoutNoCull((ResourceLocation)this.TEXTURE);
    int age;
    float SINE_45_DEGREES = (float)Math.sin(0.7853981633974483);
    ModelPart core;
    ModelPart frame;
    ModelPart bottom;

    public CrystalModel() {
        this.modelData = CrystalModel.getTexturedModelData();
        ModelPart modelPart = this.modelData.bakeRoot();
        this.frame = modelPart.getChild("glass");
        this.core = modelPart.getChild("cube");
        this.bottom = modelPart.getChild("base");
    }

    @Override
    public void render(PoseStack matrixStack, ItemStack stack, ItemDisplayContext transformationMode, float tickDelta, MultiBufferSource vertexConsumers, LivingEntity entity, int light, int overlay) {
        ++this.age;
        matrixStack.pushPose();
        matrixStack.translate(0.5, 0.5, 0.5);
        float scale = 0.0625f;
        matrixStack.scale(scale, scale, scale);
        float h = 0.5f;
        float j = (float)this.age + tickDelta;
        VertexConsumer vertexConsumer = vertexConsumers.getBuffer(this.END_CRYSTAL);
        matrixStack.pushPose();
        matrixStack.scale(2.0f, 2.0f, 2.0f);
        matrixStack.translate(0.0f, -0.5f, 0.0f);
        int k = OverlayTexture.NO_OVERLAY;
        matrixStack.mulPose(Axis.YP.rotationDegrees(j));
        matrixStack.translate(0.0f, 1.5f + h / 2.0f, 0.0f);
        matrixStack.mulPose(new Quaternionf().setAngleAxis(1.0471976f, this.SINE_45_DEGREES, 0.0f, this.SINE_45_DEGREES));
        this.frame.render(matrixStack, vertexConsumer, light, k);
        float l = 0.875f;
        matrixStack.scale(0.875f, 0.875f, 0.875f);
        matrixStack.mulPose(new Quaternionf().setAngleAxis(1.0471976f, this.SINE_45_DEGREES, 0.0f, this.SINE_45_DEGREES));
        matrixStack.mulPose(Axis.YP.rotationDegrees(j));
        this.frame.render(matrixStack, vertexConsumer, light, k);
        matrixStack.scale(0.875f, 0.875f, 0.875f);
        matrixStack.mulPose(new Quaternionf().setAngleAxis(1.0471976f, this.SINE_45_DEGREES, 0.0f, this.SINE_45_DEGREES));
        matrixStack.mulPose(Axis.YP.rotationDegrees(j));
        this.core.render(matrixStack, vertexConsumer, light, k);
        matrixStack.popPose();
        matrixStack.popPose();
    }

    public static LayerDefinition getTexturedModelData() {
        MeshDefinition modelData = new MeshDefinition();
        PartDefinition modelPartData = modelData.getRoot();
        modelPartData.addOrReplaceChild("glass", CubeListBuilder.create().texOffs(0, 0).addBox(-4.0f, -4.0f, -4.0f, 8.0f, 8.0f, 8.0f), PartPose.ZERO);
        modelPartData.addOrReplaceChild("cube", CubeListBuilder.create().texOffs(32, 0).addBox(-4.0f, -4.0f, -4.0f, 8.0f, 8.0f, 8.0f), PartPose.ZERO);
        modelPartData.addOrReplaceChild("base", CubeListBuilder.create().texOffs(0, 16).addBox(-6.0f, 0.0f, -6.0f, 12.0f, 4.0f, 12.0f), PartPose.ZERO);
        return LayerDefinition.create((MeshDefinition)modelData, (int)64, (int)32);
    }
}

