/*
 * Decompiled with CFR 0.152.
 */
package smartin.miapi.client.model;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.datafixers.util.Pair;
import java.util.ArrayList;
import java.util.List;
import java.util.WeakHashMap;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.joml.Matrix4f;
import smartin.miapi.client.GlintShader;
import smartin.miapi.client.model.MiapiModel;
import smartin.miapi.client.model.ModuleModel;
import smartin.miapi.client.model.item.DualKeyCache;
import smartin.miapi.datapack.ReloadEvents;
import smartin.miapi.item.modular.VisualModularItem;
import smartin.miapi.modules.ItemModule;
import smartin.miapi.modules.ModuleInstance;
import smartin.miapi.modules.cache.ModularItemCache;

@OnlyIn(value=Dist.CLIENT)
public class MiapiItemModel
implements MiapiModel {
    public static List<ModelSupplier> modelSuppliers = new ArrayList<ModelSupplier>();
    public static List<ModelTransformerSupplier> modelTransformersSuppler = new ArrayList<ModelTransformerSupplier>();
    public final ItemStack stack;
    private static final String CACHE_KEY = "miapi_model_rework";
    public final DualKeyCache<String, ItemDisplayContext, List<ModelTransformer>> transformerCache = new DualKeyCache();
    public final DualKeyCache<String, ItemDisplayContext, ModuleModel> modelCache = new DualKeyCache();
    public static final WeakHashMap<ItemStack, MiapiItemModel> fallbackLookup = new WeakHashMap();

    @Nullable
    public static MiapiItemModel getItemModel(ItemStack stack) {
        return (MiapiItemModel)ModularItemCache.getRaw(stack, CACHE_KEY);
    }

    private MiapiItemModel(ItemStack stack) {
        this.stack = stack;
        if (!(stack.getItem() instanceof VisualModularItem) && !VisualModularItem.isVisualModularItem(stack)) {
            throw new RuntimeException("Can only make MiapiModel for Modular Items");
        }
    }

    public void render(PoseStack matrices, ItemDisplayContext mode, float tickDelta, MultiBufferSource vertexConsumers, int light, int overlay) {
        this.render(null, matrices, mode, tickDelta, vertexConsumers, light, overlay);
    }

    @Override
    public void render(PoseStack matrices, ItemStack stack, ItemDisplayContext mode, float tickDelta, MultiBufferSource vertexConsumers, LivingEntity entity, int light, int overlay) {
        this.render(null, stack, matrices, mode, tickDelta, vertexConsumers, entity, light, overlay);
    }

    public void render(String modelType, PoseStack matrices, ItemDisplayContext mode, float tickDelta, MultiBufferSource vertexConsumers, int light, int overlay) {
        this.render(modelType, this.stack, matrices, mode, tickDelta, vertexConsumers, null, light, overlay);
    }

    public void render(String modelTypeRaw, ItemStack stack, PoseStack matrices, ItemDisplayContext mode, float tickDelta, MultiBufferSource vertexConsumers, LivingEntity entity, int light, int overlay) {
        if (ReloadEvents.isInReload()) {
            return;
        }
        assert (Minecraft.getInstance().level != null);
        Minecraft.getInstance().getProfiler().push("modular_item");
        Minecraft.getInstance().getProfiler().push("root-logic");
        String modelType = modelTypeRaw == null ? "item" : modelTypeRaw;
        ModuleModel rootModel = this.modelCache.getNullSave(modelType, mode, (s, k) -> new ModuleModel(ItemModule.getModules(stack), stack, (String)s, (ItemDisplayContext)k));
        matrices.pushPose();
        Minecraft.getInstance().getProfiler().push("model-transformers");
        List transformers = this.transformerCache.getNullSave(modelType, mode, (s, t) -> MiapiItemModel.getTransfomers(stack, mode, modelType));
        for (ModelTransformer transformer : transformers) {
            matrices = transformer.transform(matrices, tickDelta);
        }
        Minecraft.getInstance().getProfiler().pop();
        if (entity == null) {
            entity = Minecraft.getInstance().player;
        }
        Minecraft.getInstance().getProfiler().push("glint-setup");
        GlintShader.setupItem(matrices.last().pose());
        Minecraft.getInstance().getProfiler().pop();
        Minecraft.getInstance().getProfiler().pop();
        rootModel.render(modelType, stack, matrices, mode, tickDelta, vertexConsumers, entity, light, overlay);
        matrices.popPose();
        Minecraft.getInstance().getProfiler().pop();
    }

    @NotNull
    private static List<ModelTransformer> getTransfomers(ItemStack stack, ItemDisplayContext mode, String modelType) {
        ArrayList<ModelTransformer> transformersList = new ArrayList<ModelTransformer>();
        modelTransformersSuppler.forEach(modelSupplier -> {
            ModelTransformer transformer = modelSupplier.get(stack, modelType, mode);
            if (transformer != null) {
                transformersList.add(transformer);
            }
        });
        return transformersList;
    }

    @Override
    @Nullable
    public Matrix4f subModuleMatrix() {
        return null;
    }

    static {
        ModularItemCache.setSupplier(CACHE_KEY, s -> {
            if (fallbackLookup.containsKey(s)) {
                return fallbackLookup.get(s);
            }
            MiapiItemModel model = new MiapiItemModel(s);
            fallbackLookup.put(s, model);
            return model;
        });
    }

    public static interface ModelTransformer {
        public PoseStack transform(PoseStack var1, float var2);
    }

    public static interface ModelTransformerSupplier {
        public ModelTransformer get(ItemStack var1, String var2, @Nullable ItemDisplayContext var3);
    }

    public static interface ModelSupplier {
        public List<MiapiModel> getModels(String var1, @Nullable ItemDisplayContext var2, ModuleInstance var3, ItemStack var4);

        default public List<Pair<Matrix4f, MiapiModel>> filter(List<Pair<Matrix4f, MiapiModel>> models, ItemStack stack, ModuleInstance module, String key, ItemDisplayContext context) {
            return models;
        }
    }
}

