/*
 * Decompiled with CFR 0.152.
 */
package smartin.miapi.client.model;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.core.Direction;
import net.minecraft.util.RandomSource;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class ModelTransformer {
    private static final Map<BakedModel, List<BakedQuad>> inverseMap = new WeakHashMap<BakedModel, List<BakedQuad>>();
    private static final Map<BakedModel, List<BakedQuad>> reScaledMap = new WeakHashMap<BakedModel, List<BakedQuad>>();
    private static final Map<BakedModel, List<BakedQuad>> inversedRescaledMap = new WeakHashMap<BakedModel, List<BakedQuad>>();

    public static void clearCaches() {
        inverseMap.clear();
        reScaledMap.clear();
        inversedRescaledMap.clear();
    }

    public static List<BakedQuad> getInverse(BakedModel bakedModel, RandomSource random) {
        return inverseMap.computeIfAbsent(bakedModel, model -> {
            ArrayList rawQuads = new ArrayList();
            for (Direction direction : Direction.values()) {
                rawQuads.addAll(model.getQuads(null, direction, random));
            }
            ArrayList redoneQuads = new ArrayList();
            rawQuads.forEach(bakedQuad -> redoneQuads.add(new BakedQuad(ModelTransformer.inverse(bakedQuad.getVertices()), bakedQuad.getTintIndex(), bakedQuad.getDirection(), bakedQuad.getSprite(), bakedQuad.isShade())));
            return redoneQuads;
        });
    }

    public static List<BakedQuad> getRescale(BakedModel bakedModel, RandomSource random) {
        return reScaledMap.computeIfAbsent(bakedModel, model -> {
            ArrayList rawQuads = new ArrayList();
            for (Direction direction : Direction.values()) {
                rawQuads.addAll(model.getQuads(null, direction, random));
            }
            ArrayList redoneQuads = new ArrayList();
            rawQuads.forEach(bakedQuad -> {
                float uStart = bakedQuad.getSprite().getU0();
                float uScale = 1.0f / (bakedQuad.getSprite().getU1() - bakedQuad.getSprite().getU0());
                float vStart = bakedQuad.getSprite().getV0();
                float vScale = 1.0f / (bakedQuad.getSprite().getV1() - bakedQuad.getSprite().getV0());
                redoneQuads.add(new BakedQuad(ModelTransformer.rescale(bakedQuad.getVertices(), uStart, uScale, vStart, vScale), bakedQuad.getTintIndex(), bakedQuad.getDirection(), bakedQuad.getSprite(), bakedQuad.isShade()));
            });
            return redoneQuads;
        });
    }

    public static List<BakedQuad> getRescaleInverse(BakedModel bakedModel, RandomSource random) {
        return inversedRescaledMap.computeIfAbsent(bakedModel, model -> {
            ArrayList rawQuads = new ArrayList();
            for (Direction direction : Direction.values()) {
                rawQuads.addAll(model.getQuads(null, direction, random));
            }
            ArrayList redoneQuads = new ArrayList();
            rawQuads.forEach(bakedQuad -> {
                float uStart = bakedQuad.getSprite().getU0();
                float uScale = 1.0f / (bakedQuad.getSprite().getU1() - bakedQuad.getSprite().getU0());
                float vStart = bakedQuad.getSprite().getV0();
                float vScale = 1.0f / (bakedQuad.getSprite().getV1() - bakedQuad.getSprite().getV0());
                redoneQuads.add(new BakedQuad(ModelTransformer.inverse(ModelTransformer.rescale(bakedQuad.getVertices(), uStart, uScale, vStart, vScale)), bakedQuad.getTintIndex(), bakedQuad.getDirection(), bakedQuad.getSprite(), bakedQuad.isShade()));
            });
            return redoneQuads;
        });
    }

    private static int[] rescale(int[] raw, float uStart, float uScale, float vStart, float vScale) {
        int[] copiedArray = new int[raw.length];
        System.arraycopy(raw, 0, copiedArray, 0, raw.length);
        for (int i = 0; i < raw.length / 8; ++i) {
            copiedArray[i * 8 + 4] = Float.floatToRawIntBits((Float.intBitsToFloat(raw[i * 8 + 4]) - uStart) * uScale);
            copiedArray[i * 8 + 5] = Float.floatToRawIntBits((Float.intBitsToFloat(raw[i * 8 + 5]) - vStart) * vScale);
        }
        return copiedArray;
    }

    private static int[] inverse(int[] raw) {
        int[] copiedArray = new int[raw.length];
        System.arraycopy(raw, 0, copiedArray, 0, raw.length);
        for (int j = 0; j < 8; ++j) {
            copiedArray[j] = raw[16 + j];
            copiedArray[8 + j] = raw[8 + j];
            copiedArray[16 + j] = raw[j];
            copiedArray[24 + j] = raw[24 + j];
        }
        return copiedArray;
    }
}

