/*
 * Decompiled with CFR 0.152.
 */
package smartin.miapi.client.model.item;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.ItemOverrides;
import net.minecraft.client.renderer.block.model.ItemTransforms;
import net.minecraft.client.renderer.texture.TextureAtlas;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.client.resources.model.SimpleBakedModel;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import org.jetbrains.annotations.Nullable;
import smartin.miapi.Miapi;
import smartin.miapi.client.model.DynamicBakery;
import smartin.miapi.client.model.item.BakedSingleModelOverrides;

@OnlyIn(value=Dist.CLIENT)
public class BakedSingleModel
implements BakedModel {
    public List<BakedQuad> quads;
    public ItemTransforms modelTransformation = ItemTransforms.NO_TRANSFORMS;
    public List<BakedModel> childModels = new ArrayList<BakedModel>();
    private BakedSingleModel overrideModel;
    public ItemOverrides overrideList;

    public BakedSingleModel(List<BakedQuad> quads) {
        this.quads = quads;
        this.overrideList = new DynamicOverrides();
    }

    public List<BakedQuad> getQuads(@Nullable BlockState state, @Nullable Direction face, RandomSource random) {
        ArrayList<BakedQuad> bakedQuads = new ArrayList<BakedQuad>();
        this.quads.forEach(bakedQuad -> {
            if (bakedQuad.getDirection().equals((Object)face)) {
                bakedQuads.add((BakedQuad)bakedQuad);
            }
        });
        return bakedQuads;
    }

    public void addModel(BakedModel child) {
        if (this.overrideModel == null) {
            this.overrideModel = new BakedSingleModel(new ArrayList<BakedQuad>());
        }
        this.childModels.add(child);
    }

    public boolean useAmbientOcclusion() {
        return false;
    }

    public boolean isGui3d() {
        return false;
    }

    public boolean usesBlockLight() {
        return false;
    }

    public boolean isCustomRenderer() {
        return false;
    }

    public TextureAtlasSprite getParticleIcon() {
        ResourceLocation stoneTextureId = ResourceLocation.fromNamespaceAndPath((String)"minecraft", (String)"block/stone");
        return (TextureAtlasSprite)Minecraft.getInstance().getTextureAtlas(TextureAtlas.LOCATION_BLOCKS).apply(stoneTextureId);
    }

    public ItemTransforms getTransforms() {
        return this.modelTransformation;
    }

    public void setModelTransformation(ItemTransforms transformation) {
        this.modelTransformation = transformation;
        this.childModels.forEach(childModel -> {
            if (childModel instanceof BakedSingleModel) {
                BakedSingleModel bakedSIngleModel = (BakedSingleModel)childModel;
                bakedSIngleModel.setModelTransformation(transformation);
            } else {
                Miapi.LOGGER.warn("childModel is not a Dynamic Model. This should not happen");
            }
        });
    }

    public ItemOverrides getOverrides() {
        if (this.overrideList instanceof DynamicOverrides && this.childModels.isEmpty()) {
            return ItemOverrides.EMPTY;
        }
        return this.overrideList;
    }

    public BakedModel optimize() {
        Map<Direction, List<BakedQuad>> bakedQuads = this.createEmpty();
        this.putDirectionalQuads(bakedQuads, this);
        LinkedHashMap<BakedSingleModelOverrides.ConditionHolder, Map> completeList = new LinkedHashMap<BakedSingleModelOverrides.ConditionHolder, Map>();
        this.childModels.forEach(child -> {
            if (child instanceof BakedSingleModel) {
                BakedSingleModel bakedSIngleModel = (BakedSingleModel)child;
                this.putDirectionalQuads(bakedQuads, (BakedModel)child);
                ItemOverrides patt0$temp = bakedSIngleModel.overrideList;
                if (patt0$temp instanceof DynamicBakery.DynamicOverrideList) {
                    DynamicBakery.DynamicOverrideList dynamicOverrideList = (DynamicBakery.DynamicOverrideList)patt0$temp;
                    for (DynamicBakery.DynamicOverrideList.DynamicBakedOverride overrides : dynamicOverrideList.dynamicOverrides) {
                        BakedSingleModelOverrides.ConditionHolder condition = overrides.conditionHolder;
                        assert (condition != null);
                        if (completeList.containsKey(condition)) continue;
                        completeList.put(condition, this.createEmpty());
                    }
                }
            }
        });
        this.childModels.forEach(child -> {
            if (child instanceof BakedSingleModel) {
                BakedSingleModel bakedSIngleModel = (BakedSingleModel)child;
                ItemOverrides patt0$temp = bakedSIngleModel.overrideList;
                if (patt0$temp instanceof DynamicBakery.DynamicOverrideList) {
                    DynamicBakery.DynamicOverrideList dynamicOverrideList = (DynamicBakery.DynamicOverrideList)patt0$temp;
                    completeList.forEach((conditionHolder, directionBakedQuadHashMap) -> {
                        int index = -1;
                        boolean fallback = true;
                        for (int i = 0; i < dynamicOverrideList.dynamicOverrides.length; ++i) {
                            BakedSingleModelOverrides.ConditionHolder otherCOndition = dynamicOverrideList.dynamicOverrides[i].conditionHolder;
                            if (dynamicOverrideList.dynamicOverrides[i].conditionHolder.equals(conditionHolder)) {
                                this.putDirectionalQuads((Map<Direction, List<BakedQuad>>)directionBakedQuadHashMap, dynamicOverrideList.dynamicOverrides[i].model);
                                fallback = false;
                            }
                            if (!conditionHolder.isAcceptable(otherCOndition)) continue;
                            index = i;
                        }
                        if (index == -1) {
                            this.putDirectionalQuads((Map<Direction, List<BakedQuad>>)directionBakedQuadHashMap, bakedSIngleModel);
                        } else if (fallback) {
                            this.putDirectionalQuads((Map<Direction, List<BakedQuad>>)directionBakedQuadHashMap, dynamicOverrideList.dynamicOverrides[index].model);
                        }
                    });
                }
            }
        });
        LinkedHashMap overrideModels = new LinkedHashMap();
        completeList.forEach((conditionHolder, directionBakedQuadHashMap) -> {
            List defaultList = (List)directionBakedQuadHashMap.get(null);
            defaultList = defaultList == null ? new ArrayList() : defaultList;
            SimpleBakedModel model = new SimpleBakedModel(defaultList, directionBakedQuadHashMap, true, false, true, this.getParticleIcon(), this.modelTransformation, ItemOverrides.EMPTY);
            overrideModels.put(conditionHolder, model);
        });
        ArrayList defaultList = bakedQuads.get(null);
        defaultList = defaultList == null ? new ArrayList() : defaultList;
        SimpleBakedModel model = new SimpleBakedModel(defaultList, bakedQuads, true, false, true, this.getParticleIcon(), this.modelTransformation, this.getOverrides());
        return model;
    }

    private Map<Direction, List<BakedQuad>> createEmpty() {
        HashMap<Direction, List<BakedQuad>> defaultMap = new HashMap<Direction, List<BakedQuad>>();
        for (Direction direction : Direction.values()) {
            defaultMap.put(direction, new ArrayList());
        }
        defaultMap.put(null, new ArrayList());
        return defaultMap;
    }

    private void putDirectionalQuads(Map<Direction, List<BakedQuad>> directionalQuads, BakedModel model) {
        model.getQuads(null, null, RandomSource.create()).forEach(bakedQuad -> {
            List list = directionalQuads.getOrDefault(bakedQuad.getDirection(), new ArrayList());
            list.add(bakedQuad);
        });
        for (Direction dir : Direction.values()) {
            model.getQuads(null, dir, RandomSource.create()).forEach(bakedQuad -> {
                if (bakedQuad.getDirection().equals((Object)dir)) {
                    List list = directionalQuads.getOrDefault(bakedQuad.getDirection(), new ArrayList());
                    list.add(bakedQuad);
                }
            });
        }
        for (Direction direction : Direction.values()) {
            directionalQuads.put(direction, this.cleanUp(directionalQuads.get(direction)));
        }
        directionalQuads.put(null, this.cleanUp(directionalQuads.get(null)));
    }

    private List<BakedQuad> cleanUp(List<BakedQuad> quads) {
        return quads;
    }

    class DynamicOverrides
    extends ItemOverrides {
        public DynamicOverrides() {
            super(DynamicBakery.dynamicBaker, null, new ArrayList());
        }

        public BakedModel resolve(BakedModel oldmodel, ItemStack stack, @Nullable ClientLevel world, @Nullable LivingEntity entity, int seed) {
            if (BakedSingleModel.this.overrideModel != null) {
                BakedSingleModel.this.overrideModel.childModels.clear();
                BakedSingleModel.this.overrideModel.quads.clear();
                BakedSingleModel.this.overrideModel.quads.addAll(BakedSingleModel.this.quads);
                BakedSingleModel.this.childModels.forEach(model -> {
                    if (model != null && model.getOverrides() != null) {
                        BakedModel override = model.getOverrides().resolve(model, stack, world, entity, seed);
                        BakedSingleModel.this.overrideModel.addModel(override);
                    } else {
                        BakedSingleModel.this.overrideModel.addModel((BakedModel)model);
                    }
                });
                return BakedSingleModel.this.overrideModel;
            }
            return oldmodel;
        }
    }
}

