/*
 * Decompiled with CFR 0.152.
 */
package smartin.miapi.client.renderer;

import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class RescaledVertexConsumer
implements VertexConsumer {
    public VertexConsumer delegate;
    float uStart;
    float uScale;
    float vStart;
    float vScale;

    public RescaledVertexConsumer(VertexConsumer delegate, TextureAtlasSprite sprite) {
        this.delegate = delegate;
        this.setSprite(sprite);
    }

    public void setSprite(TextureAtlasSprite sprite) {
        this.uStart = sprite.getU0();
        this.uScale = 1.0f / (sprite.getU1() - sprite.getU0());
        this.vStart = sprite.getV0();
        this.vScale = 1.0f / (sprite.getV1() - sprite.getV0());
    }

    public void addVertex(float x, float y, float z, int color, float u, float v, int packedOverlay, int packedLight, float normalX, float normalY, float normalZ) {
        u = (u - this.uStart) * this.uScale;
        v = (v - this.vStart) * this.vScale;
        this.addVertex(x, y, z);
        this.setColor(color);
        this.setUv(u, v);
        this.setOverlay(packedOverlay);
        this.setLight(packedLight);
        this.setNormal(normalX, normalY, normalZ);
    }

    public VertexConsumer addVertex(float x, float y, float z) {
        return this.delegate.addVertex(x, y, z);
    }

    public VertexConsumer setColor(int red, int green, int blue, int alpha) {
        return this.delegate.setColor(red, green, blue, alpha);
    }

    public VertexConsumer setUv(float u, float v) {
        return this.delegate.setUv(u, v);
    }

    public VertexConsumer setUv1(int u, int v) {
        return this.delegate.setUv1(u, v);
    }

    public VertexConsumer setOverlay(int v) {
        return this.delegate.setOverlay(v);
    }

    public VertexConsumer setUv2(int u, int v) {
        return this.delegate.setUv2(u, v);
    }

    public VertexConsumer setNormal(float x, float y, float z) {
        return this.delegate.setNormal(x, y, z);
    }
}

