/*
 * Decompiled with CFR 0.152.
 */
package smartin.miapi.config;

import com.redpxnda.nucleus.codec.auto.AutoCodec;
import com.redpxnda.nucleus.codec.auto.ConfigAutoCodec;
import com.redpxnda.nucleus.util.Comment;
import dev.architectury.platform.Platform;
import java.util.List;
import java.util.Optional;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffects;
import smartin.miapi.Miapi;
import smartin.miapi.loot.MaterialSwapLootFunction;
import smartin.miapi.loot.ModuleSwapLootFunction;

@ConfigAutoCodec.ConfigClassMarker
public class MiapiServerConfig {
    public static MiapiServerConfig INSTANCE = new MiapiServerConfig();
    @AutoCodec.Name(value="generated_materials")
    public GeneratedMaterialsCategory generatedMaterials = new GeneratedMaterialsCategory();
    public EnchantmentsCategory enchants = new EnchantmentsCategory();
    @AutoCodec.Name(value="stun_effect")
    public StunEffectCategory stunEffectCategory = new StunEffectCategory();
    public OtherCategory other = new OtherCategory();
    @AutoCodec.Name(value="loot_category")
    public LootModularisation lootCategory = new LootModularisation();

    @ConfigAutoCodec.ConfigClassMarker
    public static class GeneratedMaterialsCategory {
        @Comment(value="Whether Miapi should automatically generate materials based on modded items\nIf this is disabled, the other fields in this section will have no effect")
        @AutoCodec.Name(value="generate_materials")
        public boolean generateMaterials = true;
        @Comment(value="The maximum amount of materials generated per type")
        @AutoCodec.Name(value="max_generated_materials")
        public int maximumGeneratedMaterials = 200;
        @Comment(value="A regex used to prevent items matching the pattern from generating materials\nBy default this prevents chipped and everycompat from generating materials")
        @AutoCodec.Name(value="block_regex")
        public String blockRegex = "^(chipped|everycompat).*";
        @Comment(value="Whether Miapi should automatically generate materials based on modded wood related items")
        @AutoCodec.Name(value="generate_wood_materials")
        public boolean generateWoodMaterials = true;
        @Comment(value="Whether Miapi should automatically generate materials based on modded stone related items")
        @AutoCodec.Name(value="generate_stone_materials")
        public boolean generateStoneMaterials = true;
        @Comment(value="Whether Miapi should automatically generate materials based on modded tools")
        @AutoCodec.Name(value="generate_other_materials")
        public boolean generateOtherMaterials = true;
        @Comment(value="What Properties are generated")
        @AutoCodec.Name(value="generate_properties")
        public Properties properties = new Properties();

        @ConfigAutoCodec.ConfigClassMarker
        public static class Properties {
            @Comment(value="Whether the Attribute Property should copy the items other attributes for generated Materials")
            @AutoCodec.Name(value="attribute_property")
            public GeneratePropertyOption attributeProperty = new GeneratePropertyOption();
            @Comment(value="Whether the Crafting Enchantment Property should copy the items other attributes for generated Materials")
            @AutoCodec.Name(value="enchant_property")
            public GeneratePropertyOption enchantProperty = new GeneratePropertyOption();
            @Comment(value="Whether the Ability Property should copy the items abilities for generated Materials")
            @AutoCodec.Name(value="ability_property")
            public GeneratePropertyOption abilityProperty = new GeneratePropertyOption();
            @Comment(value="Whether the Tags of the Items should be copied as Material Properties for generated Materials")
            @AutoCodec.Name(value="tag_property")
            public GeneratePropertyOption tagProperty = new GeneratePropertyOption();
            @Comment(value="Whether the Item Lore of the Items should be copied as Material Properties for generated Materials")
            @AutoCodec.Name(value="lore_property")
            public GeneratePropertyOption loreProperty = new GeneratePropertyOption();
            @Comment(value="Whether the On Hit Effects of the Items should be attempted to be copied as Material Properties for generated Materials")
            @AutoCodec.Name(value="on_hit_property")
            public GeneratePropertyOption onHitProperty = new GeneratePropertyOption();
            @Comment(value="Whether Custom Components should be added to the generated Materials")
            @AutoCodec.Name(value="component_property")
            public GeneratePropertyOption componentProperty = new GeneratePropertyOption();
        }

        @ConfigAutoCodec.ConfigClassMarker
        public static class GeneratePropertyOption {
            @Comment(value="Whether this property is enabled at all")
            public boolean enable = true;
            @Comment(value="A list of blocked regexes, if any material causes issues add their id to here")
            public List<String> blocked = List.of();
        }
    }

    @ConfigAutoCodec.ConfigClassMarker
    public static class EnchantmentsCategory {
        @Comment(value="Whether loyalty should trigger in the void with Modular Items")
        @AutoCodec.Name(value="better_loyalty")
        public boolean betterLoyalty = true;
        @Comment(value="Whether base modular items should have a say in valid enchantments\nFor example, if this is true, a modular pickaxe will automatically be allowed pickaxe enchantments regardless of its modules")
        @AutoCodec.Name(value="lenient_enchantments")
        public boolean lenientEnchantments = false;
    }

    @ConfigAutoCodec.ConfigClassMarker
    public static class StunEffectCategory {
        @Comment(value="List of StatusEffects the player will get when stunned")
        @AutoCodec.Name(value="player_effects")
        public List<ResourceLocation> playerEffects = List.of(BuiltInRegistries.MOB_EFFECT.getKey((Object)((MobEffect)MobEffects.BLINDNESS.value())), BuiltInRegistries.MOB_EFFECT.getKey((Object)((MobEffect)MobEffects.MOVEMENT_SLOWDOWN.value())));
        @Comment(value="The Stun health of a default entity, the StunHealth determines how much stun damage is needed to stun.\nrequires restart to apply - may not correctly affect older worlds")
        @AutoCodec.Name(value="stun_health")
        public double stunHealth = 20.0;
        @Comment(value="The Time a Entity is stunned")
        @AutoCodec.Name(value="stun_length")
        public int stunLength = 100;
        @Comment(value="The Time a Entity is immune to stuns after being stunned")
        @AutoCodec.Name(value="stun_resistance_length")
        public int stunResistanceLength = 600;
        @Comment(value="Attack speed reduction for players while being stunned as a Player\nrequires restart to apply")
        @AutoCodec.Name(value="attack_speed_factor")
        public double attackSpeedFactor = 0.5;
    }

    @ConfigAutoCodec.ConfigClassMarker
    public static class OtherCategory {
        @Comment(value="Whether the development mode of Miapi is enabled\nDO NOT ENABLE IF U DO NOT KNOW WHAT IT DOES")
        @AutoCodec.Name(value="development_mode")
        public boolean developmentMode = Platform.isDevelopmentEnvironment();
        @Comment(value="Truly Modular Logs more aggressively\nHelps with debugging\n")
        @AutoCodec.Name(value="verbose_logging")
        public boolean verboseLogging = false;
        @Comment(value="If the same Lore Injections should happen on server as on the client\nDisabling this improves performance, but might let certain mods no longer find Modular Material or Items via search")
        @AutoCodec.Name(value="server_lore")
        public boolean serverLoreInjection = false;
        @Comment(value="If normal Converters should be generated for normal Materials\n")
        @AutoCodec.Name(value="generate_converters")
        public boolean generateConverters = true;
        @Comment(value="If this is on the Block Teleports effect of Truly Modular will block most teleports,\nif false it will only block default Ender man, Chorus fruit and Ender Pearls\n")
        @AutoCodec.Name(value="block_all_teleports_effects")
        public boolean blockAllTeleportsEffect = true;
        @Comment(value="This allows Truly Modular to dynamically reset its Tool-material\nSome mods might not like dynamic Tool-materials and cause issues with it,\nbut overall it should increase compatibility and help with Tool detection\n")
        @AutoCodec.Name(value="loose_tool_material")
        public boolean looseToolMaterial = true;
        @Comment(value="If this is true modular items will fully break.\nIf set to false Modular Item will instead to go into a Broken state\nIn this broken state they cant do anything but repaired.\nWARNING: some anvil reworking mods break the repairing logic. Please report those issues to us.\n")
        @AutoCodec.Name(value="full_break_modular_items")
        public boolean fullBreakModularItems = true;
        @Comment(value="Whether a miapi reload should be automatically forced on server start\nThis is enabled for compat reasons, sometimes scanning recipes and other stuff during a reload isnt stable\n")
        @AutoCodec.Name(value="reload_on_server_start")
        public boolean doubleReload = true;
        @Comment(value="How much of a Modules Durability is used to repair the Item\n")
        @AutoCodec.Name(value="repair_ratio")
        public double repairRatio = 1.0;
    }

    @ConfigAutoCodec.ConfigClassMarker
    public static class LootModularisation {
        @AutoCodec.Name(value="is_enabled")
        public boolean isEnabled = true;
        @AutoCodec.Name(value="is_swapping_modules_enabled")
        public boolean isSwappingModules = true;
        @AutoCodec.Name(value="is_swapping_materials_enabled")
        public boolean isSwappingMaterials = true;
        @AutoCodec.Name(value="material_swap_loot_functions")
        public MaterialSwapLootFunction materialSwapLootFunction = new MaterialSwapLootFunction(Miapi.id("empty"), -3.5, 0.4, 1.0, 0.8, 1.0, 1.0, 0.8, Optional.empty(), Optional.empty(), false);
        @AutoCodec.Name(value="module_swap_loot_functions")
        public ModuleSwapLootFunction moduleSwapLootFunction = new ModuleSwapLootFunction(Miapi.id("empty"), 0.5, Optional.empty(), Optional.empty(), false);
    }
}

