/*
 * Decompiled with CFR 0.152.
 */
package smartin.miapi.craft.stat;

import com.google.gson.JsonElement;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.MapLike;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.nbt.Tag;
import net.minecraft.util.ExtraCodecs;
import smartin.miapi.craft.stat.CraftingStat;
import smartin.miapi.modules.ModuleInstance;
import smartin.miapi.registries.RegistryInventory;

public class StatRequirementMap {
    protected final Map<CraftingStat<?>, Object> raw = new HashMap();

    public <T> T get(CraftingStat<T> key) {
        return (T)this.raw.get(key);
    }

    public <T> T put(CraftingStat<T> key, T value) {
        return (T)this.raw.put(key, value);
    }

    public void putAll(StatRequirementMap other) {
        this.raw.putAll(other.raw);
    }

    public <T> StatRequirementMap set(CraftingStat<T> key, T val) {
        this.raw.put(key, val);
        return this;
    }

    public <E> E getOrDefault(CraftingStat<E> stat) {
        E val = this.get(stat);
        if (val == null) {
            return stat.getDefault();
        }
        return val;
    }

    public Map<CraftingStat<?>, Object> getRaw() {
        return this.raw;
    }

    public static class Codec
    implements com.mojang.serialization.Codec<StatRequirementMap> {
        private final ModuleInstance modules;

        public Codec(ModuleInstance modules) {
            this.modules = modules;
        }

        public <T> DataResult<Pair<StatRequirementMap, T>> decode(DynamicOps<T> ops, T input) {
            StatRequirementMap stats = new StatRequirementMap();
            MapLike map = (MapLike)ops.getMap(input).getOrThrow(s -> new RuntimeException("Failed to create map in StatRequirementMapCodec! -> " + s));
            map.entries().forEach(p -> {
                String str = (String)ops.getStringValue(p.getFirst()).getOrThrow(s -> new RuntimeException("Failed to getVertexConsumer string value in StatRequirementMapCodec! -> " + s));
                CraftingStat stat = RegistryInventory.CRAFTING_STATS_REGISTRY.get(str);
                Object element = p.getSecond();
                if (stat != null) {
                    if (element instanceof JsonElement) {
                        JsonElement json = (JsonElement)element;
                        stats.set(stat, stat.createFromJson(json, this.modules));
                    } else if (element instanceof Tag) {
                        Tag nbt = (Tag)element;
                        stats.set(stat, stat.createFromNbt(nbt));
                    } else {
                        stats.set(stat, stat.createFromJson((JsonElement)ExtraCodecs.JSON.parse(ops, element).getOrThrow(s -> new RuntimeException("Failed to turn instance into a JsonElement while decoding a StatRequirementMap! -> " + s)), this.modules));
                    }
                }
            });
            return DataResult.success((Object)Pair.of((Object)stats, input));
        }

        public <T> DataResult<T> encode(StatRequirementMap input, DynamicOps<T> ops, T prefix) {
            HashMap map = new HashMap();
            input.raw.forEach((stat, inst) -> {
                Object obj = ExtraCodecs.JSON.encodeStart(ops, (Object)stat.saveToJson(inst)).getOrThrow(s -> new RuntimeException("Failed to turn instance into a JsonElement while encoding a StatRequirementMap! -> " + s));
                map.put(ops.createString(RegistryInventory.CRAFTING_STATS_REGISTRY.findKey((CraftingStat)stat).toString()), obj);
            });
            return DataResult.success((Object)ops.createMap(map));
        }
    }
}

