/*
 * Decompiled with CFR 0.152.
 */
package smartin.miapi.datapack;

import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.UnboundedMapCodec;
import dev.architectury.event.events.common.PlayerEvent;
import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.core.RegistryAccess;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import org.jetbrains.annotations.Nullable;
import smartin.miapi.Environment;
import smartin.miapi.Miapi;
import smartin.miapi.network.Networking;
import smartin.miapi.registries.MiapiRegistry;

public class ReloadEvents {
    public static MiapiRegistry<DataSyncer> dataSyncerRegistry = MiapiRegistry.getInstance(DataSyncer.class);
    private static final List<String> receivedSyncer = new ArrayList<String>();
    protected static final String RELOAD_PACKET_ID = "miapi:events_reload_s2c";
    public static final Map<ResourceLocation, String> DATA_PACKS = Collections.synchronizedMap(new LinkedHashMap());
    public static final Map<ResourceLocation, String> RAW_DATA_PACKS = Collections.synchronizedMap(new LinkedHashMap());
    public static Map<String, List<String>> syncedPaths = new HashMap<String, List<String>>();
    public static final ReloadEvent START = new ReloadEvent();
    public static final ReloadEvent MAIN = new ReloadEvent();
    public static final ReloadEvent END = new ReloadEvent();
    public static int reloadCounter = 0;
    private static long clientReloadTimeStart = System.nanoTime();

    public static void registerDataPackPathToSync(String modId, String path) {
        syncedPaths.computeIfAbsent(modId, k -> new ArrayList()).add(path);
    }

    public static void setup() {
        if (Environment.isClient()) {
            ReloadEvents.clientSetup();
        }
        Networking.registerC2SPacket(RELOAD_PACKET_ID, (buf, serverPlayerEntity) -> {
            Miapi.DEBUG_LOGGER.info("Recieved reload request from client!" + String.valueOf(serverPlayerEntity.getUUID()) + "! sending reload! " + Thread.currentThread().getName());
            boolean allowHandshake = buf.readBoolean();
            if (!allowHandshake) {
                Miapi.LOGGER.warn("Client " + String.valueOf(serverPlayerEntity.getUUID()) + " rejected reload? this should never happen!");
                Miapi.server.sendSystemMessage((Component)Component.literal((String)("Client " + String.valueOf(serverPlayerEntity.getDisplayName()) + " failed to reload.")));
            } else {
                ReloadEvents.triggerReloadOnClient(serverPlayerEntity);
            }
        });
        UnboundedMapCodec codec = Codec.unboundedMap((Codec)ResourceLocation.CODEC, Miapi.CHUNKED_STRING_CODEC);
        StreamCodec streamCodec = ByteBufCodecs.fromCodec((Codec)codec);
        dataSyncerRegistry.register(Miapi.id("data_packs"), (DataSyncer)new SimpleSyncer<Map<ResourceLocation, String>>(streamCodec){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Map<ResourceLocation, String> getDataServer() {
                LinkedHashMap<ResourceLocation, String> toSend;
                Map<ResourceLocation, String> map = DATA_PACKS;
                synchronized (map) {
                    toSend = new LinkedHashMap<ResourceLocation, String>(DATA_PACKS);
                }
                return toSend;
            }

            @Override
            public void interpretData(Map<ResourceLocation, String> data) {
                Minecraft.getInstance().execute(() -> {
                    Map<ResourceLocation, String> map = DATA_PACKS;
                    synchronized (map) {
                        DATA_PACKS.clear();
                        DATA_PACKS.putAll(data);
                    }
                    DataPackLoader.trigger(data);
                });
            }
        });
        PlayerEvent.PLAYER_JOIN.register(ReloadEvents::triggerReloadOnClient);
        START.subscribe((isClient, registryAccess) -> ++reloadCounter);
        END.subscribe((isClient, registryAccess) -> --reloadCounter);
        DataPackLoader.subscribe(dataPack -> {
            Map<ResourceLocation, String> map = DATA_PACKS;
            synchronized (map) {
                DATA_PACKS.clear();
                DATA_PACKS.putAll(dataPack);
            }
        });
    }

    public static void triggerReloadOnClient(ServerPlayer entity) {
        dataSyncerRegistry.getFlatMap().forEach((id, syncer) -> {
            FriendlyByteBuf buf = Networking.createBuffer();
            buf.writeUtf(id.toString());
            try {
                buf.writeByteArray(syncer.createDataServer().array());
                Networking.sendS2C(RELOAD_PACKET_ID, entity, buf);
            }
            catch (RuntimeException e) {
                Miapi.LOGGER.error("Datasyncer " + String.valueOf(id) + " was not able to create Packet with error ", (Throwable)e);
            }
        });
    }

    public static boolean isInReload() {
        return reloadCounter != 0;
    }

    private static void clientSetup() {
        Networking.registerS2CPacket(RELOAD_PACKET_ID, buffer -> {
            if (receivedSyncer.isEmpty()) {
                clientReloadTimeStart = System.nanoTime();
            }
            String receivedID = buffer.readUtf();
            receivedSyncer.add(receivedID);
            FriendlyByteBuf dataBuffer = Networking.createBuffer();
            dataBuffer.writeBytes(buffer.readByteArray());
            try {
                dataSyncerRegistry.get(receivedID).interpretDataClient(dataBuffer);
            }
            catch (RuntimeException exception) {
                Miapi.LOGGER.error("Exception during Reload Networking!", (Throwable)exception);
            }
            if (receivedSyncer.size() == dataSyncerRegistry.getFlatMap().keySet().size()) {
                receivedSyncer.clear();
                Minecraft.getInstance().execute(() -> {
                    ++reloadCounter;
                    Object access = Minecraft.getInstance().level != null ? Minecraft.getInstance().level.registryAccess() : Minecraft.getInstance().getConnection().registryAccess();
                    START.fireEvent(true, (RegistryAccess)access);
                    MAIN.fireEvent(true, (RegistryAccess)access);
                    END.fireEvent(true, (RegistryAccess)access);
                    --reloadCounter;
                    Miapi.LOGGER.info("Client load took " + (double)(System.nanoTime() - clientReloadTimeStart) / 1000.0 / 1000.0 + " ms");
                });
            }
        });
    }

    public static class ReloadEvent {
        private final Map<EventListener, Float> mainListeners = new HashMap<EventListener, Float>();

        public void subscribe(EventListener listener, float priority) {
            this.mainListeners.put(listener, Float.valueOf(priority));
        }

        public void subscribe(EventListener listener) {
            this.subscribe(listener, 0.0f);
        }

        public void unsubscribe(EventListener listener) {
            this.mainListeners.remove(listener);
        }

        public void fireEvent(boolean isClient, @Nullable RegistryAccess registryAccess) {
            try {
                this.mainListeners.entrySet().stream().sorted(Map.Entry.comparingByValue()).forEach(eventListenerFloatEntry -> {
                    try {
                        ((EventListener)eventListenerFloatEntry.getKey()).onEvent(isClient, registryAccess);
                    }
                    catch (RuntimeException e) {
                        Miapi.LOGGER.error("Exception during reload", (Throwable)e);
                    }
                });
            }
            catch (RuntimeException e) {
                Miapi.LOGGER.error("Exception during Reload!", (Throwable)e);
            }
        }
    }

    @FunctionalInterface
    public static interface EventListener {
        public void onEvent(boolean var1, @Nullable RegistryAccess var2);
    }

    public static class DataPackLoader {
        protected static final List<EventListener> listeners = new ArrayList<EventListener>();

        public static void subscribe(EventListener listener) {
            listeners.add(listener);
        }

        public static void unsubscribe(EventListener listener) {
            listeners.remove(listener);
        }

        public static void trigger(Map<ResourceLocation, String> dataPack) {
            for (EventListener listener : listeners) {
                try {
                    listener.onEvent(dataPack);
                }
                catch (Exception e) {
                    Miapi.LOGGER.error("Exception during reload", (Throwable)e);
                }
            }
        }

        public static interface EventListener {
            public void onEvent(Map<ResourceLocation, String> var1);
        }
    }

    public static interface DataSyncer<T> {
        public FriendlyByteBuf createDataServer();

        public void interpretDataClient(FriendlyByteBuf var1);
    }

    public static abstract class SimpleSyncer<T>
    implements DataSyncer {
        public StreamCodec<ByteBuf, T> streamCodec;

        public SimpleSyncer(StreamCodec<ByteBuf, T> streamCodec) {
            this.streamCodec = streamCodec;
        }

        public abstract T getDataServer();

        public abstract void interpretData(T var1);

        @Override
        public FriendlyByteBuf createDataServer() {
            FriendlyByteBuf buf = Networking.createBuffer();
            this.streamCodec.encode((Object)buf, this.getDataServer());
            return buf;
        }

        @Override
        public void interpretDataClient(FriendlyByteBuf buf) {
            this.interpretData(this.streamCodec.decode((Object)buf));
        }
    }
}

