/*
 * Decompiled with CFR 0.152.
 */
package smartin.miapi.editor;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;

public class DocPage {
    public static final Codec<DocPage> CODEC = Codec.recursive((String)"module_instance", selfCodec -> RecordCodecBuilder.create(instance -> instance.group((App)Codec.STRING.optionalFieldOf("header", (Object)"no header").forGetter(p -> p.header), (App)Codec.STRING.optionalFieldOf("description", (Object)"no header").forGetter(p -> p.description), (App)Codec.unboundedMap((Codec)Codec.STRING, (Codec)Codec.lazyInitialized(() -> selfCodec)).optionalFieldOf("sub_pages", Map.of()).forGetter(p -> p.sub_pages), (App)Codec.unboundedMap((Codec)Codec.STRING, (Codec)Codec.STRING).optionalFieldOf("data", Map.of()).forGetter(p -> p.data), (App)Codec.STRING.optionalFieldOf("java").forGetter(p -> p.java), (App)Codec.STRING.listOf().optionalFieldOf("key_words", List.of()).forGetter(p -> p.key_words)).apply((Applicative)instance, DocPage::new)));
    public static Map<Class, DocPage> PAGE_LOOKUP = new HashMap<Class, DocPage>();
    public final String header;
    public final String description;
    public final Map<String, String> data;
    public final Map<String, DocPage> sub_pages;
    public final Optional<String> java;
    public final List<String> key_words;

    public DocPage(String header, String description, Map<String, DocPage> sub_pages, Map<String, String> data, Optional<String> java, List<String> key_words) {
        this.header = header;
        this.description = description;
        this.sub_pages = sub_pages;
        this.data = data;
        this.java = java;
        this.key_words = key_words;
    }

    public static void setupLookup(DocPage docPage) {
        if (docPage.java.isPresent()) {
            try {
                Class<?> thisClass = docPage.getClass();
                String finalPath = docPage.java.get().replace("common/src/main/java/", "").replaceAll("/", ".").replace(".java", "");
                Class<?> c = Class.forName(finalPath);
                PAGE_LOOKUP.put(c, docPage);
            }
            catch (ClassNotFoundException | RuntimeException exception) {
                // empty catch block
            }
        }
        docPage.sub_pages.forEach((id, subPage) -> DocPage.setupLookup(subPage));
    }
}

