/*
 * Decompiled with CFR 0.152.
 */
package smartin.miapi.editor;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import dev.architectury.event.EventResult;
import dev.architectury.platform.Platform;
import java.util.function.Function;
import net.minecraft.client.Minecraft;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.item.ItemStack;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import smartin.miapi.Miapi;
import smartin.miapi.blueprint.BlueprintComponent;
import smartin.miapi.config.MiapiConfig;
import smartin.miapi.editor.EditorEvents;
import smartin.miapi.editor.JsonEditor;
import smartin.miapi.editor.LiveDataPackEditorManager;
import smartin.miapi.editor.MiapiEditor;
import smartin.miapi.editor.ModuleEditor;
import smartin.miapi.editor.NucleusEditor;
import smartin.miapi.editor.material.MaterialEditor;
import smartin.miapi.editor.syntax.CodecValidatorInterface;
import smartin.miapi.editor.syntax.JsonSyntaxHighlighter;
import smartin.miapi.editor.syntax.PropertyMapHighlighter;
import smartin.miapi.material.CodecMaterial;
import smartin.miapi.material.MaterialProperty;
import smartin.miapi.modules.ItemModule;
import smartin.miapi.modules.ModuleInstance;
import smartin.miapi.modules.abilities.key.MiapiBinding;
import smartin.miapi.modules.synergies.SynergyManager;

public class EditorCommands {
    public static void register(CommandDispatcher<CommandSourceStack> dispatcher) {
        LiteralArgumentBuilder runPose = (LiteralArgumentBuilder)Commands.literal((String)"miapi").then(Commands.literal((String)"editor").then(Commands.literal((String)"hand").executes(EditorCommands::executeHandEditor)));
        LiteralArgumentBuilder fs = (LiteralArgumentBuilder)Commands.literal((String)"miapi").then(Commands.literal((String)"editor").then(Commands.literal((String)"data").executes(EditorCommands::executeOpenEditor)));
        LiteralArgumentBuilder materialEditor = (LiteralArgumentBuilder)Commands.literal((String)"miapi").then(Commands.literal((String)"editor").then(Commands.literal((String)"material").executes(EditorCommands::executeOpenMaterialEditor)));
        dispatcher.register(runPose);
        dispatcher.register(fs);
        dispatcher.register(materialEditor);
        if (Platform.getEnv() == Dist.CLIENT) {
            EditorCommands.registerClient();
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    private static void registerClient() {
        JsonEditor.registerGlobalInterface(new JsonSyntaxHighlighter());
        JsonEditor.registerGlobalInterface(new PropertyMapHighlighter());
        CodecValidatorInterface synergyValidator = new CodecValidatorInterface(SynergyManager.SYNERGY_CODEC, "Synergy Validator");
        JsonEditor.registerGlobalInterface(synergyValidator);
        EditorEvents.EDITOR_INTERFACES.register(event -> {
            if (event.filePath.endsWith(".json")) {
                event.interfaces.add(new JsonSyntaxHighlighter());
            }
            return EventResult.pass();
        });
        EditorEvents.EDITOR_INTERFACES.register(event -> {
            if (event.resourceLocation != null && event.resourceLocation.getPath().startsWith("miapi/modules/")) {
                event.interfaces.add(new PropertyMapHighlighter(event.resourceLocation));
            }
            if (event.resourceLocation != null && event.resourceLocation.getPath().startsWith("miapi/synergies/")) {
                event.interfaces.add(new CodecValidatorInterface(SynergyManager.SYNERGY_CODEC, "Synergy Validator"));
            }
            if (event.resourceLocation != null && event.resourceLocation.getPath().startsWith("miapi/modular_converters/")) {
                event.interfaces.add(new CodecValidatorInterface(ModuleInstance.CODEC, "Modular Converter Validator"));
            }
            if (event.resourceLocation != null && event.resourceLocation.getPath().startsWith("miapi/material/")) {
                event.interfaces.add(new CodecValidatorInterface(CodecMaterial.CODEC, "Material Validator"));
            }
            if (event.resourceLocation != null && event.resourceLocation.getPath().startsWith("miapi/blueprints/")) {
                event.interfaces.add(new CodecValidatorInterface(BlueprintComponent.CODEC, "Blueprint Validator"));
            }
            if (event.resourceLocation != null && event.resourceLocation.getPath().startsWith("miapi/key_binding")) {
                event.interfaces.add(new CodecValidatorInterface(MiapiBinding.CODEC, "KeyBind Validator"));
            }
            if (event.resourceLocation == null || event.resourceLocation.getPath().startsWith("miapi/create_options/")) {
                // empty if block
            }
            if (event.resourceLocation == null || event.resourceLocation.getPath().startsWith("miapi/material_extension/")) {
                // empty if block
            }
            if (event.resourceLocation == null || event.resourceLocation.getPath().startsWith("miapi/module_extension/")) {
                // empty if block
            }
            if (event.resourceLocation == null || event.resourceLocation.getPath().startsWith("miapi/skin/module")) {
                // empty if block
            }
            if (event.resourceLocation == null || event.resourceLocation.getPath().startsWith("miapi/skin/tab")) {
                // empty if block
            }
            return EventResult.pass();
        });
        if (Platform.isModLoaded((String)"nucleus_editor")) {
            NucleusEditor.setup();
        } else if (MiapiConfig.getClientConfig().other.allowEditorNoNucleus) {
            // empty if block
        }
    }

    private static int executeHandEditor(CommandContext<CommandSourceStack> context) {
        return EditorCommands.canExecute(context, c -> {
            ItemStack itemStack = ((CommandSourceStack)context.getSource()).getPlayer().getItemInHand(InteractionHand.MAIN_HAND);
            ModuleInstance moduleInstance = ItemModule.getModules(itemStack);
            if (moduleInstance != null) {
                ModuleEditor moduleEditor = new ModuleEditor(moduleInstance.copy(), m -> m.copy().writeToItem(itemStack));
                MiapiEditor.editors.add(moduleEditor);
                return 1;
            }
            ((CommandSourceStack)context.getSource()).sendFailure((Component)Component.literal((String)"Hand Item is not a valid modular item!"));
            return -1;
        });
    }

    private static int executeOpenEditor(CommandContext<CommandSourceStack> context) {
        return EditorCommands.canExecute(context, c -> {
            MiapiEditor.editors.add(new LiveDataPackEditorManager());
            return 1;
        });
    }

    private static int executeOpenMaterialEditor(CommandContext<CommandSourceStack> context) {
        ((CommandSourceStack)context.getSource()).sendFailure((Component)Component.literal((String)"Material editor is not yet finished!"));
        return 1;
    }

    public static int canExecute(CommandContext<CommandSourceStack> context, Function<CommandContext<CommandSourceStack>, Integer> onExecute) {
        if (((CommandSourceStack)context.getSource()).isPlayer()) {
            if (Platform.getEnv().equals((Object)Dist.DEDICATED_SERVER)) {
                ((CommandSourceStack)context.getSource()).sendFailure((Component)Component.literal((String)"Command only allowed in SinglePlayer"));
                return -1;
            }
            if (!Minecraft.getInstance().player.getUUID().equals(((CommandSourceStack)context.getSource()).getPlayer().getUUID())) {
                ((CommandSourceStack)context.getSource()).sendFailure((Component)Component.literal((String)"Command only allowed in SinglePlayer"));
                return -1;
            }
            if (!((CommandSourceStack)context.getSource()).hasPermission(4)) {
                ((CommandSourceStack)context.getSource()).sendFailure((Component)Component.literal((String)"Command only allowed for operators"));
                return -1;
            }
            if (!MiapiConfig.getClientConfig().other.allowEditorNoNucleus && !Platform.isModLoaded((String)"nucleus_editor")) {
                ((CommandSourceStack)context.getSource()).sendFailure((Component)Component.literal((String)"Requires Nucleus Editor to be installed!"));
                return -1;
            }
            return onExecute.apply(context);
        }
        ((CommandSourceStack)context.getSource()).sendFailure((Component)Component.literal((String)"Only Player can execute this command!"));
        return -1;
    }

    private static /* synthetic */ Integer lambda$executeOpenMaterialEditor$6(CommandContext c) {
        MiapiEditor.editors.add(new MaterialEditor((CodecMaterial)MaterialProperty.MATERIAL_REGISTRY.get(Miapi.id("metal/iron")), m -> {}));
        return 1;
    }
}

