/*
 * Decompiled with CFR 0.152.
 */
package smartin.miapi.editor;

import com.google.gson.JsonElement;
import com.google.gson.JsonParser;
import imgui.ImGui;
import imgui.type.ImBoolean;
import imgui.type.ImString;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardWatchEventKinds;
import java.nio.file.WatchEvent;
import java.nio.file.WatchKey;
import java.nio.file.WatchService;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import net.minecraft.client.DeltaTracker;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.resources.ResourceLocation;
import smartin.miapi.editor.EditorEvents;
import smartin.miapi.editor.MiapiEditor;
import smartin.miapi.editor.registry.RegistryViewer;
import smartin.miapi.editor.syntax.EditorInterface;
import smartin.miapi.modules.properties.util.EditorError;
import smartin.miapi.registries.MiapiRegistry;

public class JsonEditor
implements MiapiEditor {
    private final ImBoolean show = new ImBoolean(true);
    private final ImString content = new ImString(4096);
    private final Consumer<String> onChange;
    private JsonElement currentJson;
    private final Map<ResourceLocation, EditorInterface> interfaces = new HashMap<ResourceLocation, EditorInterface>();
    private final List<EditorInterface> activeInterfaces = new ArrayList<EditorInterface>();
    private final List<EditorError> currentErrors = new ArrayList<EditorError>();
    private static final Map<ResourceLocation, EditorInterface> GLOBAL_INTERFACES = new HashMap<ResourceLocation, EditorInterface>();
    public static int padding = 2;
    public boolean showErrors = false;
    private boolean readOnly = false;
    private boolean watchFile = true;
    private boolean reloadOnChange = false;
    private Path filePath;
    private WatchService watchService;
    private WatchKey watchKey;
    private long lastModified = 0L;
    public ResourceLocation resourceLocation;
    public boolean closeOnNoError = false;
    boolean skipNext = false;

    public JsonEditor(String initialContent, Consumer<String> onChange) {
        this(initialContent, onChange, null, null);
    }

    public JsonEditor(String initialContent, Consumer<String> onChange, Path filePath) {
        this(initialContent, onChange, filePath, null);
    }

    public JsonEditor(String initialContent, Consumer<String> onChange, Path filePath, ResourceLocation resourceLocation) {
        this.content.set(initialContent);
        this.onChange = onChange;
        this.filePath = filePath;
        this.resourceLocation = resourceLocation;
        if (resourceLocation != null && filePath != null) {
            ArrayList<EditorInterface> eventInterfaces = new ArrayList<EditorInterface>();
            ((EditorEvents.EditorInterfaceEvent)EditorEvents.EDITOR_INTERFACES.invoker()).onGetInterfaces(new EditorEvents.EditorInterfaceData(resourceLocation, filePath.toString(), eventInterfaces));
            eventInterfaces.forEach(iface -> {
                this.interfaces.put(iface.getId(), (EditorInterface)iface);
                this.activeInterfaces.add((EditorInterface)iface);
            });
        }
        this.validateContent();
        this.setupFileWatcher();
    }

    private void setupFileWatcher() {
        if (this.filePath != null) {
            try {
                this.watchService = this.filePath.getFileSystem().newWatchService();
                this.watchKey = this.filePath.getParent().register(this.watchService, StandardWatchEventKinds.ENTRY_MODIFY);
                this.lastModified = Files.getLastModifiedTime(this.filePath, new LinkOption[0]).toMillis();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    private void checkFileChanges() {
        if (!this.watchFile || this.watchService == null) {
            return;
        }
        try {
            WatchKey key = this.watchService.poll();
            if (key != null) {
                for (WatchEvent<?> event : key.pollEvents()) {
                    long newLastModified;
                    Path changed = (Path)event.context();
                    if (!this.filePath.getFileName().equals(changed) || (newLastModified = Files.getLastModifiedTime(this.filePath, new LinkOption[0]).toMillis()) <= this.lastModified) continue;
                    if (this.skipNext) {
                        this.skipNext = !this.skipNext;
                        return;
                    }
                    this.lastModified = newLastModified;
                    this.reloadFile();
                    if (!this.reloadOnChange) continue;
                    this.onChange.accept(this.content.get());
                }
                key.reset();
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void reloadFile() {
        if (this.filePath != null) {
            try {
                String newContent = Files.readString(this.filePath);
                this.content.set(newContent);
                this.validateContent();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public void setReadOnly(boolean readOnly) {
        this.readOnly = readOnly;
    }

    public static void registerGlobalInterface(EditorInterface editorInterface) {
        GLOBAL_INTERFACES.put(editorInterface.getId(), editorInterface);
    }

    public void addInterface(EditorInterface editorInterface) {
        this.interfaces.put(editorInterface.getId(), editorInterface);
        this.activeInterfaces.add(editorInterface);
        this.validateContent();
    }

    public void removeInterface(ResourceLocation id) {
        EditorInterface removed = this.interfaces.remove(id);
        if (removed != null) {
            this.activeInterfaces.remove(removed);
            this.validateContent();
        }
    }

    private void validateContent() {
        this.currentErrors.clear();
        try {
            this.currentJson = JsonParser.parseString((String)this.content.get());
            for (EditorInterface iface : this.activeInterfaces) {
                this.currentErrors.addAll(iface.validateContent(this.currentJson, this.content.get()));
            }
        }
        catch (Exception e) {
            this.currentJson = null;
            this.currentErrors.add(new EditorError(this.getLineNumber(this.content.get(), e.getMessage()), e.getMessage(), EditorError.ErrorSeverity.ERROR));
        }
    }

    private int getLineNumber(String content, String errorMessage) {
        try {
            if (errorMessage.contains("line")) {
                String[] parts = errorMessage.split("line");
                return Integer.parseInt(parts[1].trim().split(" ")[0]);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return 1;
    }

    @Override
    public void render(GuiGraphics guiGraphics, DeltaTracker deltaTracker) {
        if (!this.show.get()) {
            return;
        }
        boolean hasErrors = false;
        this.checkFileChanges();
        ImGui.pushID((String)this.resourceLocation.toString());
        ImGui.setNextWindowSize((float)800.0f, (float)600.0f, (int)4);
        if (ImGui.begin((String)("JSON Editor " + String.valueOf(this.resourceLocation)), (ImBoolean)this.show)) {
            float windowWidth = ImGui.getWindowWidth();
            float windowHeight = ImGui.getWindowHeight();
            if (ImGui.button((String)"Save") && this.currentJson != null && !this.readOnly) {
                this.save(this.content.get());
                this.onChange.accept(this.content.get());
            }
            ImGui.sameLine();
            if (ImGui.button((String)"Format") && !this.readOnly) {
                try {
                    if (this.currentJson != null) {
                        this.content.set(this.currentJson.toString());
                        this.validateContent();
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if (this.filePath != null) {
                ImGui.sameLine();
                if (ImGui.button((String)"Reload")) {
                    this.reloadFile();
                }
                ImGui.sameLine();
                if (ImGui.checkbox((String)"Watch File", (boolean)this.watchFile)) {
                    this.watchFile = !this.watchFile;
                }
                ImGui.sameLine();
                if (ImGui.checkbox((String)"Auto Reload", (boolean)this.reloadOnChange)) {
                    boolean bl = this.reloadOnChange = !this.reloadOnChange;
                }
            }
            if (ImGui.button((String)"Dropdown")) {
                ImGui.openPopup((String)("DropdownMenu" + String.valueOf(this.resourceLocation)));
            }
            if (ImGui.beginPopup((String)("DropdownMenu" + String.valueOf(this.resourceLocation)))) {
                for (MiapiRegistry miapiRegistry : MiapiRegistry.REGISTRY_MAP.values()) {
                    if (!ImGui.menuItem((String)miapiRegistry.getName())) continue;
                    MiapiEditor.editors.add(new RegistryViewer(miapiRegistry));
                }
                ImGui.endPopup();
            }
            if (this.readOnly) {
                ImGui.sameLine();
                ImGui.textColored((float)1.0f, (float)0.7f, (float)0.0f, (float)1.0f, (String)"Read Only");
            }
            for (EditorInterface editorInterface : this.activeInterfaces) {
                Map<String, Runnable> buttons = editorInterface.toolbarButtons();
                for (Map.Entry<String, Runnable> button : buttons.entrySet()) {
                    ImGui.sameLine();
                    if (!ImGui.button((String)button.getKey())) continue;
                    button.getValue().run();
                }
            }
            float toolbarHeight = ImGui.getFrameHeightWithSpacing();
            String[] stringArray = this.content.get().split("\n", -1);
            float lineHeight = ImGui.getTextLineHeight();
            float desiredHeight = (float)stringArray.length * lineHeight + ImGui.getStyle().getWindowPaddingY() * 2.0f;
            float contentHeight = windowHeight - toolbarHeight - ImGui.getStyle().getWindowPaddingY() * 8.0f;
            ImGui.separator();
            float gutterWidth = 40.0f;
            float editorWidth = windowWidth - ImGui.getStyle().getWindowPaddingX() * 2.0f;
            float mainEditorWidth = editorWidth - gutterWidth;
            HashMap<Integer, EditorError> errorsByLine = new HashMap<Integer, EditorError>();
            for (EditorError error : this.currentErrors) {
                errorsByLine.put(error.line(), error);
            }
            if (ImGui.beginChild((String)("EditorContainer" + String.valueOf(this.resourceLocation)), (float)editorWidth, (float)contentHeight, (boolean)true)) {
                if (ImGui.beginChild((String)("EditorScrollContainer" + String.valueOf(this.resourceLocation)), (float)editorWidth, (float)(desiredHeight + ImGui.getStyle().getWindowPaddingY() * 2.0f), (boolean)true)) {
                    float scrollY = ImGui.getScrollY();
                    ImGui.beginChild((String)("Gutter" + String.valueOf(this.resourceLocation)), (float)gutterWidth, (float)desiredHeight, (boolean)false);
                    ImGui.setScrollY((float)ImGui.getScrollY());
                    float currentY = 0.0f;
                    for (int i = 0; i < stringArray.length; ++i) {
                        ImGui.setCursorPosY((float)currentY);
                        EditorError error = (EditorError)errorsByLine.get(i + 1);
                        if (error != null) {
                            hasErrors = true;
                            float[] color = this.getErrorColor(error.severity());
                            ImGui.pushStyleColor((int)0, (float)color[0], (float)color[1], (float)color[2], (float)1.0f);
                            ImGui.text((String)("\u26a0" + (i + 1)));
                            if (ImGui.isItemHovered()) {
                                ImGui.beginTooltip();
                                ImGui.pushTextWrapPos((float)300.0f);
                                ImGui.textColored((float)color[0], (float)color[1], (float)color[2], (float)1.0f, (String)error.message());
                                ImGui.popTextWrapPos();
                                ImGui.endTooltip();
                            }
                            ImGui.popStyleColor();
                        } else {
                            ImGui.textDisabled((String)("" + (i + 1)));
                        }
                        currentY += lineHeight;
                    }
                    ImGui.endChild();
                    ImGui.sameLine();
                    ImGui.beginChild((String)("MainEditor" + String.valueOf(this.resourceLocation)), (float)mainEditorWidth, (float)desiredHeight, (boolean)false);
                    ImGui.setScrollY((float)scrollY);
                    int inputFlags = 1024;
                    if (this.readOnly) {
                        inputFlags |= 0x4000;
                    }
                    if (ImGui.isWindowFocused()) {
                        if (ImGui.inputTextMultiline((String)("##content" + String.valueOf(this.resourceLocation)), (ImString)this.content, (float)(mainEditorWidth - ImGui.getStyle().getWindowPaddingX()), (float)desiredHeight, (int)inputFlags)) {
                            this.validateContent();
                        }
                    } else {
                        ImGui.textUnformatted((String)this.content.get());
                    }
                    ImGui.endChild();
                    ImGui.endChild();
                }
                ImGui.endChild();
            }
            ImGui.end();
        }
        ImGui.popID();
        if (this.closeOnNoError && !hasErrors) {
            this.save(this.content.get());
            this.close();
            MiapiEditor.editors.remove(this);
        }
    }

    public void save(String newContent) {
        try {
            this.skipNext = true;
            Files.writeString(this.filePath, (CharSequence)newContent, new OpenOption[0]);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private float[] getErrorColor(EditorError.ErrorSeverity severity) {
        float[] fArray;
        switch (severity) {
            default: {
                throw new MatchException(null, null);
            }
            case ERROR: {
                float[] fArray2 = new float[4];
                fArray2[0] = 1.0f;
                fArray2[1] = 0.0f;
                fArray2[2] = 0.0f;
                fArray = fArray2;
                fArray2[3] = 1.0f;
                break;
            }
            case WARNING: {
                float[] fArray3 = new float[4];
                fArray3[0] = 1.0f;
                fArray3[1] = 0.8f;
                fArray3[2] = 0.0f;
                fArray = fArray3;
                fArray3[3] = 1.0f;
                break;
            }
            case INFO: {
                float[] fArray4 = new float[4];
                fArray4[0] = 0.0f;
                fArray4[1] = 0.8f;
                fArray4[2] = 1.0f;
                fArray = fArray4;
                fArray4[3] = 1.0f;
            }
        }
        return fArray;
    }

    @Override
    public void close() {
        if (this.watchService != null) {
            try {
                this.watchService.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    private record ErrorSection(int line, EditorError error) implements Section
    {
    }

    private record ContentSection(int start, int end, String[] lines) implements Section
    {
    }

    private static sealed interface Section
    permits ContentSection, ErrorSection {
    }
}

