/*
 * Decompiled with CFR 0.152.
 */
package smartin.miapi.editor.material;

import imgui.ImGui;
import imgui.type.ImBoolean;
import imgui.type.ImString;
import java.util.HashMap;
import java.util.function.Consumer;
import net.minecraft.client.DeltaTracker;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.resources.ResourceLocation;
import smartin.miapi.Miapi;
import smartin.miapi.editor.MiapiEditor;
import smartin.miapi.editor.material.GroupEditor;
import smartin.miapi.editor.material.IconEditor;
import smartin.miapi.editor.material.IngredientEditor;
import smartin.miapi.editor.material.PropertyEditor;
import smartin.miapi.editor.material.StatsEditor;
import smartin.miapi.editor.util.ListEditor;
import smartin.miapi.material.CodecMaterial;

public class MaterialEditor
implements MiapiEditor {
    private final ImBoolean show = new ImBoolean(true);
    private final ImString materialId = new ImString(128);
    private final CodecMaterial material;
    private final Consumer<CodecMaterial> onChange;
    private final PropertyEditor regularPropertyEditor;
    private final PropertyEditor displayPropertyEditor;
    private final PropertyEditor hiddenPropertyEditor;
    private final IconEditor iconEditor;
    private final IngredientEditor ingredientEditor;
    private final StatsEditor statsEditor;
    private final GroupEditor groupEditor;
    private final ListEditor<String> textureKeys;

    public MaterialEditor(CodecMaterial material, Consumer<CodecMaterial> onChange) {
        this.material = material;
        this.onChange = onChange;
        this.materialId.set(material.getID().toString());
        this.regularPropertyEditor = new PropertyEditor("Properties", material.getActualProperty().computeIfAbsent("default", a -> material.getActualProperty().computeIfAbsent((String)a, s -> new HashMap())));
        this.displayPropertyEditor = new PropertyEditor("Display Properties", material.getActualProperty().computeIfAbsent("default", a -> material.getActualProperty().computeIfAbsent((String)a, s -> new HashMap())));
        this.hiddenPropertyEditor = new PropertyEditor("Hidden Properties", material.getActualProperty().computeIfAbsent("default", a -> material.getActualProperty().computeIfAbsent((String)a, s -> new HashMap())));
        this.iconEditor = new IconEditor(material);
        this.ingredientEditor = new IngredientEditor(material);
        this.statsEditor = new StatsEditor(material);
        this.groupEditor = new GroupEditor(material);
        this.textureKeys = new ListEditor<String>("Texture Keys", material.getTextureKeys(), nextGroups -> {
            material.textureKeys = nextGroups;
        }, (id, number) -> {
            ImString string = new ImString(id);
            return () -> {
                ImGui.pushID((String)("texture" + id + number));
                ImGui.inputText((String)"", (ImString)string);
                ImGui.popID();
                return string.get();
            };
        }, () -> "texture");
    }

    private void renderMaterialProperties() {
        ImGui.separator();
        if (ImGui.inputText((String)"Material ID", (ImString)this.materialId, (int)0)) {
            try {
                ResourceLocation id = Miapi.id(this.materialId.get());
                this.material.setID(id);
            }
            catch (Exception e) {
                ImGui.text((String)"Invalid ID format!");
            }
        }
        ImGui.separator();
        this.iconEditor.render();
        this.statsEditor.render();
        this.ingredientEditor.render();
        this.groupEditor.render();
        this.textureKeys.render();
        if (ImGui.collapsingHeader((String)"Properties")) {
            this.regularPropertyEditor.render();
            this.displayPropertyEditor.render();
            this.hiddenPropertyEditor.render();
        }
    }

    @Override
    public void render(GuiGraphics guiGraphics, DeltaTracker deltaTracker) {
        if (!this.show.get()) {
            return;
        }
        ImGui.setNextWindowSize((float)600.0f, (float)400.0f, (int)4);
        if (ImGui.begin((String)"Material Editor", (ImBoolean)this.show)) {
            this.renderMaterialProperties();
            if (ImGui.button((String)"Save")) {
                this.onChange.accept(this.material);
            }
        }
        ImGui.end();
    }
}

