/*
 * Decompiled with CFR 0.152.
 */
package smartin.miapi.editor.syntax;

import com.google.gson.JsonElement;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import net.minecraft.resources.ResourceLocation;
import org.jetbrains.annotations.Nullable;
import smartin.miapi.Miapi;
import smartin.miapi.blueprint.IngredientWithCount;
import smartin.miapi.editor.syntax.EditorInterface;
import smartin.miapi.material.CodecMaterial;
import smartin.miapi.modules.properties.util.EditorError;

public class CodecMaterialEditorInterface
implements EditorInterface {
    private final ResourceLocation id = Miapi.id("material_editor");

    @Override
    public List<EditorError> validateContent(@Nullable JsonElement json, String rawContent) {
        ArrayList<EditorError> errors = new ArrayList<EditorError>();
        if (json == null) {
            errors.add(new EditorError(1, "Invalid JSON", EditorError.ErrorSeverity.ERROR));
            return errors;
        }
        try {
            Optional result = CodecMaterial.CODEC.decode((DynamicOps)JsonOps.INSTANCE, (Object)((JsonElement)CodecMaterial.CODEC.encodeStart((DynamicOps)JsonOps.INSTANCE, (Object)new CodecMaterial(Optional.empty(), Optional.empty(), Optional.empty(), new ArrayList<String>(), new ArrayList<String>(), new ArrayList<String>(), new HashMap<String, JsonElement>(), new HashMap<String, JsonElement>(), new HashMap<String, JsonElement>(), List.of("default"), Optional.empty(), Optional.empty(), new ArrayList<IngredientWithCount>(), Optional.empty())).getOrThrow())).result();
            if (result.isEmpty()) {
                errors.add(new EditorError(1, "Failed to decode material: Invalid format", EditorError.ErrorSeverity.ERROR));
            }
        }
        catch (Exception e) {
            errors.add(new EditorError(1, "Failed to validate material: " + e.getMessage(), EditorError.ErrorSeverity.ERROR));
        }
        return errors;
    }

    @Override
    public Map<EditorInterface.TextRange, Integer> getSyntaxHighlighting(String content) {
        HashMap<EditorInterface.TextRange, Integer> highlights = new HashMap<EditorInterface.TextRange, Integer>();
        int keyStart = -1;
        for (int i = 0; i < content.length(); ++i) {
            char c = content.charAt(i);
            if (c != '\"' || i != 0 && content.charAt(i - 1) == '\\') continue;
            if (keyStart == -1) {
                keyStart = i;
                continue;
            }
            highlights.put(new EditorInterface.TextRange(keyStart, i + 1), -16776961);
            keyStart = -1;
        }
        int valueStart = -1;
        boolean isString = false;
        for (int i = 0; i < content.length(); ++i) {
            char c = content.charAt(i);
            if (c == '\"' && (i == 0 || content.charAt(i - 1) != '\\')) {
                if (valueStart == -1) {
                    valueStart = i;
                    isString = true;
                    continue;
                }
                highlights.put(new EditorInterface.TextRange(valueStart, i + 1), -16711936);
                valueStart = -1;
                continue;
            }
            if (Character.isDigit(c) && valueStart == -1) {
                valueStart = i;
                isString = false;
                continue;
            }
            if (Character.isDigit(c) || valueStart == -1 || isString) continue;
            highlights.put(new EditorInterface.TextRange(valueStart, i), -256);
            valueStart = -1;
        }
        return highlights;
    }

    @Override
    public ResourceLocation getId() {
        return this.id;
    }
}

