/*
 * Decompiled with CFR 0.152.
 */
package smartin.miapi.effects;

import com.mojang.blaze3d.platform.Window;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.redpxnda.nucleus.client.Rendering;
import com.redpxnda.nucleus.event.ClientEvents;
import com.redpxnda.nucleus.event.MiscEvents;
import com.redpxnda.nucleus.registry.effect.RenderingMobEffect;
import dev.architectury.event.CompoundEventResult;
import dev.architectury.event.EventResult;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.texture.TextureAtlas;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.core.particles.BlockParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.effect.MobEffectCategory;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.AttributeMap;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.phys.AABB;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import org.joml.Vector3f;
import smartin.miapi.Miapi;
import smartin.miapi.client.GlintShader;
import smartin.miapi.events.MiapiEvents;
import smartin.miapi.registries.RegistryInventory;

public class CryoStatusEffect
extends RenderingMobEffect {
    protected static final ResourceLocation ICE_LOCATION = ResourceLocation.parse((String)"block/ice");

    public CryoStatusEffect() {
        super(MobEffectCategory.HARMFUL, 1160409);
        super.addAttributeModifier(Attributes.MOVEMENT_SPEED, Miapi.id("cryo_temp_movementspeed_slow"), -0.2, AttributeModifier.Operation.ADD_MULTIPLIED_TOTAL);
        MiscEvents.LIVING_JUMP_POWER.register(player -> {
            MobEffectInstance instance = player.getEffect(RegistryInventory.cryoStatusEffect);
            if (instance != null) {
                return CompoundEventResult.interruptFalse((Object)Float.valueOf(0.4f - Math.min(0.4f, (float)(instance.getAmplifier() + 1) * 0.04f)));
            }
            return CompoundEventResult.pass();
        });
        MiapiEvents.LIVING_HURT_AFTER.register(event -> {
            MobEffectInstance instance;
            if (event.defender.hasEffect(RegistryInventory.cryoStatusEffect) && (instance = event.defender.getEffect(RegistryInventory.cryoStatusEffect)) != null) {
                event.defender.removeEffect(RegistryInventory.cryoStatusEffect);
                event.defender.addEffect(new MobEffectInstance(RegistryInventory.cryoStatusEffect, instance.getDuration() - 30, instance.getAmplifier(), instance.isAmbient(), instance.isVisible(), instance.showIcon()));
            }
            return EventResult.pass();
        });
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void setupOnClient() {
        MiscEvents.CAN_CLIENT_SPRINT.register(player -> {
            if (player.hasEffect(RegistryInventory.cryoStatusEffect)) {
                return EventResult.interruptFalse();
            }
            return EventResult.pass();
        });
        ClientEvents.MODIFY_CAMERA_MOTION.register((mc, motion) -> {
            if (mc.player != null && mc.player.hasEffect(RegistryInventory.cryoStatusEffect) && (motion.x != 0.0 || motion.y != 0.0)) {
                int amplifier = mc.player.getEffect(RegistryInventory.cryoStatusEffect).getAmplifier();
                motion.normalize();
                motion.div(Math.min((double)((float)(amplifier + 6) / 5.0f), 2.25));
            }
        });
    }

    public void removeAttributeModifiers(AttributeMap attributeMap) {
        super.removeAttributeModifiers(attributeMap);
    }

    public void onEffectStarted(LivingEntity entity, int amplifier) {
        super.onEffectStarted(entity, amplifier);
        Level level = entity.level();
        if (level instanceof ServerLevel) {
            ServerLevel world = (ServerLevel)level;
            world.playSound(null, entity.getX(), entity.getY(), entity.getZ(), SoundEvents.PLAYER_HURT_FREEZE, SoundSource.PLAYERS, 1.0f, 1.0f);
        }
    }

    public void onRemoved(LivingEntity entity, AttributeMap attributes, int amplifier) {
        Level level = entity.level();
        if (level instanceof ServerLevel) {
            ServerLevel world = (ServerLevel)level;
            world.playSound(null, entity.getX(), entity.getY(), entity.getZ(), SoundEvents.GLASS_BREAK, SoundSource.BLOCKS, 1.0f, 1.0f);
            world.sendParticles((ParticleOptions)new BlockParticleOption(ParticleTypes.BLOCK, Blocks.ICE.defaultBlockState()), entity.getX(), entity.getY() + 1.0, entity.getZ(), 50, 0.5, 0.5, 0.5, 1.5);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public void renderPost(MobEffectInstance instance, LivingEntity entity, float entityYaw, float partialTick, PoseStack matrixStack, MultiBufferSource multiBufferSource, int packedLight) {
        if (entity.equals((Object)Minecraft.getInstance().player) && Minecraft.getInstance().options.getCameraType().isFirstPerson()) {
            return;
        }
        TextureAtlasSprite sprite = (TextureAtlasSprite)Minecraft.getInstance().getTextureAtlas(TextureAtlas.LOCATION_BLOCKS).apply(ICE_LOCATION);
        VertexConsumer vc = multiBufferSource.getBuffer(GlintShader.TRANSLUCENT_NO_CULL);
        matrixStack.pushPose();
        AABB bb = entity.getBoundingBox().move(entity.position().reverse());
        double minX = Math.floor(bb.minX * 2.0) / 2.0;
        double maxX = Math.ceil(bb.maxX * 2.0) / 2.0;
        double minZ = Math.floor(bb.minZ * 2.0) / 2.0;
        double maxZ = Math.ceil(bb.maxZ * 2.0) / 2.0;
        matrixStack.translate(0.5, 0.5, 0.5);
        for (double z = minZ; z < maxZ; z += 1.0) {
            boolean isLeft = z == minZ || maxZ - minZ <= 1.0;
            boolean isRight = z + 1.0 >= maxZ || maxZ - minZ <= 1.0;
            for (double x = minX; x < maxX; x += 1.0) {
                boolean isFront = x == minX || maxX - minX <= 1.0;
                boolean isBack = x + 1.0 >= maxX || maxX - minX <= 1.0;
                for (double y = bb.minY; y < bb.maxY; y += 1.0) {
                    boolean isBottom = y == bb.minY || bb.maxY - bb.minY <= 1.0;
                    boolean isTop = y + 1.0 >= bb.maxY || bb.maxY - bb.minY <= 1.0;
                    matrixStack.pushPose();
                    matrixStack.translate(x, y + 1.0E-4, z);
                    for (int side = 0; side < 6; ++side) {
                        if (side == 0 && !isTop || side == 1 && !isBottom || side == 2 && !isRight || side == 3 && !isLeft || side == 4 && !isBack || side == 5 && !isFront) continue;
                        Rendering.addQuad((Vector3f[])Rendering.CUBE[side], (PoseStack)matrixStack, (VertexConsumer)vc, (float)1.0f, (float)1.0f, (float)1.0f, (float)0.5f, (float)-0.5f, (float)0.5f, (float)0.5f, (float)sprite.getU0(), (float)sprite.getU1(), (float)sprite.getV0(), (float)sprite.getV1(), (int)packedLight);
                    }
                    matrixStack.popPose();
                }
            }
        }
        matrixStack.popPose();
    }

    @OnlyIn(value=Dist.CLIENT)
    public boolean renderHud(MobEffectInstance instance, Minecraft minecraft, GuiGraphics graphics, float partialTick) {
        if (minecraft.options == null || !minecraft.options.getCameraType().isFirstPerson()) {
            return false;
        }
        TextureAtlasSprite sprite = (TextureAtlasSprite)Minecraft.getInstance().getTextureAtlas(TextureAtlas.LOCATION_BLOCKS).apply(ICE_LOCATION);
        Window window = Minecraft.getInstance().getWindow();
        graphics.blit(0, 0, 0, window.getScreenWidth() / 2, window.getScreenHeight() / 2, sprite, 1.0f, 1.0f, 1.0f, 0.6f);
        return false;
    }

    public int tickUpdateInterval() {
        return 20;
    }

    public boolean shouldApplyEffectTickThisTick(int duration, int amplifier) {
        return duration > 0;
    }
}

