/*
 * Decompiled with CFR 0.152.
 */
package smartin.miapi.entity;

import dev.architectury.event.EventResult;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.Position;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.tags.EntityTypeTags;
import net.minecraft.util.Mth;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LightningBolt;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.entity.projectile.ProjectileDeflection;
import net.minecraft.world.item.ArrowItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;
import smartin.miapi.attributes.AttributeRegistry;
import smartin.miapi.config.MiapiConfig;
import smartin.miapi.entity.arrowhitbehaviours.EntityBounceBehaviour;
import smartin.miapi.entity.arrowhitbehaviours.EntityPierceBehaviour;
import smartin.miapi.entity.arrowhitbehaviours.ProjectileHitBehaviour;
import smartin.miapi.events.MiapiProjectileEvents;
import smartin.miapi.mixin.AbstractArrowAccessor;
import smartin.miapi.modules.abilities.util.WrappedSoundEvent;
import smartin.miapi.modules.properties.attributes.AttributeUtil;
import smartin.miapi.modules.properties.projectile.AirDragProperty;
import smartin.miapi.modules.properties.projectile.ChannelingProperty;
import smartin.miapi.modules.properties.projectile.MakesImpactSoundProperty;
import smartin.miapi.registries.RegistryInventory;

public class ItemProjectileEntity
extends AbstractArrow {
    public static final EntityDataAccessor<Byte> LOYALTY = SynchedEntityData.defineId(ItemProjectileEntity.class, (EntityDataSerializer)EntityDataSerializers.BYTE);
    public static final EntityDataAccessor<Boolean> ENCHANTED = SynchedEntityData.defineId(ItemProjectileEntity.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    public static final EntityDataAccessor<Boolean> SPEED_DAMAGE = SynchedEntityData.defineId(ItemProjectileEntity.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    public static final EntityDataAccessor<ItemStack> THROWING_STACK = SynchedEntityData.defineId(ItemProjectileEntity.class, (EntityDataSerializer)EntityDataSerializers.ITEM_STACK);
    public static final EntityDataAccessor<ItemStack> BOW_ITEM_STACK = SynchedEntityData.defineId(ItemProjectileEntity.class, (EntityDataSerializer)EntityDataSerializers.ITEM_STACK);
    public static final EntityDataAccessor<Float> WATER_DRAG = SynchedEntityData.defineId(ItemProjectileEntity.class, (EntityDataSerializer)EntityDataSerializers.FLOAT);
    public static final EntityDataAccessor<Integer> PREFERRED_SLOT = SynchedEntityData.defineId(ItemProjectileEntity.class, (EntityDataSerializer)EntityDataSerializers.INT);
    public ItemStack thrownStack = ItemStack.EMPTY;
    protected boolean dealtDamage;
    public int returnTimer;
    public float waterDrag = 0.99f;
    public WrappedSoundEvent hitEntitySound = new WrappedSoundEvent(this.getDefaultHitGroundSoundEvent(), 1.0f, 1.0f);
    public ProjectileHitBehaviour projectileHitBehaviour = new EntityBounceBehaviour();

    public ItemProjectileEntity(EntityType<? extends Entity> entityType, Level world) {
        super(entityType, world);
    }

    public ItemProjectileEntity(Level world, Position position, ItemStack itemStack) {
        super(RegistryInventory.registeredItemProjectileType, world);
        ItemStack stack = itemStack.copy();
        stack.setCount(1);
        this.thrownStack = stack;
        this.entityData.set(THROWING_STACK, (Object)this.thrownStack);
        this.entityData.set(LOYALTY, (Object)this.getLoyaltyFromItem(stack));
        this.entityData.set(ENCHANTED, (Object)stack.hasFoil());
        this.checkDespawn();
        this.setup();
    }

    public ItemProjectileEntity(Level world, LivingEntity owner, ItemStack itemStack, ItemStack weapon) {
        super(RegistryInventory.registeredItemProjectileType, owner, world, itemStack, weapon);
        ItemStack stack = itemStack.copy();
        stack.setCount(1);
        this.thrownStack = stack.copy();
        this.entityData.set(LOYALTY, (Object)this.getLoyaltyFromItem(stack));
        this.entityData.set(ENCHANTED, (Object)stack.hasFoil());
        this.entityData.set(THROWING_STACK, (Object)this.thrownStack);
        this.entityData.set(BOW_ITEM_STACK, (Object)weapon);
        this.entityData.set(WATER_DRAG, (Object)Float.valueOf(this.waterDrag));
        this.entityData.set(SPEED_DAMAGE, (Object)true);
        this.entityData.set(PREFERRED_SLOT, (Object)-1);
        if (this.getBowItem().isEmpty() && owner != null) {
            this.setBowItem(owner.getUseItem());
        }
        this.setup();
        ((MiapiProjectileEvents.ItemProjectileDataTracker)MiapiProjectileEvents.MODULAR_PROJECTILE_DATA_TRACKER_SET.invoker()).dataTracker(this, this.getEntityData());
    }

    private void setup() {
        ItemStack projectileStack = this.getPickupItem();
        this.setBaseDamage(AttributeUtil.getActualValue(projectileStack, EquipmentSlot.MAINHAND, (Attribute)AttributeRegistry.PROJECTILE_DAMAGE.value()));
        Item item = projectileStack.getItem();
        if (item instanceof ArrowItem) {
            ArrowItem arrowItem = (ArrowItem)item;
            this.setSpeedDamage(true);
        }
    }

    private byte getLoyaltyFromItem(ItemStack stack) {
        Level var3 = this.level();
        if (var3 instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)var3;
            return (byte)Mth.clamp((int)EnchantmentHelper.getTridentReturnToOwnerAcceleration((ServerLevel)serverLevel, (ItemStack)stack, (Entity)this), (int)0, (int)127);
        }
        return 0;
    }

    public void setPreferredSlot(int slotID) {
        this.entityData.set(PREFERRED_SLOT, (Object)slotID);
    }

    public void setBowItem(ItemStack bowItem) {
        this.entityData.set(BOW_ITEM_STACK, (Object)bowItem.copy());
    }

    public ItemStack getBowItem() {
        return (ItemStack)this.entityData.get(BOW_ITEM_STACK);
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        builder.define(LOYALTY, (Object)0);
        builder.define(ENCHANTED, (Object)false);
        builder.define(THROWING_STACK, (Object)ItemStack.EMPTY);
        builder.define(BOW_ITEM_STACK, (Object)ItemStack.EMPTY);
        builder.define(WATER_DRAG, (Object)Float.valueOf(0.99f));
        builder.define(SPEED_DAMAGE, (Object)true);
        builder.define(PREFERRED_SLOT, (Object)0);
        ((MiapiProjectileEvents.ItemProjectileDataTrackerBuilder)MiapiProjectileEvents.MODULAR_PROJECTILE_DATA_TRACKER_INIT.invoker()).dataTracker(builder);
    }

    public boolean getSpeedDamage() {
        return (Boolean)this.entityData.get(SPEED_DAMAGE);
    }

    public void setSpeedDamage(boolean speedDamage) {
        this.entityData.set(SPEED_DAMAGE, (Object)speedDamage);
    }

    public void tick() {
        ItemStack asItem = this.getPickupItem();
        if (((MiapiProjectileEvents.ModularProjectileTick)MiapiProjectileEvents.MODULAR_PROJECTILE_TICK.invoker()).tick(this).interruptsFurtherEvaluation()) {
            return;
        }
        if (this.inGroundTime > 4) {
            this.setDeltaMovement(new Vec3(0.0, 0.0, 0.0));
            this.dealtDamage = true;
        }
        if (this.blockPosition().getY() < this.level().getMinBuildHeight() - 50 && MiapiConfig.getServerConfig().enchants.betterLoyalty) {
            this.dealtDamage = true;
        }
        Entity entity = this.getOwner();
        byte loyaltyLevel = (Byte)this.entityData.get(LOYALTY);
        if (loyaltyLevel > 0 && (this.dealtDamage || this.isNoPhysics()) && entity != null) {
            if (!this.isOwnerAlive()) {
                if (!this.level().isClientSide && this.pickup == AbstractArrow.Pickup.ALLOWED) {
                    this.spawnAtLocation(this.getPickupItem(), 0.1f);
                }
                this.discard();
            } else {
                this.setNoPhysics(true);
                Vec3 targetDir = entity.getEyePosition().subtract(this.position());
                this.setPosRaw(this.getX(), this.getY() + targetDir.y * 0.015 * (double)loyaltyLevel, this.getZ());
                if (this.level().isClientSide) {
                    this.yOld = this.getY();
                }
                double speedAdjustment = 0.05 * (double)loyaltyLevel;
                this.setDeltaMovement(this.getDeltaMovement().scale(0.95).add(targetDir.normalize().scale(speedAdjustment)));
                if (this.returnTimer == 0) {
                    this.playSound(SoundEvents.TRIDENT_RETURN, 10.0f, 1.0f);
                }
                ++this.returnTimer;
            }
        }
        Vec3 vec3d = this.getDeltaMovement();
        float m = (float)AirDragProperty.property.getValueSafe(asItem);
        if (this.isInWater()) {
            m = 1.0f;
        }
        this.setDeltaMovement(vec3d.scale((double)m));
        super.tick();
    }

    protected void tickDespawn() {
        ++this.tickCount;
        if (this.tickCount >= 24000) {
            this.discard();
        }
    }

    protected boolean isOwnerAlive() {
        Entity entity = this.getOwner();
        if (entity != null && entity.isAlive()) {
            return !(entity instanceof ServerPlayer) || !entity.isSpectator();
        }
        return false;
    }

    public ItemStack getDefaultPickupItem() {
        return ((ItemStack)this.entityData.get(THROWING_STACK)).copy();
    }

    @Nullable
    protected EntityHitResult findHitEntity(Vec3 currentPosition, Vec3 nextPosition) {
        return this.dealtDamage ? null : super.findHitEntity(currentPosition, nextPosition);
    }

    public void shoot(double x, double y, double z, float velocity, float inaccuracy) {
        ItemStack projectileStack = this.getPickupItem();
        velocity = (float)Math.max(0.1, (double)velocity + AttributeUtil.getActualValue(projectileStack, EquipmentSlot.MAINHAND, (Attribute)AttributeRegistry.PROJECTILE_SPEED.value()));
        Vec3 vec3 = this.getMovementToShoot(x, y, z, velocity, inaccuracy *= (float)Math.pow(12.0, -AttributeUtil.getActualValue(projectileStack, EquipmentSlot.MAINHAND, (Attribute)AttributeRegistry.PROJECTILE_ACCURACY.value())));
        this.setDeltaMovement(vec3);
        this.hasImpulse = true;
        double d = vec3.horizontalDistance();
        this.setYRot((float)(Mth.atan2((double)vec3.x, (double)vec3.z) * 57.2957763671875));
        this.setXRot((float)(Mth.atan2((double)vec3.y, (double)d) * 57.2957763671875));
        this.yRotO = this.getYRot();
        this.xRotO = this.getXRot();
    }

    protected void onHitEntity(EntityHitResult entityHitResult) {
        Entity defender = entityHitResult.getEntity();
        float damage = this.getProjectileDamage();
        if (this.getPierceLevel() > 0) {
            this.projectileHitBehaviour = new EntityPierceBehaviour();
            ((AbstractArrowAccessor)((Object)this)).callSetPierceLevel((byte)(this.getPierceLevel() - 1));
        } else {
            this.projectileHitBehaviour = new EntityBounceBehaviour();
        }
        Entity owner = this.getOwner();
        MiapiProjectileEvents.ModularProjectileEntityHitEvent event = new MiapiProjectileEvents.ModularProjectileEntityHitEvent(entityHitResult, this, this.damageSources().arrow((AbstractArrow)this, owner), damage);
        EventResult result = ((MiapiProjectileEvents.ModularProjectileEntityHit)MiapiProjectileEvents.MODULAR_PROJECTILE_ENTITY_HIT.invoker()).hit(event);
        if (result.interruptsFurtherEvaluation()) {
            if (this.projectileHitBehaviour != null) {
                this.projectileHitBehaviour.onHit(this, entityHitResult.getEntity(), entityHitResult);
            }
            return;
        }
        damage = event.damage;
        this.dealtDamage = true;
        if (defender.hurt(event.damageSource, (float)Math.ceil(damage))) {
            if (defender.getType() == EntityType.ENDERMAN) {
                return;
            }
            Level level = this.level();
            if (level instanceof ServerLevel) {
                ServerLevel serverLevel = (ServerLevel)level;
                EnchantmentHelper.doPostAttackEffectsWithItemSource((ServerLevel)serverLevel, (Entity)defender, (DamageSource)event.damageSource, (ItemStack)this.getWeaponItem());
            }
            if (defender instanceof LivingEntity) {
                LivingEntity victim = (LivingEntity)defender;
                this.doKnockback(victim, event.damageSource);
                this.doPostHurtEffects(victim);
            }
        }
        if (ChannelingProperty.hasChanneling(this.getPickupItem())) {
            LightningBolt lightningEntity = (LightningBolt)EntityType.LIGHTNING_BOLT.create(this.level());
            assert (lightningEntity != null);
            lightningEntity.moveTo(Vec3.atBottomCenterOf((Vec3i)entityHitResult.getEntity().getOnPos()));
            Entity entity = this.getOwner();
            if (entity instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)entity;
                lightningEntity.setCause(serverPlayer);
            }
            this.level().addFreshEntity((Entity)lightningEntity);
        }
        if (this.projectileHitBehaviour != null) {
            this.projectileHitBehaviour.onHit(this, entityHitResult.getEntity(), entityHitResult);
        }
        MiapiProjectileEvents.ModularProjectileEntityHitEvent postEvent = new MiapiProjectileEvents.ModularProjectileEntityHitEvent(event.entityHitResult, this, event.damageSource, damage);
        EventResult postResult = ((MiapiProjectileEvents.ModularProjectileEntityHit)MiapiProjectileEvents.MODULAR_PROJECTILE_ENTITY_POST_HIT.invoker()).hit(postEvent);
        if (postResult.interruptsFurtherEvaluation()) {
            return;
        }
        this.playSound(this.hitEntitySound.event(), this.hitEntitySound.volume(), this.hitEntitySound.pitch());
    }

    public ItemStack getPickupItem() {
        ItemStack stack = (ItemStack)this.entityData.get(THROWING_STACK);
        if (stack != null && !stack.isEmpty()) {
            return stack;
        }
        return ItemStack.EMPTY;
    }

    protected void onHitBlock(BlockHitResult blockHitResult) {
        if (((MiapiProjectileEvents.ModularProjectileBlockHit)MiapiProjectileEvents.MODULAR_PROJECTILE_BLOCK_HIT.invoker()).hit(new MiapiProjectileEvents.ModularProjectileBlockHitEvent(blockHitResult, this)).interruptsFurtherEvaluation()) {
            if (this.projectileHitBehaviour != null) {
                this.projectileHitBehaviour.onBlockHit(this, blockHitResult);
            }
            return;
        }
        if (this.projectileHitBehaviour != null) {
            this.projectileHitBehaviour.onBlockHit(this, blockHitResult);
        }
        super.onHitBlock(blockHitResult);
    }

    protected void onHit(HitResult result) {
        this.hitEntitySound = new WrappedSoundEvent(this.getDefaultHitGroundSoundEvent(), 1.0f, 1.0f);
        ((AbstractArrowAccessor)((Object)this)).setSoundEvent(this.hitEntitySound.event());
        HitResult.Type hitresult$type = result.getType();
        boolean makeEvent = MakesImpactSoundProperty.property.isTrue(this.getPickupItem());
        if (hitresult$type == HitResult.Type.ENTITY) {
            EntityHitResult entityhitresult = (EntityHitResult)result;
            Entity entity = entityhitresult.getEntity();
            if (entity.getType().is(EntityTypeTags.REDIRECTABLE_PROJECTILE) && entity instanceof Projectile) {
                Projectile projectile = (Projectile)entity;
                projectile.deflect(ProjectileDeflection.AIM_DEFLECT, this.getOwner(), this.getOwner(), true);
            }
            this.onHitEntity(entityhitresult);
            this.getPickupItem();
            if (makeEvent) {
                this.level().gameEvent((Holder)GameEvent.PROJECTILE_LAND, result.getLocation(), GameEvent.Context.of((Entity)this, (BlockState)null));
            }
        } else if (hitresult$type == HitResult.Type.BLOCK) {
            BlockHitResult blockhitresult = (BlockHitResult)result;
            this.onHitBlock(blockhitresult);
            BlockPos blockpos = blockhitresult.getBlockPos();
            if (makeEvent) {
                this.level().gameEvent((Holder)GameEvent.PROJECTILE_LAND, blockpos, GameEvent.Context.of((Entity)this, (BlockState)this.level().getBlockState(blockpos)));
            }
        }
    }

    public float getProjectileDamage() {
        float damage = (float)this.getBaseDamage();
        if (this.getSpeedDamage()) {
            float speed = (float)this.getDeltaMovement().length();
            damage = (float)Mth.clamp((double)((double)speed * (double)damage), (double)0.0, (double)2.147483647E9);
        }
        return damage;
    }

    protected boolean tryPickup(Player player) {
        int slotId = (Integer)this.entityData.get(PREFERRED_SLOT);
        if (((MiapiProjectileEvents.PlayerPickupEvent)MiapiProjectileEvents.MODULAR_PROJECTILE_PICK_UP.invoker()).pickup(player, this).interruptsFurtherEvaluation()) {
            return false;
        }
        switch (this.pickup) {
            case DISALLOWED: {
                return false;
            }
            case CREATIVE_ONLY: {
                if (this.getLoyaltyFromItem(this.getPickupItem()) > 0 && this.ownedBy((Entity)player)) {
                    return true;
                }
                return player.getAbilities().instabuild;
            }
            case ALLOWED: {
                boolean hasLoyalty;
                boolean bl = hasLoyalty = (Byte)this.entityData.get(LOYALTY) > 0;
                if (hasLoyalty && this.getOwner() != null && !this.ownedBy((Entity)player)) {
                    return false;
                }
                if (slotId == -2 && player.getOffhandItem().isEmpty()) {
                    player.getInventory().offhand.set(0, (Object)this.getPickupItem());
                    player.getInventory().setChanged();
                    return true;
                }
                if (slotId >= 0 && player.getInventory().getItem(slotId).isEmpty()) {
                    return player.getInventory().add(slotId, this.getPickupItem());
                }
                return player.getInventory().add(this.getPickupItem());
            }
        }
        return super.tryPickup(player) || this.isNoPhysics() && this.ownedBy((Entity)player) && player.getInventory().add(this.getPickupItem());
    }

    public void setDamageToDeal(boolean hasDamage) {
        this.dealtDamage = !hasDamage;
    }

    protected SoundEvent getDefaultHitGroundSoundEvent() {
        boolean makeEvent = MakesImpactSoundProperty.property.isTrue(this.getPickupItem());
        if (!makeEvent) {
            return SoundEvents.EMPTY;
        }
        return SoundEvents.TRIDENT_HIT_GROUND;
    }

    public void playerTouch(Player player) {
        super.playerTouch(player);
    }

    public void readAdditionalSaveData(CompoundTag nbt) {
        super.readAdditionalSaveData(nbt);
        if (nbt.contains("ThrownItem", 10)) {
            this.thrownStack = (ItemStack)ItemStack.parse((HolderLookup.Provider)this.registryAccess(), (Tag)nbt.getCompound("ThrownItem")).get();
            this.entityData.set(THROWING_STACK, (Object)this.thrownStack);
        } else {
            this.thrownStack = ItemStack.EMPTY;
            this.entityData.set(THROWING_STACK, (Object)ItemStack.EMPTY);
        }
        if (nbt.contains("BowItem", 10)) {
            ItemStack bowItem = (ItemStack)ItemStack.parse((HolderLookup.Provider)this.registryAccess(), (Tag)nbt.getCompound("BowItem")).get();
            this.entityData.set(BOW_ITEM_STACK, (Object)bowItem);
        } else {
            this.entityData.set(BOW_ITEM_STACK, (Object)ItemStack.EMPTY);
        }
        if (nbt.contains("WaterDrag")) {
            this.entityData.set(WATER_DRAG, (Object)Float.valueOf(nbt.getFloat("WaterDrag")));
        }
        if (nbt.contains("SpeedDamage")) {
            this.entityData.set(SPEED_DAMAGE, (Object)nbt.getBoolean("SpeedDamage"));
        }
        if (nbt.contains("PreferredSlot")) {
            this.entityData.set(PREFERRED_SLOT, (Object)nbt.getInt("PreferredSlot"));
        }
        this.dealtDamage = nbt.getBoolean("DealtDamage");
        this.entityData.set(LOYALTY, (Object)this.getLoyaltyFromItem(this.thrownStack));
        ((MiapiProjectileEvents.ItemProjectileCompound)MiapiProjectileEvents.MODULAR_PROJECTILE_NBT_READ.invoker()).nbtEvent(this, nbt, this.registryAccess());
    }

    public void addAdditionalSaveData(CompoundTag nbt) {
        super.addAdditionalSaveData(nbt);
        if (!this.thrownStack.isEmpty()) {
            nbt.put("ThrownItem", this.thrownStack.save((HolderLookup.Provider)this.registryAccess(), (Tag)new CompoundTag()));
        }
        if (!this.getBowItem().isEmpty()) {
            nbt.put("BowItem", this.getBowItem().save((HolderLookup.Provider)this.registryAccess(), (Tag)new CompoundTag()));
        }
        nbt.putBoolean("DealtDamage", this.dealtDamage);
        nbt.putFloat("WaterDrag", ((Float)this.entityData.get(WATER_DRAG)).floatValue());
        nbt.putBoolean("SpeedDamage", ((Boolean)this.entityData.get(SPEED_DAMAGE)).booleanValue());
        nbt.putInt("PreferredSlot", ((Integer)this.entityData.get(PREFERRED_SLOT)).intValue());
        ((MiapiProjectileEvents.ItemProjectileCompound)MiapiProjectileEvents.MODULAR_PROJECTILE_NBT_WRITE.invoker()).nbtEvent(this, nbt, this.registryAccess());
    }

    protected float getWaterInertia() {
        return this.waterDrag;
    }

    public boolean shouldRender(double cameraX, double cameraY, double cameraZ) {
        return true;
    }

    public boolean equals(Object other) {
        return super.equals(other);
    }
}

