/*
 * Decompiled with CFR 0.152.
 */
package smartin.miapi.events;

import com.google.common.collect.Multimap;
import com.redpxnda.nucleus.event.PrioritizedEvent;
import dev.architectury.event.EventResult;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.core.RegistryAccess;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.valueproviders.IntProvider;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TieredItem;
import org.apache.commons.lang3.mutable.Mutable;
import org.apache.commons.lang3.mutable.MutableFloat;
import org.jetbrains.annotations.Nullable;
import smartin.miapi.blocks.ModularWorkBenchEntity;
import smartin.miapi.client.gui.crafting.CraftingScreenHandler;
import smartin.miapi.craft.CraftAction;
import smartin.miapi.craft.stat.StatProvidersMap;
import smartin.miapi.entity.ItemProjectileEntity;
import smartin.miapi.material.base.Material;
import smartin.miapi.material.generated.GeneratedMaterial;
import smartin.miapi.modules.ModuleInstance;
import smartin.miapi.modules.properties.util.ComponentApplyProperty;

public class MiapiEvents {
    public static final PrioritizedEvent<LivingHurt> LIVING_HURT = PrioritizedEvent.createEventResult((Object[])new LivingHurt[0]);
    public static final PrioritizedEvent<LivingHurt> LIVING_HURT_AFTER = PrioritizedEvent.createEventResult((Object[])new LivingHurt[0]);
    public static final PrioritizedEvent<LivingHurt> LIVING_HURT_AFTER_ARMOR = PrioritizedEvent.createEventResult((Object[])new LivingHurt[0]);
    public static final PrioritizedEvent<LivingEntityXpAdjust> ADJUST_DROP_XP = PrioritizedEvent.createEventResult((Object[])new LivingEntityXpAdjust[0]);
    public static final PrioritizedEvent<EntityRide> START_RIDING = PrioritizedEvent.createLoop((Object[])new EntityRide[0]);
    public static final PrioritizedEvent<EntityRide> STOP_RIDING = PrioritizedEvent.createLoop((Object[])new EntityRide[0]);
    public static final PrioritizedEvent<StatUpdateEvent> STAT_UPDATE_EVENT = PrioritizedEvent.createEventResult((Object[])new StatUpdateEvent[0]);
    public static final PrioritizedEvent<ItemConvertEvent> CONVERT_ITEM = PrioritizedEvent.createEventResult((Object[])new ItemConvertEvent[0]);
    public static final PrioritizedEvent<CreateMaterialModularConvertersEvent> GENERATE_MATERIAL_CONVERTERS = PrioritizedEvent.createEventResult((Object[])new CreateMaterialModularConvertersEvent[0]);
    public static final PrioritizedEvent<PlayerTickEvent> PLAYER_TICK_START = PrioritizedEvent.createLoop((Object[])new PlayerTickEvent[0]);
    public static final PrioritizedEvent<PlayerTickEvent> PLAYER_TICK_END = PrioritizedEvent.createLoop((Object[])new PlayerTickEvent[0]);
    public static final PrioritizedEvent<LivingEntityTickEvent> LIVING_ENTITY_TICK_END = PrioritizedEvent.createLoop((Object[])new LivingEntityTickEvent[0]);
    public static final PrioritizedEvent<MaterialCraftEvent> MATERIAL_CRAFT_EVENT = PrioritizedEvent.createLoop((Object[])new MaterialCraftEvent[0]);
    public static final PrioritizedEvent<SmithingEvent> SMITHING_EVENT = PrioritizedEvent.createLoop((Object[])new SmithingEvent[0]);
    public static final PrioritizedEvent<LivingEntityAttributeBuild> LIVING_ENTITY_ATTRIBUTE_BUILD_EVENT = PrioritizedEvent.createLoop((Object[])new LivingEntityAttributeBuild[0]);
    public static final PrioritizedEvent<PlayerEquip> PLAYER_EQUIP_EVENT = PrioritizedEvent.createLoop((Object[])new PlayerEquip[0]);
    public static final PrioritizedEvent<ReloadEvent> ADJUST_RAW_DATA = PrioritizedEvent.createLoop((Object[])new ReloadEvent[0]);
    public static final PrioritizedEvent<ReloadEventPost> POST_HOT_RELOAD = PrioritizedEvent.createLoop((Object[])new ReloadEventPost[0]);

    static {
        SMITHING_EVENT.register(listener -> {
            ComponentApplyProperty.updateItemStack(listener.itemStack, listener.registryAccess);
            return EventResult.pass();
        });
    }

    public static class MaterialCraft {
        public RegistryAccess registryAccess;
        public ItemStack itemStack;

        public MaterialCraft(ItemStack itemStack) {
            this.itemStack = itemStack;
        }
    }

    public static interface LivingHurt {
        public EventResult hurt(LivingHurtEvent var1);
    }

    public static interface LivingEntityXpAdjust {
        public EventResult death(LivingEntity var1, MutableFloat var2);
    }

    public static interface EntityRide {
        public void ride(Entity var1, Entity var2);
    }

    public static interface StatUpdateEvent {
        public EventResult update(ModularWorkBenchEntity var1, StatProvidersMap var2, int var3, Inventory var4, Player var5, CraftingScreenHandler var6);
    }

    public static interface ItemConvertEvent {
        public EventResult convert(ItemStack var1, Mutable<ItemStack> var2);
    }

    public static interface CreateMaterialModularConvertersEvent {
        public EventResult generated(Material var1, List<TieredItem> var2, List<ArmorItem> var3, boolean var4);
    }

    public static interface PlayerTickEvent {
        public EventResult tick(Player var1);
    }

    public static interface LivingEntityTickEvent {
        public EventResult tick(LivingEntity var1);
    }

    public static interface MaterialCraftEvent {
        public EventResult craft(MaterialCraftEventData var1);
    }

    public static interface SmithingEvent {
        public EventResult craft(MaterialCraft var1);
    }

    public static interface LivingEntityAttributeBuild {
        public EventResult build(AttributeSupplier.Builder var1);
    }

    public static interface PlayerEquip {
        public EventResult equip(Player var1, Map<EquipmentSlot, ItemStack> var2);
    }

    public static interface ReloadEvent {
        public EventResult onReload(ReloadEventData var1);
    }

    public static interface ReloadEventPost {
        public EventResult onReload();
    }

    public static interface ItemCraftingStatUpdate {
        public EventResult call(ModularWorkBenchEntity var1, Iterable<ItemStack> var2, @Nullable Player var3);
    }

    public static interface BlockCraftingStatUpdate {
        public EventResult call(ModularWorkBenchEntity var1, @Nullable Player var2);
    }

    public static interface BlockBreakEvent {
        public void breakBlock(ServerLevel var1, BlockPos var2, ItemStack var3, IntProvider var4);
    }

    public static interface GeneratedMaterialEvent {
        public EventResult generated(GeneratedMaterial var1, ItemStack var2, List<Item> var3, boolean var4);
    }

    public static class MaterialCraftEventData {
        public ItemStack crafted;
        public final ItemStack materialStack;
        public Material material;
        public ModuleInstance moduleInstance;
        CraftAction action;

        public MaterialCraftEventData(ItemStack crafted, ItemStack materialStack, Material material, ModuleInstance moduleInstance, CraftAction action) {
            this.crafted = crafted;
            this.material = material;
            this.materialStack = materialStack;
            this.moduleInstance = moduleInstance;
            this.action = action;
        }
    }

    public static interface LivingAttackEvent {
        public EventResult attack(@Nullable LivingEntity var1, @Nullable LivingEntity var2);
    }

    public static interface ItemStackAttributeEvent {
        public EventResult adjust(ItemStackAttributeEventHolder var1);
    }

    public static class ItemStackAttributeEventHolder {
        public ItemStack itemStack;
        public EquipmentSlot equipmentSlot;
        public Multimap<Attribute, AttributeModifier> attributeModifiers;

        public ItemStackAttributeEventHolder(ItemStack itemStack, EquipmentSlot equipmentSlot, Multimap<Attribute, AttributeModifier> attributeModifiers) {
            this.itemStack = itemStack;
            this.equipmentSlot = equipmentSlot;
            this.attributeModifiers = attributeModifiers;
        }
    }

    public static class LivingHurtEvent {
        public final LivingEntity defender;
        @Nullable
        public final Entity attacker;
        public DamageSource damageSource;
        public float amount;
        public boolean isCritical = false;

        public LivingHurtEvent(LivingEntity defender, Entity attacker, DamageSource damageSource, float amount) {
            this.defender = defender;
            this.attacker = attacker;
            this.damageSource = damageSource;
            this.amount = amount;
        }

        public static ItemStack getCausingItemStack(DamageSource damageSource) {
            Projectile projectile;
            Entity entity = damageSource.getDirectEntity();
            if (entity instanceof Projectile && (projectile = (Projectile)entity) instanceof ItemProjectileEntity) {
                ItemProjectileEntity itemProjectile = (ItemProjectileEntity)projectile;
                return itemProjectile.getPickupItem();
            }
            Entity entity2 = damageSource.getEntity();
            if (entity2 instanceof LivingEntity) {
                LivingEntity attacker = (LivingEntity)entity2;
                return attacker.getMainHandItem();
            }
            return ItemStack.EMPTY;
        }

        public ItemStack getCausingItemStack() {
            return LivingHurtEvent.getCausingItemStack(this.damageSource);
        }

        public Iterable<ItemStack> getCausingItemStackAndArmorOfAttacker() {
            return LivingHurtEvent.getCausingItemStackAndArmorOfAttacker(this.damageSource);
        }

        public static Iterable<ItemStack> getCausingItemStackAndArmorOfAttacker(DamageSource damageSource) {
            Entity entity;
            Projectile projectile;
            ArrayList<ItemStack> itemStacks = new ArrayList<ItemStack>();
            Entity entity2 = damageSource.getDirectEntity();
            if (entity2 instanceof Projectile && (projectile = (Projectile)entity2) instanceof ItemProjectileEntity) {
                ItemProjectileEntity itemProjectile = (ItemProjectileEntity)projectile;
                itemStacks.add(itemProjectile.getPickupItem());
                Entity entity3 = itemProjectile.getOwner();
                if (entity3 instanceof LivingEntity) {
                    LivingEntity attacker = (LivingEntity)entity3;
                    attacker.getArmorSlots().forEach(itemStacks::add);
                }
            }
            if ((entity = damageSource.getEntity()) instanceof LivingEntity) {
                LivingEntity attacker = (LivingEntity)entity;
                attacker.getArmorSlots().forEach(itemStacks::add);
            }
            return itemStacks;
        }
    }

    public static class ReloadEventData {
        public Map<ResourceLocation, String> data = new HashMap<ResourceLocation, String>();

        public void setData(ResourceLocation id, String data) {
        }
    }
}

