/*
 * Decompiled with CFR 0.152.
 */
package smartin.miapi.item;

import com.google.gson.JsonElement;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import org.apache.commons.lang3.mutable.Mutable;
import org.apache.commons.lang3.mutable.MutableObject;
import smartin.miapi.Miapi;
import smartin.miapi.datapack.ReloadEvents;
import smartin.miapi.events.MiapiEvents;
import smartin.miapi.item.ModularItemStackConverter;
import smartin.miapi.modules.ModuleInstance;
import smartin.miapi.modules.properties.ItemIdProperty;
import smartin.miapi.registries.RegistryInventory;

public class ItemToModularConverter
implements ModularItemStackConverter.ModularConverter {
    public static Map<String, ItemStack> regexes = new ConcurrentHashMap<String, ItemStack>();
    public static Codec<Map<String, ModuleInstance>> CODEC = Codec.unboundedMap((Codec)Codec.STRING, ModuleInstance.CODEC);

    public ItemToModularConverter() {
        ReloadEvents.END.subscribe((isClient, registryAccess) -> Miapi.LOGGER.info("Loaded " + regexes.size() + " Modular Converters"));
    }

    public static void setupModularConverter(ResourceLocation path, String data) {
        try {
            JsonElement element = (JsonElement)Miapi.gson.fromJson(data, JsonElement.class);
            DataResult decoded = CODEC.decode((DynamicOps)JsonOps.INSTANCE, (Object)element);
            if (decoded.isSuccess()) {
                ((Map)((Pair)decoded.getOrThrow()).getFirst()).forEach((key, modules) -> {
                    ItemStack stack = new ItemStack((ItemLike)RegistryInventory.modularItem);
                    modules.writeToItem(stack);
                    regexes.put((String)key, stack);
                });
            } else {
                Miapi.LOGGER.error("could not read modular converter in " + String.valueOf(path) + " " + decoded.error().toString());
            }
        }
        catch (RuntimeException e) {
            Miapi.LOGGER.error("Error during Modular Converter setup for " + String.valueOf(path), (Throwable)e);
        }
    }

    public boolean preventConvert(ItemStack itemStack) {
        return false;
    }

    @Override
    public ItemStack convert(ItemStack stack) {
        if (this.preventConvert(stack)) {
            return stack.copy();
        }
        try {
            for (Map.Entry<String, ItemStack> entry : regexes.entrySet()) {
                if (!BuiltInRegistries.ITEM.getKey((Object)stack.getItem()).toString().matches(entry.getKey())) continue;
                ItemStack nextStack = entry.getValue().copy();
                nextStack.applyComponents(stack.getComponents());
                nextStack.setCount(stack.getCount());
                MutableObject mutable = new MutableObject((Object)ItemIdProperty.changeId(nextStack));
                ((MiapiEvents.ItemConvertEvent)MiapiEvents.CONVERT_ITEM.invoker()).convert(stack, (Mutable<ItemStack>)mutable);
                return (ItemStack)mutable.getValue();
            }
        }
        catch (RuntimeException e) {
            Miapi.LOGGER.error("error during modular convertion", (Throwable)e);
        }
        return stack;
    }
}

