/*
 * Decompiled with CFR 0.152.
 */
package smartin.miapi.loot;

import dev.architectury.event.events.common.LootEvent;
import java.util.List;
import java.util.Optional;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.storage.loot.LootPool;
import net.minecraft.world.level.storage.loot.entries.LootPoolEntryContainer;
import net.minecraft.world.level.storage.loot.entries.LootPoolSingletonContainer;
import net.minecraft.world.level.storage.loot.functions.LootItemFunction;
import net.minecraft.world.level.storage.loot.parameters.LootContextParam;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import smartin.miapi.Miapi;
import smartin.miapi.loot.LootModifierManager;
import smartin.miapi.loot.MaterialSwapLootFunction;
import smartin.miapi.loot.ModuleSwapLootFunction;
import smartin.miapi.mixin.LootTableAccessor;

public class LootHelper {
    public static List<LootItemFunction> adjusted = List.of(new MaterialSwapLootFunction(Miapi.id("empty"), -3.5, 0.4, 1.0, 0.2, 1.0, 1.0, 1.0, Optional.empty(), Optional.empty(), false), new ModuleSwapLootFunction(Miapi.id("empty"), 1.0, Optional.empty(), Optional.empty(), false));
    public static final ResourceLocation LOOT_TABLE_ID = Miapi.id("loot_table_id");
    public static final LootContextParam<ResourceLocation> LOOT_TABLE_PARAM = new LootContextParam(LOOT_TABLE_ID);

    public static void setup() {
    }

    public static LootPool.Builder getBuilderFromLootPool(LootPool lootPool) {
        LootPool.Builder builder = new LootPool.Builder().setRolls(lootPool.rolls).setBonusRolls(lootPool.bonusRolls);
        for (LootPoolEntryContainer entry : lootPool.entries) {
            builder.add((LootPoolEntryContainer.Builder)new DummyBuilder(entry));
        }
        for (LootItemCondition condition : lootPool.conditions) {
            builder.when(() -> condition);
        }
        for (LootItemFunction function : lootPool.functions) {
            builder.apply(() -> function);
        }
        return builder;
    }

    private static /* synthetic */ void lambda$setup$2(ResourceKey key, LootEvent.LootTableModificationContext context, boolean builtin) {
        LootModifierManager.getLootPools().forEach(lootTable -> ((LootTableAccessor)lootTable).getPools().forEach(lootPool -> {
            LootPool.lootPool().setRolls(lootPool.rolls);
            context.addPool(LootHelper.getBuilderFromLootPool(lootPool));
        }));
    }

    static class DummyBuilder
    extends LootPoolSingletonContainer.Builder<DummyBuilder> {
        public LootPoolEntryContainer entry;

        public DummyBuilder(LootPoolEntryContainer entry) {
            this.entry = entry;
        }

        protected DummyBuilder getThis() {
            return this;
        }

        public LootPoolEntryContainer build() {
            return this.entry;
        }
    }
}

