/*
 * Decompiled with CFR 0.152.
 */
package smartin.miapi.material;

import com.google.gson.JsonElement;
import com.redpxnda.nucleus.codec.auto.AutoCodec;
import com.redpxnda.nucleus.codec.behavior.CodecBehavior;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.phys.Vec2;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import org.jetbrains.annotations.Nullable;
import smartin.miapi.Miapi;
import smartin.miapi.blocks.ModularWorkBenchEntity;
import smartin.miapi.client.gui.InteractAbleWidget;
import smartin.miapi.client.gui.crafting.crafter.replace.MaterialCraftingWidget;
import smartin.miapi.config.MiapiConfig;
import smartin.miapi.craft.CraftAction;
import smartin.miapi.craft.MaterialCraftInfo;
import smartin.miapi.events.MiapiEvents;
import smartin.miapi.material.MaterialProperty;
import smartin.miapi.material.base.Material;
import smartin.miapi.modules.ItemModule;
import smartin.miapi.modules.ModuleInstance;
import smartin.miapi.modules.properties.DurabilityProperty;
import smartin.miapi.modules.properties.util.CodecProperty;
import smartin.miapi.modules.properties.util.CraftingProperty;
import smartin.miapi.modules.properties.util.MergeAble;
import smartin.miapi.modules.properties.util.MergeType;

public class AllowedMaterial
extends CodecProperty<AllowedMaterialData>
implements CraftingProperty,
MaterialCraftInfo {
    public static final ResourceLocation KEY = Miapi.id("allowed_material");
    public static AllowedMaterial property;
    public double materialCostClient = 0.0;
    public double materialRequirementClient = 0.0;
    public boolean wrongMaterial = false;
    public boolean smithingMaterial = false;
    public int slotHeight = 116;

    public AllowedMaterial() {
        super(AutoCodec.of(AllowedMaterialData.class).codec());
        property = this;
    }

    public List<String> getAllowedKeys(ItemModule module) {
        Optional optional = this.getData(module);
        if (optional.isPresent()) {
            return ((AllowedMaterialData)optional.get()).allowedMaterials;
        }
        return new ArrayList<String>();
    }

    public List<Material> getMaterials(String key) {
        return MaterialProperty.MATERIAL_REGISTRY.getFlatMap().values().stream().filter(a -> a.getGroups().contains(key)).collect(Collectors.toList());
    }

    @Override
    public List<Vec2> getSlotPositions() {
        ArrayList<Vec2> test = new ArrayList<Vec2>();
        test.add(new Vec2(96.0f, (float)(this.slotHeight - 12)));
        return test;
    }

    @Override
    public boolean shouldExecuteOnCraft(@Nullable ModuleInstance module, ModuleInstance root, ItemStack stack, CraftAction craftAction) {
        JsonElement element = craftAction.data.get(KEY);
        if (element != null) {
            return element.getAsBoolean();
        }
        return CraftingProperty.super.shouldExecuteOnCraft(module, root, stack, craftAction);
    }

    @Override
    public float getPriority() {
        return -1.0f;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public InteractAbleWidget createGui(int x, int y, int width, int height, CraftAction action) {
        return new MaterialCraftingWidget(this, x, y, width, height, action);
    }

    @Override
    public Component getWarning() {
        if (this.wrongMaterial) {
            if (this.smithingMaterial) {
                Component.translatable((String)"miapi.ui.craft.warning.material.wrong.smithing");
            }
            return Component.translatable((String)"miapi.ui.craft.warning.material.wrong");
        }
        return Component.translatable((String)"miapi.ui.craft.warning.material");
    }

    @Override
    public boolean canPerform(ItemStack old, ItemStack crafting, ModularWorkBenchEntity bench, Player player, CraftAction craftAction, ItemModule module, List<ItemStack> inventory, Map<ResourceLocation, JsonElement> data) {
        Optional optional = this.getData(module);
        ItemStack input = inventory.get(0);
        if (optional.isPresent()) {
            AllowedMaterialData json = (AllowedMaterialData)optional.get();
            Material material = MaterialProperty.getMaterialFromIngredient(input);
            this.materialRequirementClient = json.cost * (float)crafting.getCount();
            if (material != null) {
                boolean isAllowed = json.isValid(material);
                boolean bl = this.wrongMaterial = !isAllowed;
                if (isAllowed) {
                    this.materialCostClient = (double)input.getCount() * material.getValueOfItem(input);
                    return this.materialCostClient >= this.materialRequirementClient;
                }
                this.materialCostClient = 0.0;
                this.smithingMaterial = material.getGroups().contains("smithing");
            } else {
                this.smithingMaterial = false;
                this.wrongMaterial = false;
                this.materialCostClient = 0.0;
            }
            return false;
        }
        this.wrongMaterial = false;
        return true;
    }

    @Override
    public ItemStack preview(ItemStack old, ItemStack crafting, Player player, ModularWorkBenchEntity bench, CraftAction craftAction, ItemModule module, List<ItemStack> inventory, Map<ResourceLocation, JsonElement> data) {
        Material material;
        ModuleInstance newModule = craftAction.getModifyingModuleInstance(crafting);
        Optional optional = this.getData(module);
        ItemStack input = inventory.get(0);
        ItemStack materialStack = input.copy();
        if (optional.isPresent() && (material = MaterialProperty.getMaterialFromIngredient(input)) != null) {
            AllowedMaterialData json = (AllowedMaterialData)optional.get();
            boolean isAllowed = json.isValid(material);
            if (isAllowed) {
                MaterialProperty.setMaterial(newModule, material);
            }
            MiapiEvents.MaterialCraftEventData eventData = new MiapiEvents.MaterialCraftEventData(crafting, materialStack, material, newModule, craftAction);
            ((MiapiEvents.MaterialCraftEvent)MiapiEvents.MATERIAL_CRAFT_EVENT.invoker()).craft(eventData);
            crafting = eventData.crafted;
            newModule.getRoot().writeToItem(crafting);
        }
        if (crafting.isDamageableItem() && crafting.getDamageValue() > 0) {
            ModuleInstance moduleInstance = craftAction.getModifyingModuleInstance(crafting);
            Double scannedDurability = DurabilityProperty.property.getValue(moduleInstance).orElse(0.0);
            int durability = (int)((double)scannedDurability.intValue() * MiapiConfig.getServerConfig().other.repairRatio);
            crafting.setDamageValue(crafting.getDamageValue() - durability);
        }
        return crafting;
    }

    @Override
    public List<ItemStack> performCraftAction(ItemStack old, ItemStack crafting, Player player, ModularWorkBenchEntity bench, CraftAction craftAction, ItemModule module, List<ItemStack> inventory, Map<ResourceLocation, JsonElement> data) {
        ModuleInstance newModule = craftAction.getModifyingModuleInstance(crafting);
        ArrayList<ItemStack> results = new ArrayList<ItemStack>();
        ItemStack input = inventory.get(0);
        ItemStack materialStack = input.copy();
        Optional optional = this.getData(module);
        if (optional.isEmpty()) {
            Miapi.LOGGER.error("crafting without allowed Material? this probably is a bug!");
            results.add(crafting);
            results.add(input);
            return results;
        }
        AllowedMaterialData json = (AllowedMaterialData)optional.get();
        Material material = MaterialProperty.getMaterialFromIngredient(input);
        if (material != null) {
            int newCount = (int)((double)input.getCount() - Math.ceil((double)(json.cost * (float)crafting.getCount()) / material.getValueOfItem(input)));
            if (!player.level().isClientSide()) {
                input.setCount(newCount);
            }
            assert (newModule != null);
            MaterialProperty.setMaterial(newModule, material);
            newModule.getRoot().writeToItem(crafting);
            MiapiEvents.MaterialCraftEventData eventData = new MiapiEvents.MaterialCraftEventData(crafting, materialStack, material, newModule, craftAction);
            ((MiapiEvents.MaterialCraftEvent)MiapiEvents.MATERIAL_CRAFT_EVENT.invoker()).craft(eventData);
            crafting = eventData.crafted;
            if (crafting.isDamageableItem()) {
                int durability = (int)((double)DurabilityProperty.property.getValue(craftAction.getModifyingModuleInstance(crafting)).orElse(0.0).intValue() * MiapiConfig.getServerConfig().other.repairRatio);
                crafting.setDamageValue(crafting.getDamageValue() - durability);
            }
        } else {
            Miapi.LOGGER.error("craft was called with no valid material?! this should not be possible. the resulting item wont be changed");
        }
        results.add(crafting);
        results.add(input);
        return results;
    }

    public static double getMaterialCost(ModuleInstance moduleInstance) {
        Optional optional = property.getData(moduleInstance);
        if (optional.isPresent()) {
            return ((AllowedMaterialData)optional.get()).cost;
        }
        return 0.0;
    }

    @Override
    public AllowedMaterialData merge(AllowedMaterialData left, AllowedMaterialData right, MergeType mergeType) {
        return MergeAble.decideLeftRight(left, right, mergeType);
    }

    @Override
    public int getSlotHeight() {
        return this.slotHeight;
    }

    @Override
    public void setSlotHeight(int newHeight) {
        this.slotHeight = newHeight;
    }

    @Override
    public double getMaterialCostClient() {
        return this.materialCostClient;
    }

    @Override
    public double getMaterialRequirementClient() {
        return this.materialRequirementClient;
    }

    public static class AllowedMaterialData {
        public List<String> allowedMaterials;
        @CodecBehavior.Optional
        public float cost = 1.0f;

        public boolean isValid(Material material) {
            return this.allowedMaterials.stream().anyMatch(allowedMaterial -> material.getGroups().contains(allowedMaterial) || material.getID().toString().equals(allowedMaterial));
        }
    }
}

