/*
 * Decompiled with CFR 0.152.
 */
package smartin.miapi.material;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.mojang.serialization.codecs.UnboundedMapCodec;
import java.awt.Color;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.Block;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import org.jetbrains.annotations.Nullable;
import smartin.miapi.Environment;
import smartin.miapi.Miapi;
import smartin.miapi.blueprint.IngredientWithCount;
import smartin.miapi.item.modular.StatResolver;
import smartin.miapi.material.MaterialIcons;
import smartin.miapi.material.base.Material;
import smartin.miapi.material.base.PropertyController;
import smartin.miapi.material.palette.FallbackColorer;
import smartin.miapi.material.palette.MaterialRenderController;
import smartin.miapi.material.palette.MaterialRenderControllers;
import smartin.miapi.modules.ItemModule;
import smartin.miapi.modules.ModuleDataPropertiesManager;
import smartin.miapi.modules.ModuleInstance;
import smartin.miapi.modules.properties.render.ColorProperty;
import smartin.miapi.modules.properties.util.MergeType;
import smartin.miapi.modules.properties.util.ModuleProperty;

public class CodecMaterial
implements Material {
    ResourceLocation id;
    public Optional<JsonElement> iconJson;
    Optional<JsonElement> paletteJson;
    Optional<JsonElement> dyePaletteJson;
    Map<String, Map<ModuleProperty<?>, Object>> propertyMap = new HashMap();
    Map<String, Map<ModuleProperty<?>, Object>> displayPropertyMap = new HashMap();
    public List<String> groups;
    List<String> guiGroups;
    public List<String> textureKeys;
    Optional<TagKey<Block>> incorrectForTool = Optional.empty();
    Optional<Integer> color = Optional.empty();
    public List<IngredientWithCount> items;
    Optional<Boolean> generateConverters;
    public Map<String, String> stringData = new HashMap<String, String>();
    public Map<String, Double> doubleMap = new HashMap<String, Double>();
    public Optional<Component> translation = Optional.empty();
    @OnlyIn(value=Dist.CLIENT)
    public MaterialIcons.MaterialIcon icon;
    @OnlyIn(value=Dist.CLIENT)
    protected MaterialRenderController palette;
    @OnlyIn(value=Dist.CLIENT)
    @Nullable
    protected MaterialRenderController dyeAblePalette;
    public static final Codec<CodecMaterial> CODEC = new Codec<CodecMaterial>(){

        public <T> DataResult<Pair<CodecMaterial, T>> decode(DynamicOps<T> ops, T input) {
            HashMap<String, String> stringData = new HashMap<String, String>();
            HashMap<String, Double> doubleMap = new HashMap<String, Double>();
            ((JsonElement)ops.convertTo((DynamicOps)JsonOps.INSTANCE, input)).getAsJsonObject().asMap().forEach((string, element) -> {
                if (element.isJsonPrimitive()) {
                    try {
                        stringData.put((String)string, element.getAsString());
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    try {
                        doubleMap.put((String)string, element.getAsDouble());
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            });
            DataResult dataResult = INNER_CODEC.decode(ops, input);
            if (dataResult.isSuccess()) {
                ((CodecMaterial)((Pair)dataResult.getOrThrow()).getFirst()).setData(stringData, doubleMap);
            }
            return dataResult;
        }

        public <T> DataResult<T> encode(CodecMaterial input, DynamicOps<T> ops, T prefix) {
            UnboundedMapCodec stringCodec = Codec.unboundedMap((Codec)Codec.STRING, (Codec)Codec.STRING);
            prefix = stringCodec.encode(input.stringData, ops, prefix).result().get();
            UnboundedMapCodec doubleCodec = Codec.unboundedMap((Codec)Codec.STRING, (Codec)Codec.DOUBLE);
            prefix = doubleCodec.encode(input.doubleMap, ops, prefix).result().get();
            return INNER_CODEC.encode((Object)input, ops, prefix);
        }
    };
    public static final Codec<CodecMaterial> INNER_CODEC = RecordCodecBuilder.create(instance -> instance.group((App)StatResolver.Codecs.JSONELEMENT_CODEC.optionalFieldOf("icon").forGetter(material -> material.iconJson), (App)StatResolver.Codecs.JSONELEMENT_CODEC.optionalFieldOf("color_palette").forGetter(material -> material.paletteJson), (App)StatResolver.Codecs.JSONELEMENT_CODEC.optionalFieldOf("dye_color_palette").forGetter(material -> material.dyePaletteJson), (App)Codec.STRING.listOf().optionalFieldOf("groups", new ArrayList()).forGetter(CodecMaterial::getGroups), (App)Codec.STRING.listOf().optionalFieldOf("hidden_groups", new ArrayList()).forGetter(CodecMaterial::getGuiGroups), (App)Codec.STRING.listOf().optionalFieldOf("gui_groups", new ArrayList()).forGetter(CodecMaterial::getGuiGroups), (App)Codec.unboundedMap((Codec)Codec.STRING, StatResolver.Codecs.JSONELEMENT_CODEC).optionalFieldOf("properties", new HashMap()).forGetter(m -> PropertyController.toJsonMap(m.getActualProperty())), (App)Codec.unboundedMap((Codec)Codec.STRING, StatResolver.Codecs.JSONELEMENT_CODEC).optionalFieldOf("display_properties", new HashMap()).forGetter(m -> PropertyController.toJsonMap(m.getDisplayProperty())), (App)Codec.unboundedMap((Codec)Codec.STRING, StatResolver.Codecs.JSONELEMENT_CODEC).optionalFieldOf("hidden_properties", new HashMap()).forGetter(m -> PropertyController.toJsonMap(m.getHiddenProperty())), (App)Codec.STRING.listOf().optionalFieldOf("textures", List.of("default")).forGetter(CodecMaterial::getTextureKeys), (App)ResourceLocation.CODEC.optionalFieldOf("mining_level").forGetter(material -> Optional.of(material.getIncorrectBlocksForDrops().location())), (App)Codec.STRING.optionalFieldOf("color").forGetter(m -> Optional.of(Long.toHexString(m.getColor(new ModuleInstance(ItemModule.empty))))), (App)IngredientWithCount.CODEC.listOf().optionalFieldOf("items", new ArrayList()).forGetter(material -> material.items), (App)Miapi.FIXED_BOOL_CODEC.optionalFieldOf("generate_converters").forGetter(m -> Optional.of(m.generateConverters()))).apply((Applicative)instance, CodecMaterial::new));
    @OnlyIn(value=Dist.CLIENT)
    public FallbackColorer fallbackColorer;

    public CodecMaterial(Optional<JsonElement> iconJson, Optional<JsonElement> paletteJson, Optional<JsonElement> dyePaletteJson, List<String> groups, List<String> hiddenGroups, List<String> guiGroups, Map<String, JsonElement> property, Map<String, JsonElement> visualProperty, Map<String, JsonElement> hiddenProperty, List<String> textureKeys, Optional<ResourceLocation> incorrectForToolId, Optional<String> color, List<IngredientWithCount> items, Optional<Boolean> generateConverters) {
        this.iconJson = iconJson;
        this.paletteJson = paletteJson;
        this.dyePaletteJson = dyePaletteJson;
        this.groups = new ArrayList<String>(groups);
        this.guiGroups = new ArrayList<String>(guiGroups);
        this.guiGroups.addAll(groups);
        this.groups.addAll(hiddenGroups);
        this.textureKeys = textureKeys;
        if (incorrectForToolId.isPresent()) {
            Optional<Pair> found = BuiltInRegistries.BLOCK.getTags().filter(pair -> ((TagKey)pair.getFirst()).location().equals(incorrectForToolId.get())).findAny();
            found.ifPresent(tagKeyNamedPair -> {
                this.incorrectForTool = Optional.of((TagKey)tagKeyNamedPair.getFirst());
            });
        }
        if (color.isPresent()) {
            long longValue = Long.parseLong(color.get(), 16);
            this.color = Optional.of((int)(longValue & 0xFFFFFFFFL));
        }
        this.items = items;
        this.generateConverters = generateConverters;
        hiddenProperty.forEach((type, json) -> this.propertyMap.put((String)type, ModuleDataPropertiesManager.resolvePropertiesFromJson(json)));
        property.forEach((type, json) -> {
            this.propertyMap.put((String)type, ModuleDataPropertiesManager.resolvePropertiesFromJson(json));
            this.displayPropertyMap.put((String)type, ModuleDataPropertiesManager.resolvePropertiesFromJson(json));
        });
        visualProperty.forEach((type, json) -> this.displayPropertyMap.put((String)type, ModuleDataPropertiesManager.resolvePropertiesFromJson(json)));
        if (Environment.isClient()) {
            this.clientSetup(iconJson, paletteJson, dyePaletteJson);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    private void clientSetup(Optional<JsonElement> iconJson, Optional<JsonElement> paletteJson, Optional<JsonElement> dyePaletteJson) {
        if (iconJson.isPresent()) {
            JsonPrimitive primitive;
            JsonElement jsonElement = iconJson.get();
            this.icon = jsonElement instanceof JsonPrimitive && (primitive = (JsonPrimitive)jsonElement).isString() ? new MaterialIcons.TextureMaterialIcon(ResourceLocation.parse((String)primitive.getAsString())) : MaterialIcons.getMaterialIcon(this.id, iconJson.get());
        }
        if (paletteJson.isPresent()) {
            this.palette = MaterialRenderControllers.creators.get(paletteJson.get().getAsJsonObject().get("type").getAsString()).createPalette(paletteJson.get(), this);
            if (this.color.isEmpty()) {
                this.color = Optional.of(this.palette.getAverageColor().argb());
            }
        }
        dyePaletteJson.ifPresent(element -> {
            this.dyeAblePalette = MaterialRenderControllers.creators.get(element.getAsJsonObject().get("type").getAsString()).createPalette((JsonElement)element, this);
        });
    }

    public CodecMaterial copy() {
        CodecMaterial copy = new CodecMaterial(this.iconJson, this.paletteJson, this.dyePaletteJson, new ArrayList<String>(this.groups), List.of(), new ArrayList<String>(this.guiGroups), PropertyController.toJsonMap(this.getActualProperty()), PropertyController.toJsonMap(this.getDisplayProperty()), PropertyController.toJsonMap(this.getHiddenProperty()), new ArrayList<String>(this.textureKeys), this.incorrectForTool.map(TagKey::location), this.color.map(Integer::toHexString), new ArrayList<IngredientWithCount>(this.items), this.generateConverters);
        copy.id = this.id;
        copy.stringData = new HashMap<String, String>(this.stringData);
        copy.doubleMap = new HashMap<String, Double>(this.doubleMap);
        copy.propertyMap = new HashMap(this.propertyMap);
        copy.displayPropertyMap = new HashMap(this.displayPropertyMap);
        copy.incorrectForTool = this.incorrectForTool;
        copy.translation = this.translation;
        copy.iconJson = this.iconJson;
        copy.paletteJson = this.paletteJson;
        copy.dyePaletteJson = this.dyePaletteJson;
        if (Environment.isClient()) {
            this.copyClient(copy);
        }
        return copy;
    }

    @OnlyIn(value=Dist.CLIENT)
    private void copyClient(CodecMaterial copy) {
        if (this.iconJson.isPresent()) {
            JsonPrimitive primitive;
            JsonElement jsonElement = this.iconJson.get();
            copy.icon = jsonElement instanceof JsonPrimitive && (primitive = (JsonPrimitive)jsonElement).isString() ? new MaterialIcons.TextureMaterialIcon(ResourceLocation.parse((String)primitive.getAsString())) : MaterialIcons.getMaterialIcon(this.id, this.iconJson.get());
        }
        if (copy.paletteJson.isPresent()) {
            copy.palette = MaterialRenderControllers.creators.get(copy.paletteJson.get().getAsJsonObject().get("type").getAsString()).createPalette(copy.paletteJson.get(), this);
            if (copy.color.isEmpty()) {
                copy.color = Optional.of(this.palette.getAverageColor().argb());
            }
        }
        if (copy.dyePaletteJson.isPresent()) {
            copy.dyeAblePalette = MaterialRenderControllers.creators.get(copy.dyePaletteJson.get().getAsJsonObject().get("type").getAsString()).createPalette(copy.dyePaletteJson.get(), this);
            if (copy.color.isEmpty()) {
                copy.color = Optional.of(this.dyeAblePalette.getAverageColor().argb());
            }
        }
    }

    public void merge(CodecMaterial material) {
        if (material.iconJson.isPresent()) {
            this.iconJson = material.iconJson;
        }
        if (material.paletteJson.isPresent()) {
            this.paletteJson = material.paletteJson;
        }
        this.groups = new ArrayList<String>(this.groups);
        this.groups.addAll(material.groups);
        this.guiGroups = new ArrayList<String>(this.guiGroups);
        this.guiGroups.addAll(material.guiGroups);
        CodecMaterial.mergeProperties(material.propertyMap, this.propertyMap);
        CodecMaterial.mergeProperties(material.displayPropertyMap, this.displayPropertyMap);
        this.textureKeys = new ArrayList<String>(this.textureKeys);
        this.textureKeys.addAll(material.textureKeys);
        material.incorrectForTool.ifPresent(tagKey -> {
            this.incorrectForTool = Optional.of(tagKey);
        });
        if (material.color.isPresent()) {
            this.color = material.color;
        }
        this.items = new ArrayList<IngredientWithCount>(this.items);
        this.items.addAll(material.items);
        if (material.generateConverters.isPresent()) {
            this.generateConverters = material.generateConverters;
        }
        this.stringData.putAll(material.stringData);
        this.doubleMap.putAll(material.doubleMap);
        material.translation.ifPresent(value -> {
            this.translation = Optional.of(value);
        });
        if (Environment.isClient()) {
            this.mergeClient(material);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    private void mergeClient(CodecMaterial material) {
        if (material.icon != null) {
            this.icon = material.icon;
        }
        if (material.palette != null) {
            this.palette = material.palette;
        }
        this.dyeAblePalette = material.dyeAblePalette;
    }

    private static void mergeProperties(Map<String, Map<ModuleProperty<?>, Object>> source, Map<String, Map<ModuleProperty<?>, Object>> target) {
        source.forEach((key, sourceProperties) -> {
            Map targetProperties = target.getOrDefault(key, new HashMap());
            sourceProperties.forEach((property, sourceValue) -> {
                if (targetProperties.containsKey(property)) {
                    Object targetValue = targetProperties.get(property);
                    targetProperties.put(property, ItemModule.merge(property, targetValue, sourceValue, MergeType.SMART));
                } else {
                    targetProperties.put(property, sourceValue);
                }
            });
            target.put((String)key, targetProperties);
        });
    }

    public void setID(ResourceLocation id) {
        this.id = id;
        ArrayList<String> g = new ArrayList<String>(this.groups);
        g.addFirst(this.getStringID());
        this.groups = g;
        ArrayList<String> uiGroups = new ArrayList<String>(this.guiGroups);
        uiGroups.addFirst(this.getStringID());
        this.guiGroups = uiGroups;
    }

    public void setData(Map<String, String> stringData, Map<String, Double> doubleMap) {
        this.stringData = stringData;
        this.doubleMap = doubleMap;
    }

    @Override
    public double getDouble(String property) {
        return this.doubleMap.getOrDefault(property, 0.0);
    }

    @Override
    public String getData(String property) {
        return this.stringData.getOrDefault(property, "");
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public int renderIcon(GuiGraphics drawContext, int x, int y) {
        if (this.icon == null) {
            return 0;
        }
        return this.icon.render(drawContext, x, y);
    }

    @Override
    public void addSmithingGroup() {
        if (!this.groups.contains("smithing")) {
            this.groups = new ArrayList<String>(this.groups);
            this.groups.add("smithing");
        }
        if (!this.guiGroups.contains("smithing")) {
            this.guiGroups = new ArrayList<String>(this.guiGroups);
            this.guiGroups.add("smithing");
        }
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public boolean hasIcon() {
        return this.icon != null;
    }

    @Override
    public ResourceLocation getID() {
        return this.id;
    }

    @Override
    public List<String> getGroups() {
        return this.groups;
    }

    @Override
    public List<String> getGuiGroups() {
        return this.guiGroups;
    }

    @Override
    public Map<ModuleProperty<?>, Object> materialProperties(String key) {
        return this.propertyMap.getOrDefault(key, new HashMap());
    }

    @Override
    public Map<ModuleProperty<?>, Object> getDisplayMaterialProperties(String key) {
        return this.displayPropertyMap.getOrDefault(key, new HashMap());
    }

    @Override
    public List<String> getAllPropertyKeys() {
        return new ArrayList<String>(this.propertyMap.keySet());
    }

    @Override
    public List<String> getAllDisplayPropertyKeys() {
        return new ArrayList<String>(this.displayPropertyMap.keySet());
    }

    @Override
    public List<String> getTextureKeys() {
        return this.textureKeys;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public int getColor(ModuleInstance context) {
        return this.color.orElse(Color.BLACK.getRGB());
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public MaterialRenderController getRenderController(ModuleInstance context, ItemDisplayContext mode) {
        if (context.contextStack != null && ColorProperty.hasColor(context.contextStack, context) && this.dyeAblePalette != null) {
            return this.dyeAblePalette;
        }
        if (this.palette == null) {
            if (this.fallbackColorer == null) {
                this.fallbackColorer = new FallbackColorer(this);
            }
            return this.fallbackColorer;
        }
        return this.palette;
    }

    @Override
    public boolean canBeDyed() {
        return this.dyePaletteJson.isPresent();
    }

    @Override
    public double getValueOfItem(ItemStack item) {
        if (this.items == null) {
            return 0.0;
        }
        for (IngredientWithCount value : this.items) {
            if (!value.ingredient.test(item)) continue;
            return value.count;
        }
        return 0.0;
    }

    @Override
    public Double getPriorityOfIngredientItem(ItemStack item) {
        if (this.items == null) {
            return null;
        }
        for (IngredientWithCount value : this.items) {
            if (!value.ingredient.test(item)) continue;
            return value.count;
        }
        return null;
    }

    @Override
    public JsonObject getDebugJson() {
        return ((JsonElement)CODEC.encodeStart((DynamicOps)JsonOps.INSTANCE, (Object)this).getOrThrow()).getAsJsonObject();
    }

    @Override
    public TagKey<Block> getIncorrectBlocksForDrops() {
        return this.incorrectForTool.orElse((TagKey<Block>)BlockTags.INCORRECT_FOR_WOODEN_TOOL);
    }

    public int hashCode() {
        return this.getID().hashCode();
    }
}

