/*
 * Decompiled with CFR 0.152.
 */
package smartin.miapi.material;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.block.Block;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import org.jetbrains.annotations.Nullable;
import smartin.miapi.Miapi;
import smartin.miapi.material.MaterialIcons;
import smartin.miapi.material.base.Material;
import smartin.miapi.material.palette.FallbackColorer;
import smartin.miapi.material.palette.MaterialRenderController;
import smartin.miapi.material.palette.MaterialRenderControllers;
import smartin.miapi.modules.ItemModule;
import smartin.miapi.modules.ModuleInstance;
import smartin.miapi.modules.properties.util.MergeType;
import smartin.miapi.modules.properties.util.ModuleProperty;
import smartin.miapi.registries.FakeTranslation;
import smartin.miapi.registries.RegistryInventory;

public class JsonMaterial
implements Material {
    public ResourceLocation id;
    protected JsonElement rawJson;
    @OnlyIn(value=Dist.CLIENT)
    @Nullable
    public MaterialIcons.MaterialIcon icon;
    @OnlyIn(value=Dist.CLIENT)
    protected MaterialRenderController palette;
    public Map<String, Map<ModuleProperty<?>, Object>> propertyMap = new HashMap();
    public Map<String, Map<ModuleProperty<?>, Object>> displayPropertyMap = new HashMap();
    TagKey<Block> incorrectForTool = BlockTags.INCORRECT_FOR_WOODEN_TOOL;

    public JsonMaterial(ResourceLocation id, JsonObject element, boolean isClient) {
        this.rawJson = element;
        this.id = id;
        if (isClient) {
            this.setupClient(element);
        }
        this.mergeJson(this.rawJson, isClient);
    }

    @OnlyIn(value=Dist.CLIENT)
    private void setupClient(JsonObject element) {
        if (element.has("icon")) {
            JsonPrimitive primitive;
            JsonElement emnt = element.get("icon");
            this.icon = emnt instanceof JsonPrimitive && (primitive = (JsonPrimitive)emnt).isString() ? new MaterialIcons.TextureMaterialIcon(ResourceLocation.parse((String)primitive.getAsString())) : MaterialIcons.getMaterialIcon(this.id, emnt);
        }
        if (element.has("color_palette")) {
            JsonElement innerElement = element.get("color_palette");
            this.palette = MaterialRenderControllers.creators.get(innerElement.getAsJsonObject().get("type").getAsString()).createPalette(innerElement, this);
        } else {
            this.palette = new FallbackColorer(this);
        }
        if (element.has("fake_translation") && element.has("translation")) {
            FakeTranslation.translations.put(element.get("translation").getAsString(), element.get("fake_translation").getAsString());
        }
        if (this.getTranslation().getString().contains(".")) {
            Miapi.LOGGER.warn("Material " + this.getID().toString() + " likely has a broken Translation!+ The correct key would be miapi.material." + this.getStringID());
        }
    }

    public void mergeJson(JsonElement rootElement, boolean isClient) {
        rootElement.getAsJsonObject().asMap().forEach((elementName, propertyElement) -> {
            switch (elementName) {
                case "properties": {
                    JsonMaterial.mergeProperties(propertyElement, this.propertyMap);
                    JsonMaterial.mergeProperties(propertyElement, this.displayPropertyMap);
                    break;
                }
                case "display_properties": {
                    JsonMaterial.mergeProperties(propertyElement, this.displayPropertyMap);
                    break;
                }
                case "mining_level": {
                    ResourceLocation id = (ResourceLocation)((Pair)ResourceLocation.CODEC.decode((DynamicOps)JsonOps.INSTANCE, propertyElement).getOrThrow()).getFirst();
                    Optional<Pair> found = BuiltInRegistries.BLOCK.getTags().filter(pair -> ((TagKey)pair.getFirst()).location().equals((Object)id)).findAny();
                    found.ifPresent(tagKeyNamedPair -> {
                        this.incorrectForTool = (TagKey)tagKeyNamedPair.getFirst();
                    });
                    break;
                }
                case "hidden_properties": {
                    JsonMaterial.mergeProperties(propertyElement, this.propertyMap);
                    break;
                }
                case "color_palette": {
                    this.mergePalette(isClient, (JsonElement)propertyElement);
                    break;
                }
                case "icon": {
                    this.mergeIcon(isClient, (JsonElement)propertyElement);
                    break;
                }
                case "fake_translation": {
                    this.mergeTranslation(isClient, (JsonElement)propertyElement);
                    break;
                }
                default: {
                    this.rawJson.getAsJsonObject().add(elementName, propertyElement);
                }
            }
        });
    }

    @OnlyIn(value=Dist.CLIENT)
    private void mergeTranslation(boolean isClient, JsonElement propertyElement) {
        if (isClient) {
            FakeTranslation.translations.put(this.rawJson.getAsJsonObject().get("fake_translation").getAsString(), propertyElement.getAsString());
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    private void mergeIcon(boolean isClient, JsonElement propertyElement) {
        if (isClient) {
            JsonPrimitive primitive;
            JsonElement emnt = propertyElement;
            this.icon = emnt instanceof JsonPrimitive && (primitive = (JsonPrimitive)emnt).isString() ? new MaterialIcons.TextureMaterialIcon(ResourceLocation.parse((String)primitive.getAsString())) : MaterialIcons.getMaterialIcon(this.id, emnt);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    private void mergePalette(boolean isClient, JsonElement propertyElement) {
        if (isClient) {
            this.palette = MaterialRenderControllers.creators.get(propertyElement.getAsJsonObject().get("type").getAsString()).createPalette(propertyElement, this);
        }
    }

    private static void mergeProperties(JsonElement propertyElement, Map<String, Map<ModuleProperty<?>, Object>> properties) {
        propertyElement.getAsJsonObject().asMap().forEach((id, element) -> {
            if (element != null) {
                element.getAsJsonObject().entrySet().forEach(stringJsonElementEntry -> {
                    Map specificPropertyMap;
                    block5: {
                        ModuleProperty property = RegistryInventory.MODULE_PROPERTY_MIAPI_REGISTRY.get(Miapi.id((String)stringJsonElementEntry.getKey()));
                        specificPropertyMap = properties.getOrDefault(id, new HashMap());
                        if (property != null) {
                            try {
                                if (specificPropertyMap.containsKey(property)) {
                                    specificPropertyMap.put(property, ItemModule.merge(property, specificPropertyMap.get(property), property.decode((JsonElement)stringJsonElementEntry.getValue()), MergeType.SMART));
                                    break block5;
                                }
                                specificPropertyMap.put(property, property.decode((JsonElement)stringJsonElementEntry.getValue()));
                            }
                            catch (Exception e) {
                                Miapi.LOGGER.error("Could not load property in material :", (Throwable)e);
                            }
                        } else {
                            Miapi.LOGGER.error("Could not find property " + (String)stringJsonElementEntry.getKey());
                            Miapi.LOGGER.error(String.valueOf(propertyElement));
                        }
                    }
                    properties.put((String)id, specificPropertyMap);
                });
            }
        });
    }

    @Override
    public ResourceLocation getID() {
        return this.id;
    }

    @Override
    public List<String> getGroups() {
        String group;
        JsonArray groupsJson;
        ArrayList<String> groups = new ArrayList<String>();
        groups.add(this.id.toString());
        if (this.rawJson.getAsJsonObject().has("groups")) {
            groupsJson = this.rawJson.getAsJsonObject().getAsJsonArray("groups");
            for (JsonElement groupElement : groupsJson) {
                group = groupElement.getAsString();
                groups.add(group);
            }
        }
        if (this.rawJson.getAsJsonObject().has("hidden_groups")) {
            groupsJson = this.rawJson.getAsJsonObject().getAsJsonArray("hidden_groups");
            for (JsonElement groupElement : groupsJson) {
                group = groupElement.getAsString();
                groups.add(group);
            }
        }
        return groups;
    }

    @Override
    public List<String> getGuiGroups() {
        ArrayList<String> groups = new ArrayList<String>();
        groups.add(this.id.toString());
        if (this.rawJson.getAsJsonObject().has("groups")) {
            JsonArray groupsJson = this.rawJson.getAsJsonObject().getAsJsonArray("groups");
            for (JsonElement groupElement : groupsJson) {
                String group = groupElement.getAsString();
                groups.add(group);
            }
        }
        return groups;
    }

    @Override
    public Map<ModuleProperty<?>, Object> materialProperties(String key) {
        return this.propertyMap.getOrDefault(key, new HashMap());
    }

    @Override
    public Map<ModuleProperty<?>, Object> getDisplayMaterialProperties(String key) {
        return this.displayPropertyMap.getOrDefault(key, new HashMap());
    }

    @Override
    public List<String> getAllPropertyKeys() {
        return new ArrayList<String>(this.propertyMap.keySet());
    }

    @Override
    public List<String> getAllDisplayPropertyKeys() {
        return new ArrayList<String>(this.displayPropertyMap.keySet());
    }

    public JsonElement getRawElement(String key) {
        return this.rawJson.getAsJsonObject().get(key);
    }

    @Override
    public double getDouble(String property) {
        String[] keys = property.split("\\.");
        JsonElement jsonData = this.rawJson;
        for (String k : keys) {
            if ((jsonData = jsonData.getAsJsonObject().get(k)) == null || !jsonData.isJsonObject()) break;
        }
        if (jsonData != null && jsonData.isJsonNull()) {
            Miapi.LOGGER.info(String.valueOf(this.rawJson));
        }
        if (jsonData != null && jsonData.isJsonPrimitive()) {
            try {
                return jsonData.getAsDouble();
            }
            catch (Exception e) {
                Miapi.LOGGER.error("Material data " + property + " was not a Number!" + String.valueOf(jsonData));
            }
        }
        return 0.0;
    }

    @Override
    public String getData(String property) {
        String[] keys = property.split("\\.");
        JsonElement jsonData = this.rawJson;
        for (String key : keys) {
            if ((jsonData = jsonData.getAsJsonObject().get(key)) == null || !jsonData.isJsonObject()) break;
        }
        if (jsonData != null && jsonData.isJsonPrimitive()) {
            return jsonData.getAsString();
        }
        return "";
    }

    @Override
    public boolean generateConverters() {
        JsonElement element;
        if (this.rawJson.getAsJsonObject().has("generate_converters") && (element = this.rawJson.getAsJsonObject().get("generate_converters")) != null && !element.isJsonNull() && element.isJsonPrimitive()) {
            return element.getAsBoolean();
        }
        return false;
    }

    @Override
    public List<String> getTextureKeys() {
        ArrayList<String> textureKeys = new ArrayList<String>();
        if (this.rawJson.getAsJsonObject().has("textures")) {
            JsonArray textures = this.rawJson.getAsJsonObject().getAsJsonArray("textures");
            for (JsonElement texture : textures) {
                textureKeys.add(texture.getAsString());
            }
        }
        textureKeys.add("default");
        return new ArrayList<String>(textureKeys);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public int getColor(ModuleInstance context) {
        if (this.rawJson.getAsJsonObject().get("color") != null) {
            long longValue = Long.parseLong(this.rawJson.getAsJsonObject().get("color").getAsString(), 16);
            return (int)(longValue & 0xFFFFFFFFL);
        }
        return this.getRenderController(context, ItemDisplayContext.GUI).getAverageColor().argb();
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public MaterialRenderController getRenderController(ModuleInstance context, ItemDisplayContext mode) {
        if (this.palette == null) {
            return new FallbackColorer(this);
        }
        return this.palette;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public int renderIcon(GuiGraphics drawContext, int x, int y) {
        if (this.icon == null) {
            return 0;
        }
        return this.icon.render(drawContext, x, y);
    }

    @Override
    public void addSmithingGroup() {
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public boolean hasIcon() {
        return this.icon != null;
    }

    @Override
    public double getValueOfItem(ItemStack item) {
        JsonArray items = this.rawJson.getAsJsonObject().getAsJsonArray("items");
        for (JsonElement element : items) {
            Ingredient ingredient;
            JsonObject itemObj = element.getAsJsonObject();
            if (itemObj.has("item")) {
                String itemId = itemObj.get("item").getAsString();
                if (!BuiltInRegistries.ITEM.getKey((Object)item.getItem()).toString().equals(itemId)) continue;
                try {
                    return itemObj.get("value").getAsDouble();
                }
                catch (Exception surpressed) {
                    return 1.0;
                }
            }
            if (itemObj.has("tag")) {
                String tagId = itemObj.get("tag").getAsString();
                TagKey tag = TagKey.create((ResourceKey)BuiltInRegistries.ITEM.key(), (ResourceLocation)ResourceLocation.parse((String)tagId));
                if (tag == null || !item.is(tag)) continue;
                try {
                    return itemObj.get("value").getAsDouble();
                }
                catch (Exception suppressed) {
                    return 1.0;
                }
            }
            if (!itemObj.has("ingredient") || !(ingredient = (Ingredient)((Pair)Ingredient.CODEC.decode((DynamicOps)JsonOps.INSTANCE, (Object)itemObj.get("ingredient")).getOrThrow()).getFirst()).test(item)) continue;
            try {
                return itemObj.get("value").getAsDouble();
            }
            catch (Exception suppressed) {
                return 1.0;
            }
        }
        return 0.0;
    }

    @Override
    public Double getPriorityOfIngredientItem(ItemStack itemStack) {
        if (this.getRawElement("items") != null && this.getRawElement("items").isJsonArray()) {
            JsonObject itemObj;
            JsonArray items = this.getRawElement("items").getAsJsonArray();
            for (JsonElement element : items) {
                itemObj = element.getAsJsonObject();
                if (!itemObj.has("item")) continue;
                String itemId = itemObj.get("item").getAsString();
                if (!BuiltInRegistries.ITEM.getKey((Object)itemStack.getItem()).toString().equals(itemId)) continue;
                return 0.0;
            }
            for (JsonElement element : items) {
                Ingredient ingredient;
                itemObj = element.getAsJsonObject();
                if (!itemObj.has("ingredient") || !(ingredient = (Ingredient)((Pair)Ingredient.CODEC.decode((DynamicOps)JsonOps.INSTANCE, (Object)itemObj.get("ingredient")).getOrThrow()).getFirst()).test(itemStack)) continue;
                return 5.0;
            }
            for (JsonElement element : items) {
                itemObj = element.getAsJsonObject();
                if (!itemObj.has("tag")) continue;
                String tagId = itemObj.get("tag").getAsString();
                TagKey tag = TagKey.create((ResourceKey)BuiltInRegistries.ITEM.key(), (ResourceLocation)ResourceLocation.parse((String)tagId));
                if (tag == null || !itemStack.is(tag)) continue;
                return 10.0;
            }
        }
        return null;
    }

    @Override
    public JsonObject getDebugJson() {
        return this.rawJson.getAsJsonObject();
    }

    @Override
    public TagKey<Block> getIncorrectBlocksForDrops() {
        return this.incorrectForTool;
    }

    public int hashCode() {
        return this.getID().hashCode();
    }
}

