/*
 * Decompiled with CFR 0.152.
 */
package smartin.miapi.material;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.suggestion.SuggestionProvider;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import java.util.List;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import smartin.miapi.material.MaterialProperty;
import smartin.miapi.material.base.Material;
import smartin.miapi.network.Networking;

public class MaterialCommand {
    public static String SEND_MATERIAL_CLIENT = "miapi_material_debug";
    private static final SuggestionProvider<CommandSourceStack> MATERIAL_SUGGESTIONS = (context, builder) -> {
        List<String> materialOptions = MaterialCommand.getMaterialOptions();
        materialOptions.forEach(arg_0 -> ((SuggestionsBuilder)builder).suggest(arg_0));
        return builder.buildFuture();
    };

    public static void register(CommandDispatcher<CommandSourceStack> dispatcher) {
        LiteralArgumentBuilder literal = (LiteralArgumentBuilder)Commands.literal((String)"miapi").then(Commands.literal((String)"material").then(Commands.argument((String)"material_id", (ArgumentType)StringArgumentType.word()).suggests(MATERIAL_SUGGESTIONS).executes(MaterialCommand::executeMaterialCommand)));
        LiteralArgumentBuilder getHand = (LiteralArgumentBuilder)Commands.literal((String)"miapi").then(Commands.literal((String)"get-hand-material").executes(MaterialCommand::getHandMaterial));
        dispatcher.register(literal);
        dispatcher.register(getHand);
    }

    private static int getHandMaterial(CommandContext<CommandSourceStack> context) {
        if (((CommandSourceStack)context.getSource()).isPlayer()) {
            ServerPlayer player = ((CommandSourceStack)context.getSource()).getPlayer();
            Material material = MaterialProperty.getMaterialFromIngredient(player.getMainHandItem());
            if (material != null) {
                player.sendSystemMessage((Component)Component.literal((String)("Handheld Material " + String.valueOf(material.getID()))));
                FriendlyByteBuf buf = Networking.createBuffer();
                buf.writeUtf(material.getID().toString());
                Networking.sendS2C(SEND_MATERIAL_CLIENT, ((CommandSourceStack)context.getSource()).getPlayer(), buf);
            } else {
                player.sendSystemMessage((Component)Component.literal((String)"Handheld Item is no Material"));
            }
            return 1;
        }
        ((CommandSourceStack)context.getSource()).sendFailure((Component)Component.literal((String)"Handheld Item is no Material"));
        return 0;
    }

    private static int executeMaterialCommand(CommandContext<CommandSourceStack> context) {
        String materialId = StringArgumentType.getString(context, (String)"material_id");
        List<String> materialOptions = MaterialCommand.getMaterialOptions();
        if (materialOptions.contains(materialId)) {
            ((CommandSourceStack)context.getSource()).sendSuccess(() -> Component.literal((String)("Material ID is valid: " + materialId)), false);
            if (((CommandSourceStack)context.getSource()).isPlayer()) {
                FriendlyByteBuf buf = Networking.createBuffer();
                buf.writeUtf(materialId);
                Networking.sendS2C(SEND_MATERIAL_CLIENT, ((CommandSourceStack)context.getSource()).getPlayer(), buf);
            }
            return 1;
        }
        ((CommandSourceStack)context.getSource()).sendFailure((Component)Component.literal((String)("Invalid material ID: " + materialId)));
        return 0;
    }

    private static List<String> getMaterialOptions() {
        return MaterialProperty.MATERIAL_REGISTRY.getFlatMap().values().stream().map(Material::getStringID).toList();
    }
}

