/*
 * Decompiled with CFR 0.152.
 */
package smartin.miapi.material;

import com.mojang.serialization.Codec;
import dev.architectury.event.EventResult;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import net.minecraft.core.component.DataComponents;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.PotionItem;
import net.minecraft.world.item.alchemy.PotionContents;
import smartin.miapi.events.MiapiEvents;
import smartin.miapi.modules.StackStorageComponent;
import smartin.miapi.modules.properties.util.CodecProperty;
import smartin.miapi.modules.properties.util.MergeAble;
import smartin.miapi.modules.properties.util.MergeType;

public class MaterialInscribeProperty
extends CodecProperty<String> {
    public static final String KEY = "inscribe_on_craft";
    public static MaterialInscribeProperty property;

    public MaterialInscribeProperty() {
        super(Codec.STRING);
        property = this;
        MiapiEvents.MATERIAL_CRAFT_EVENT.register(listener -> {
            listener.crafted = MaterialInscribeProperty.inscribe(listener.crafted, listener.materialStack);
            return EventResult.pass();
        });
    }

    public static ItemStack inscribe(ItemStack raw, ItemStack materialStack) {
        Optional<String> optional = property.getData(raw);
        optional.ifPresent(s -> raw.update(StackStorageComponent.STACK_STORAGE_COMPONENT, Map.of(), old -> {
            PotionContents contents;
            HashMap<String, ItemStack> map = new HashMap<String, ItemStack>((Map<String, ItemStack>)old);
            map.put((String)s, materialStack);
            if (materialStack.getItem() instanceof PotionItem && (contents = (PotionContents)materialStack.get(DataComponents.POTION_CONTENTS)) != null) {
                raw.set(DataComponents.POTION_CONTENTS, (Object)contents);
            }
            return map;
        }));
        return raw;
    }

    @Override
    public String merge(String left, String right, MergeType mergeType) {
        return MergeAble.decideLeftRight(left, right, mergeType);
    }
}

