/*
 * Decompiled with CFR 0.152.
 */
package smartin.miapi.material;

import com.mojang.serialization.Codec;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import smartin.miapi.Miapi;
import smartin.miapi.item.modular.PropertyResolver;
import smartin.miapi.material.MaterialProperty;
import smartin.miapi.material.base.Material;
import smartin.miapi.modules.properties.util.CodecProperty;
import smartin.miapi.modules.properties.util.MergeAble;
import smartin.miapi.modules.properties.util.MergeType;
import smartin.miapi.modules.properties.util.ModuleProperty;

public class MaterialProperties
extends CodecProperty<List<String>> {
    public static final ResourceLocation KEY = Miapi.id("material_property");
    public static MaterialProperties property;

    public MaterialProperties() {
        super(Codec.list((Codec)Codec.STRING));
        property = this;
        PropertyResolver.register("material_property", (moduleInstance, oldMap) -> {
            Material material = MaterialProperty.getMaterial(moduleInstance);
            Map<Object, Object> returnMap = new HashMap(oldMap);
            if (material != null) {
                List<String> keys = this.getData(moduleInstance).orElse(new ArrayList());
                if (keys.isEmpty()) {
                    keys = List.of("default");
                }
                if (moduleInstance.module != null) {
                    ArrayList<String> newKeys = new ArrayList<String>();
                    newKeys.add(moduleInstance.module.id().toString());
                    newKeys.addAll(keys);
                    keys = newKeys;
                }
                for (String key : keys) {
                    Map<ModuleProperty<?>, Object> materialProperties = PropertyResolver.setSource(material.materialProperties(key), (Component)Component.translatable((String)"miapi.property.source.material", (Object[])new Object[]{material.getTranslation().getString()}).withStyle(ChatFormatting.DARK_GRAY));
                    if (materialProperties.isEmpty()) continue;
                    returnMap = PropertyResolver.merge(oldMap, materialProperties, MergeType.SMART);
                }
            }
            return returnMap;
        });
    }

    @Override
    public List<String> merge(List<String> left, List<String> right, MergeType mergeType) {
        return MergeAble.mergeList(left, right, mergeType);
    }
}

