/*
 * Decompiled with CFR 0.152.
 */
package smartin.miapi.material;

import com.mojang.serialization.Codec;
import com.redpxnda.nucleus.codec.auto.AutoCodec;
import com.redpxnda.nucleus.codec.behavior.CodecBehavior;
import java.util.LinkedHashMap;
import java.util.Map;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import smartin.miapi.Miapi;
import smartin.miapi.modules.ModuleInstance;
import smartin.miapi.modules.properties.LoreProperty;
import smartin.miapi.modules.properties.util.CodecProperty;
import smartin.miapi.modules.properties.util.MergeAble;
import smartin.miapi.modules.properties.util.MergeType;

public class MaterialStatIndicatorProperty
extends CodecProperty<Map<String, Context>> {
    public static Codec<Context> INNER_CODEC = Codec.withAlternative((Codec)AutoCodec.of(Context.class).codec(), (Codec)Codec.INT.xmap(i -> {
        Context context = new Context();
        context.strength = i;
        return context;
    }, c -> c.strength));
    public static Codec<Map<String, Context>> CODEC = Codec.unboundedMap((Codec)Codec.STRING, INNER_CODEC);
    public static ResourceLocation KEY = Miapi.id("material_indication");
    public static MaterialStatIndicatorProperty property;

    public MaterialStatIndicatorProperty() {
        super(CODEC);
        property = this;
    }

    @Override
    public Map<String, Context> initialize(Map<String, Context> map, ModuleInstance moduleInstance) {
        return this.initialize(map);
    }

    public Map<String, Context> initialize(Map<String, Context> map) {
        LinkedHashMap<String, Context> init = new LinkedHashMap<String, Context>();
        map.forEach((id, data) -> {
            Context initContext = new Context();
            initContext.strength = data.strength;
            initContext.info = data.info;
            if (data.info == null) {
                switch (id) {
                    case "durability": {
                        initContext.info = LoreProperty.format((Component)Component.translatable((String)"miapi.material_indication.default.durability"), ChatFormatting.DARK_GRAY);
                        break;
                    }
                    case "hardness": {
                        initContext.info = LoreProperty.format((Component)Component.translatable((String)"miapi.material_indication.default.hardness"), ChatFormatting.DARK_GRAY);
                        break;
                    }
                    case "mining_speed": {
                        initContext.info = LoreProperty.format((Component)Component.translatable((String)"miapi.material_indication.default.mining_speed"), ChatFormatting.DARK_GRAY);
                    }
                }
            }
            init.put((String)id, initContext);
        });
        return init;
    }

    @Override
    public Map<String, Context> merge(Map<String, Context> left, Map<String, Context> right, MergeType mergeType) {
        return MergeAble.mergeMap(left, right, mergeType);
    }

    public static class Context {
        public Integer strength = 0;
        @CodecBehavior.Optional
        public Component info = null;
    }
}

