/*
 * Decompiled with CFR 0.152.
 */
package smartin.miapi.material.base;

import java.util.List;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.util.FastColor;
import net.minecraft.world.item.ItemDisplayContext;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import smartin.miapi.material.palette.MaterialRenderController;
import smartin.miapi.modules.ModuleInstance;

public interface ColorController {
    @OnlyIn(value=Dist.CLIENT)
    default public boolean hasIcon() {
        return false;
    }

    @OnlyIn(value=Dist.CLIENT)
    public static int getColor(String color) {
        if (color.equals("")) {
            return FastColor.ARGB32.color((int)255, (int)255, (int)255, (int)255);
        }
        long longValue = Long.parseLong(color, 16);
        return (int)(longValue & 0xFFFFFFFFL);
    }

    @OnlyIn(value=Dist.CLIENT)
    default public int getColor(ModuleInstance context) {
        return this.getColor(context, ItemDisplayContext.GUI);
    }

    @OnlyIn(value=Dist.CLIENT)
    default public int getColor(ModuleInstance context, ItemDisplayContext mode) {
        return this.getRenderController(context, mode).getAverageColor().argb();
    }

    public List<String> getTextureKeys();

    @OnlyIn(value=Dist.CLIENT)
    public MaterialRenderController getRenderController(ModuleInstance var1, ItemDisplayContext var2);

    @OnlyIn(value=Dist.CLIENT)
    default public int renderIcon(GuiGraphics drawContext, int x, int y) {
        return 0;
    }
}

