/*
 * Decompiled with CFR 0.152.
 */
package smartin.miapi.material.base;

import com.google.gson.JsonObject;
import com.mojang.serialization.MapCodec;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.Block;
import smartin.miapi.client.gui.crafting.crafter.replace.hover.HoverMaterialList;
import smartin.miapi.material.base.ColorController;
import smartin.miapi.material.base.IngredientController;
import smartin.miapi.material.base.PropertyController;
import smartin.miapi.material.base.StatController;
import smartin.miapi.modules.ModuleInstance;
import smartin.miapi.modules.properties.LoreProperty;

public interface Material
extends PropertyController,
ColorController,
StatController,
IngredientController {
    public static final ResourceLocation BASE_PALETTE_ID = ResourceLocation.fromNamespaceAndPath((String)"miapi", (String)"miapi_materials/base_palette");

    public ResourceLocation getID();

    default public String getStringID() {
        String id = this.getID().toString();
        id = id.replace(":", ".");
        id = id.replaceAll("/", ".");
        return id;
    }

    public List<String> getGroups();

    default public List<String> getGuiGroups() {
        return this.getGroups();
    }

    @Override
    default public Material getMaterial(ModuleInstance moduleInstance) {
        return this;
    }

    @Override
    default public Material getMaterialFromIngredient(ItemStack ingredient) {
        return this;
    }

    default public boolean canBeDyed() {
        return false;
    }

    public void addSmithingGroup();

    default public Component getTranslation() {
        return Component.translatable((String)("miapi.material." + this.getStringID()));
    }

    default public boolean generateConverters() {
        return false;
    }

    public JsonObject getDebugJson();

    public TagKey<Block> getIncorrectBlocksForDrops();

    default public Optional<MapCodec<? extends Material>> codec() {
        return Optional.empty();
    }

    default public List<Component> getDescription(boolean extended) {
        ArrayList<Component> lines = new ArrayList<Component>();
        if (extended) {
            lines.add(LoreProperty.gray((Component)Component.translatable((String)"miapi.ui.material_desc_alt_2")));
            for (int i = 1; i < this.getGuiGroups().size(); ++i) {
                String groupId = this.getGuiGroups().get(i);
                lines.add(LoreProperty.gray((Component)Component.literal((String)(" - " + HoverMaterialList.getTranslation(groupId).getString()))));
            }
        }
        return lines;
    }
}

