/*
 * Decompiled with CFR 0.152.
 */
package smartin.miapi.material.composite;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import smartin.miapi.Environment;
import smartin.miapi.Miapi;
import smartin.miapi.datapack.ReloadEvents;
import smartin.miapi.material.DefaultMaterial;
import smartin.miapi.material.DelegatingMaterial;
import smartin.miapi.material.MaterialProperty;
import smartin.miapi.material.base.Material;
import smartin.miapi.material.composite.AnyIngredientComposite;
import smartin.miapi.material.composite.ColorComposite;
import smartin.miapi.material.composite.Composite;
import smartin.miapi.material.composite.DyeableComposite;
import smartin.miapi.material.composite.NameComposite;
import smartin.miapi.material.composite.PaletteComposite;
import smartin.miapi.material.composite.group.GroupComposite;
import smartin.miapi.material.composite.group.GuiGroupComposite;
import smartin.miapi.material.composite.group.HiddenGroupComposite;
import smartin.miapi.material.composite.material.CompositeFromOtherMaterial;
import smartin.miapi.material.composite.material.DatapackComposite;
import smartin.miapi.material.composite.material.MaterialCopyComposite;
import smartin.miapi.material.composite.material.MaterialCopyPaletteComposite;
import smartin.miapi.material.composite.material.MaterialLayerPaletteComposite;
import smartin.miapi.material.composite.material.MaterialMergeStatComposite;
import smartin.miapi.material.composite.material.MaterialPropertyMergeComposite;
import smartin.miapi.material.composite.stat.IncreaseStatsComposite;
import smartin.miapi.material.composite.stat.PercentStatComposite;
import smartin.miapi.material.composite.stat.SetStatComposite;
import smartin.miapi.modules.ModuleInstance;

public class CompositeMaterial
extends DelegatingMaterial {
    public static ResourceLocation KEY = Miapi.id("composite_material");
    public List<Composite> compositeList;
    public double cost = 1.0;
    public static MapCodec<CompositeMaterial> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)Composite.CODEC.listOf().optionalFieldOf("composites", List.of()).forGetter(material -> material.compositeList)).apply((Applicative)instance, CompositeMaterial::getFromComposites));
    public static DataComponentType<CompositeMaterial> COMPOSITE_MATERIAL_COMPONENT;

    protected CompositeMaterial(Material buildMaterial, List<Composite> composites) {
        super(buildMaterial);
        this.compositeList = composites;
    }

    @Override
    public double getValueOfItem(ItemStack ingredient) {
        if (ingredient.has(COMPOSITE_MATERIAL_COMPONENT)) {
            return 1.0;
        }
        return 0.0;
    }

    public static CompositeMaterial getFromComposites(List<Composite> composites) {
        Material buildMaterial = new DefaultMaterial();
        for (Composite composite : composites) {
            buildMaterial = composite.composite(buildMaterial, Environment.isClient());
        }
        return new CompositeMaterial(buildMaterial, composites);
    }

    @Override
    public Material getMaterialFromIngredient(ItemStack ingredient) {
        return (Material)ingredient.getOrDefault(COMPOSITE_MATERIAL_COMPONENT, null);
    }

    @Override
    public Material getMaterial(ModuleInstance moduleInstance) {
        return this;
    }

    @Override
    public Double getPriorityOfIngredientItem(ItemStack ingredient) {
        CompositeMaterial material = (CompositeMaterial)ingredient.get(COMPOSITE_MATERIAL_COMPONENT);
        if (material != null) {
            return 100.0;
        }
        return null;
    }

    @Override
    public ResourceLocation getID() {
        return KEY;
    }

    @Override
    public Optional<MapCodec<? extends Material>> codec() {
        return Optional.of(CODEC);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null) return false;
        if (this.getClass() != o.getClass()) {
            return false;
        }
        CompositeMaterial that = (CompositeMaterial)o;
        if (Double.compare(that.cost, this.cost) != 0) return false;
        if (!Objects.equals(this.compositeList, that.compositeList)) return false;
        if (!Objects.equals(KEY, KEY)) return false;
        return true;
    }

    @Override
    public int hashCode() {
        return Objects.hash(KEY, this.compositeList, this.cost);
    }

    static {
        ReloadEvents.MAIN.subscribe((isClient, registryAccess) -> MaterialProperty.MATERIAL_REGISTRY.register(KEY, (Material)new CompositeMaterial(new DefaultMaterial(), List.of())), -1.0f);
        CompositeFromOtherMaterial.register(MaterialCopyComposite.ID, MaterialCopyComposite.MAP_CODEC);
        CompositeFromOtherMaterial.register(MaterialCopyPaletteComposite.ID, MaterialCopyComposite.MAP_CODEC);
        CompositeFromOtherMaterial.register(MaterialLayerPaletteComposite.ID, MaterialLayerPaletteComposite.MAP_CODEC);
        CompositeFromOtherMaterial.register(MaterialMergeStatComposite.ID, MaterialMergeStatComposite.MAP_CODEC);
        CompositeFromOtherMaterial.register(MaterialPropertyMergeComposite.ID, MaterialPropertyMergeComposite.MAP_CODEC);
        CompositeFromOtherMaterial.register(DatapackComposite.ID, DatapackComposite.MAP_CODEC);
        Composite.COMPOSITE_REGISTRY.put(AnyIngredientComposite.ID, AnyIngredientComposite.MAP_CODEC);
        Composite.COMPOSITE_REGISTRY.put(ColorComposite.ID, ColorComposite.MAP_CODEC);
        Composite.COMPOSITE_REGISTRY.put(NameComposite.ID, NameComposite.MAP_CODEC);
        Composite.COMPOSITE_REGISTRY.put(PaletteComposite.ID, PaletteComposite.MAP_CODEC);
        Composite.COMPOSITE_REGISTRY.put(DyeableComposite.ID, DyeableComposite.MAP_CODEC);
        Composite.COMPOSITE_REGISTRY.put(GroupComposite.ID, GroupComposite.MAP_CODEC);
        Composite.COMPOSITE_REGISTRY.put(GuiGroupComposite.ID, GuiGroupComposite.MAP_CODEC);
        Composite.COMPOSITE_REGISTRY.put(HiddenGroupComposite.ID, HiddenGroupComposite.MAP_CODEC);
        Composite.COMPOSITE_REGISTRY.put(IncreaseStatsComposite.ID, IncreaseStatsComposite.MAP_CODEC);
        Composite.COMPOSITE_REGISTRY.put(PercentStatComposite.ID, PercentStatComposite.MAP_CODEC);
        Composite.COMPOSITE_REGISTRY.put(SetStatComposite.ID, SetStatComposite.MAP_CODEC);
        COMPOSITE_MATERIAL_COMPONENT = DataComponentType.builder().persistent(CODEC.codec()).networkSynchronized(ByteBufCodecs.fromCodec((Codec)CODEC.codec())).build();
    }
}

