/*
 * Decompiled with CFR 0.152.
 */
package smartin.miapi.material.generated;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.redpxnda.nucleus.util.Color;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.util.FastColor;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TieredItem;
import net.minecraft.world.level.block.Block;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import org.jetbrains.annotations.Nullable;
import smartin.miapi.Environment;
import smartin.miapi.Miapi;
import smartin.miapi.events.MiapiEvents;
import smartin.miapi.material.MaterialIcons;
import smartin.miapi.material.MaterialProperty;
import smartin.miapi.material.base.Material;
import smartin.miapi.material.palette.FallbackColorer;
import smartin.miapi.material.palette.GrayscalePaletteColorer;
import smartin.miapi.material.palette.MaterialRenderController;
import smartin.miapi.modules.ModuleInstance;
import smartin.miapi.modules.properties.util.ModuleProperty;

public class GeneratedMaterialFromCopy
implements Material {
    ItemStack mainIngredient;
    ResourceLocation key;
    List<String> groups = new ArrayList<String>();
    List<String> textureKeys;
    Map<String, Double> stats = new HashMap<String, Double>();
    TagKey<Block> incorrectForTool;
    GrayscalePaletteColorer palette;
    @Nullable
    MaterialIcons.MaterialIcon icon;
    Material source;
    public static Codec<GeneratedMaterialFromCopy> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)ItemStack.CODEC.fieldOf("ingredient").forGetter(m -> m.mainIngredient), (App)ResourceLocation.CODEC.fieldOf("material").forGetter(m -> m.source.getID())).apply((Applicative)instance, (itemstack, material) -> new GeneratedMaterialFromCopy((ItemStack)itemstack, MaterialProperty.MATERIAL_REGISTRY.get((ResourceLocation)material))));

    public GeneratedMaterialFromCopy(ItemStack mainIngredient, Material other) {
        String[] names = other.getID().toString().split(":")[1].split("/");
        this.key = names.length > 1 ? Miapi.id("generated_" + names[names.length - 2] + "/" + mainIngredient.getDescriptionId()) : Miapi.id("generated_simple/" + mainIngredient.getDescriptionId());
        this.source = other;
        this.mainIngredient = mainIngredient;
        this.groups.add(this.key.toString());
        this.groups.addAll(other.getGroups());
        this.textureKeys = List.of("default");
        this.stats.put("hardness", other.getDouble("hardness"));
        this.stats.put("density", other.getDouble("density"));
        this.stats.put("flexibility", other.getDouble("flexibility"));
        this.stats.put("durability", other.getDouble("durability"));
        this.stats.put("mining_speed", other.getDouble("mining_speed"));
        this.stats.put("axe_damage", other.getDouble("axe_damage"));
        this.stats.put("enchantability", other.getDouble("enchantability"));
        this.stats.put("armor_durability_offset", other.getDouble("armor_durability_offset"));
        this.incorrectForTool = other.getIncorrectBlocksForDrops();
        if (Environment.isClient()) {
            this.setupClient();
        }
        ((MiapiEvents.CreateMaterialModularConvertersEvent)MiapiEvents.GENERATE_MATERIAL_CONVERTERS.invoker()).generated(this, new ArrayList<TieredItem>(), new ArrayList<ArmorItem>(), Environment.isClient());
    }

    @Override
    public Component getTranslation() {
        Component name = this.mainIngredient.getHoverName();
        return name == null ? Component.literal((String)"Missing Name!") : name;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void setupClient() {
        this.palette = GrayscalePaletteColorer.createForGeneratedMaterial(this, this.mainIngredient);
        this.icon = new MaterialIcons.ItemMaterialIcon(this.mainIngredient, 18, null);
    }

    @Override
    public boolean hasIcon() {
        return true;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public int renderIcon(GuiGraphics drawContext, int x, int y) {
        if (this.icon == null) {
            return 0;
        }
        return this.icon.render(drawContext, x, y);
    }

    @Override
    public void addSmithingGroup() {
        if (!this.groups.contains("smithing")) {
            this.groups = new ArrayList<String>(this.groups);
            this.groups.add("smithing");
        }
    }

    @Override
    public ResourceLocation getID() {
        return this.key;
    }

    @Override
    public List<String> getGroups() {
        return this.groups;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public MaterialRenderController getRenderController(ModuleInstance context, ItemDisplayContext mode) {
        if (this.palette == null) {
            return new FallbackColorer(this);
        }
        return this.palette;
    }

    @Override
    public Map<ModuleProperty<?>, Object> materialProperties(String key) {
        return this.source.materialProperties(key);
    }

    @Override
    public List<String> getAllPropertyKeys() {
        return this.source.getAllPropertyKeys();
    }

    @Override
    public double getDouble(String property) {
        if (this.stats.containsKey(property)) {
            return this.stats.get(property);
        }
        return 0.0;
    }

    @Override
    public String getData(String property) {
        return this.source.getData(property);
    }

    @Override
    public List<String> getTextureKeys() {
        return List.of("default");
    }

    @Override
    public double getValueOfItem(ItemStack itemStack) {
        if (itemStack.getItem().equals(this.mainIngredient.getItem())) {
            return 1.0;
        }
        return 0.0;
    }

    @Override
    @Nullable
    public Double getPriorityOfIngredientItem(ItemStack itemStack) {
        if (itemStack.getItem().equals(this.mainIngredient.getItem())) {
            return -1.0;
        }
        return null;
    }

    @Override
    public TagKey<Block> getIncorrectBlocksForDrops() {
        return this.incorrectForTool;
    }

    @Override
    public JsonObject getDebugJson() {
        JsonObject object = new JsonObject();
        object.add("key", (JsonElement)new JsonPrimitive(this.getID().toString()));
        JsonArray jsonElements = new JsonArray();
        this.getTextureKeys().forEach(arg_0 -> ((JsonArray)jsonElements).add(arg_0));
        object.add("groups", (JsonElement)jsonElements);
        this.stats.forEach((arg_0, arg_1) -> ((JsonObject)object).addProperty(arg_0, arg_1));
        if (Environment.isClient()) {
            object.addProperty("fake_translation", this.getTranslation().getString());
            ResourceLocation itemId = BuiltInRegistries.ITEM.getKey((Object)this.mainIngredient.getItem());
            String iconBuilder = "{\"type\": \"item\",\"item\": \"" + String.valueOf(itemId) + "\"}";
            object.add("icon", (JsonElement)Miapi.gson.fromJson(iconBuilder, JsonObject.class));
        }
        if (this.palette != null) {
            StringBuilder paletteBuilder = new StringBuilder();
            paletteBuilder.append("{");
            paletteBuilder.append("\"type\": \"").append("grayscale_map").append("\",");
            paletteBuilder.append("\"colors\": ");
            JsonObject innerPalette = new JsonObject();
            for (int i = 0; i < this.palette.getColors().length; ++i) {
                int abgr = this.palette.getColors()[i];
                innerPalette.addProperty(String.valueOf(i), new Color(FastColor.ABGR32.red((int)abgr), FastColor.ABGR32.green((int)abgr), FastColor.ABGR32.blue((int)abgr), FastColor.ABGR32.alpha((int)abgr)).hex());
            }
            paletteBuilder.append(Miapi.gson.toJson((JsonElement)innerPalette));
            paletteBuilder.append("}");
            object.add("palette", (JsonElement)Miapi.gson.fromJson(paletteBuilder.toString(), JsonObject.class));
        }
        JsonArray ingredients = new JsonArray();
        JsonObject mainIngredientJson = new JsonObject();
        mainIngredientJson.add("item", (JsonElement)new JsonPrimitive(BuiltInRegistries.ITEM.getKey((Object)this.mainIngredient.getItem()).toString()));
        mainIngredientJson.add("value", (JsonElement)new JsonPrimitive((Number)1.0));
        JsonObject otherIngredient = new JsonObject();
        otherIngredient.add("value", (JsonElement)new JsonPrimitive((Number)1.0));
        ingredients.add((JsonElement)mainIngredientJson);
        ingredients.add((JsonElement)otherIngredient);
        object.add("items", (JsonElement)ingredients);
        return object;
    }

    public int hashCode() {
        return this.getID().hashCode();
    }
}

