/*
 * Decompiled with CFR 0.152.
 */
package smartin.miapi.material.generated;

import com.mojang.serialization.Codec;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import net.minecraft.core.Registry;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.ItemTags;
import net.minecraft.world.item.AxeItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.SwordItem;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.TieredItem;
import net.minecraft.world.item.crafting.Ingredient;
import smartin.miapi.Environment;
import smartin.miapi.Miapi;
import smartin.miapi.config.MiapiConfig;
import smartin.miapi.datapack.ReloadEvents;
import smartin.miapi.events.MiapiEvents;
import smartin.miapi.material.MaterialProperty;
import smartin.miapi.material.base.Material;
import smartin.miapi.material.generated.GeneratedMaterial;
import smartin.miapi.material.generated.GeneratedMaterialFromCopy;
import smartin.miapi.material.generated.SmithingRecipeUtil;
import smartin.miapi.registries.RegistryInventory;

public class GeneratedMaterialManager {
    public static final List<GeneratedMaterial> generatedMaterials = new ArrayList<GeneratedMaterial>();
    public static final List<GeneratedMaterialFromCopy> basicGeneratedMaterials = new ArrayList<GeneratedMaterialFromCopy>();

    public static void setup() {
        ReloadEvents.MAIN.subscribe((isClient, registryAccess) -> {
            if (!isClient) {
                GeneratedMaterialManager.onReloadServer(registryAccess);
            } else {
                basicGeneratedMaterials.forEach(generatedMaterial -> MaterialProperty.MATERIAL_REGISTRY.register(generatedMaterial.getID(), (Material)generatedMaterial));
                SmithingRecipeUtil.setupSmithingRecipe(generatedMaterials, true, material -> MaterialProperty.MATERIAL_REGISTRY.register(material.getID(), (Material)material), registryAccess, null);
            }
        }, -1.0f);
        ReloadEvents.dataSyncerRegistry.register(Miapi.id("generated_materials"), (ReloadEvents.DataSyncer)new ReloadEvents.SimpleSyncer<List<GeneratedMaterial>>(ByteBufCodecs.fromCodec((Codec)Codec.list(GeneratedMaterial.CODEC))){

            @Override
            public List<GeneratedMaterial> getDataServer() {
                return generatedMaterials;
            }

            @Override
            public void interpretData(List<GeneratedMaterial> data) {
                if (GeneratedMaterialManager.verboseLogging()) {
                    Miapi.LOGGER.info("Client received " + data.size() + " complex materials");
                }
                for (GeneratedMaterial material : data) {
                    material.setupClient();
                    if (!GeneratedMaterialManager.verboseLogging()) continue;
                    Miapi.LOGGER.info("complex " + material.getTranslation().getString());
                }
                generatedMaterials.clear();
                generatedMaterials.addAll(data);
            }
        });
        ReloadEvents.dataSyncerRegistry.register(Miapi.id("generated_simple_materials"), (ReloadEvents.DataSyncer)new ReloadEvents.SimpleSyncer<List<GeneratedMaterialFromCopy>>(ByteBufCodecs.fromCodec((Codec)Codec.list(GeneratedMaterialFromCopy.CODEC))){

            @Override
            public List<GeneratedMaterialFromCopy> getDataServer() {
                return basicGeneratedMaterials;
            }

            @Override
            public void interpretData(List<GeneratedMaterialFromCopy> data) {
                if (GeneratedMaterialManager.verboseLogging()) {
                    Miapi.LOGGER.info("Client received " + data.size() + " wood/stone materials");
                }
                for (GeneratedMaterialFromCopy copy : data) {
                    copy.setupClient();
                    if (!GeneratedMaterialManager.verboseLogging()) continue;
                    Miapi.LOGGER.info("wood/stone " + copy.getTranslation().getString());
                }
                basicGeneratedMaterials.clear();
                basicGeneratedMaterials.addAll(data);
            }
        });
    }

    public static Registry<Item> getRegistry() {
        if (Miapi.registryAccess == null) {
            return BuiltInRegistries.ITEM;
        }
        return (Registry)Miapi.registryAccess.registry(Registries.ITEM).get();
    }

    public static void onReloadServer(RegistryAccess access) {
        try {
            if (GeneratedMaterialManager.verboseLogging()) {
                Miapi.LOGGER.info("MIAPI STARTED MATERIAL GENERATION");
            }
            generatedMaterials.clear();
            basicGeneratedMaterials.clear();
            if (!MiapiConfig.getServerConfig().generatedMaterials.generateMaterials) {
                return;
            }
            Registry<Item> registiry = GeneratedMaterialManager.getRegistry();
            ArrayList<TieredItem> toolItems = new ArrayList<TieredItem>(registiry.stream().filter(TieredItem.class::isInstance).map(TieredItem.class::cast).filter(toolMaterial -> toolMaterial.getTier().getRepairIngredient() != null && toolMaterial.getTier().getRepairIngredient().getItems() != null && toolMaterial.getTier().getRepairIngredient().getItems().length > 0).filter(toolMaterial -> !toolMaterial.getTier().getRepairIngredient().getItems()[0].is(RegistryInventory.MIAPI_FORBIDDEN_TAG)).filter(toolMaterial -> Arrays.stream(toolMaterial.getTier().getRepairIngredient().getItems()).allMatch(itemStack -> MaterialProperty.getMaterialFromIngredient(itemStack) == null && !itemStack.getItem().equals(Items.BARRIER))).toList());
            HashMap<Tier, List> tieredItem = new HashMap<Tier, List>();
            toolItems.forEach(item -> tieredItem.computeIfAbsent(item.getTier(), i -> new ArrayList()).add(item));
            HashMap<Tier, List> insufficientItems = new HashMap<Tier, List>();
            tieredItem.forEach((t, items) -> {
                boolean hasSword = items.stream().anyMatch(SwordItem.class::isInstance);
                boolean hasAxe = items.stream().anyMatch(AxeItem.class::isInstance);
                if (!hasSword || !hasAxe) {
                    insufficientItems.put((Tier)t, (List)items);
                }
            });
            insufficientItems.forEach((t, items) -> tieredItem.remove(t));
            if (MiapiConfig.getServerConfig().generatedMaterials.generateOtherMaterials) {
                toolItems.stream().filter(GeneratedMaterialManager::isValidItem).map(TieredItem::getTier).collect(Collectors.toSet()).stream().limit(MiapiConfig.getServerConfig().generatedMaterials.maximumGeneratedMaterials).collect(Collectors.toSet()).forEach(toolMaterial -> {
                    try {
                        ItemStack mainIngredient = toolMaterial.getRepairIngredient().getItems()[0];
                        if (GeneratedMaterialManager.verboseLogging()) {
                            Miapi.LOGGER.info("attempting material generation for " + mainIngredient.getHoverName().getString());
                        }
                        if (GeneratedMaterialManager.isValidItem(mainIngredient.getItem())) {
                            List<TieredItem> tieredItems = toolItems.stream().filter(item -> toolMaterial.equals((Object)item.getTier())).toList();
                            GeneratedMaterial generatedMaterial = new GeneratedMaterial(mainIngredient, toolMaterial.getRepairIngredient(), (Tier)toolMaterial, tieredItems);
                            if (generatedMaterial.isValid()) {
                                if (GeneratedMaterialManager.verboseLogging()) {
                                    Miapi.LOGGER.info("Generated Material " + String.valueOf(generatedMaterial.getID()));
                                }
                                generatedMaterials.add(generatedMaterial);
                            }
                        }
                    }
                    catch (RuntimeException e) {
                        Miapi.LOGGER.error("could not generate Material for " + String.valueOf(toolMaterial.getRepairIngredient().getItems()[0]), (Throwable)e);
                    }
                });
            }
            if (MiapiConfig.getServerConfig().generatedMaterials.generateWoodMaterials) {
                BuiltInRegistries.ITEM.stream().filter(item -> item.getDefaultInstance().is(ItemTags.PLANKS) && !item.getDefaultInstance().is(RegistryInventory.MIAPI_FORBIDDEN_TAG)).limit(MiapiConfig.getServerConfig().generatedMaterials.maximumGeneratedMaterials).forEach(item -> {
                    try {
                        if (GeneratedMaterialManager.isValidItem(item)) {
                            Material old = MaterialProperty.getMaterialFromIngredient(item.getDefaultInstance());
                            Material baseWood = MaterialProperty.MATERIAL_REGISTRY.get(Miapi.id("wood/wood"));
                            if (old != null && baseWood != null && old == baseWood) {
                                GeneratedMaterialFromCopy generatedMaterial = new GeneratedMaterialFromCopy(item.getDefaultInstance(), old);
                                basicGeneratedMaterials.add(generatedMaterial);
                                if (GeneratedMaterialManager.verboseLogging()) {
                                    Miapi.LOGGER.info("Generated Wood Material " + String.valueOf(generatedMaterial.getID()));
                                }
                            }
                        }
                    }
                    catch (Exception e) {
                        Miapi.LOGGER.error("could not generate wood Material for " + item.getDescriptionId(), (Throwable)e);
                    }
                });
            }
            if (MiapiConfig.getServerConfig().generatedMaterials.generateStoneMaterials) {
                BuiltInRegistries.ITEM.stream().filter(item -> item.getDefaultInstance().is(ItemTags.STONE_TOOL_MATERIALS) && !item.getDefaultInstance().is(RegistryInventory.MIAPI_FORBIDDEN_TAG)).limit(MiapiConfig.getServerConfig().generatedMaterials.maximumGeneratedMaterials).forEach(item -> {
                    try {
                        if (GeneratedMaterialManager.isValidItem(item) && !item.equals(Items.COBBLESTONE)) {
                            Material old = MaterialProperty.getMaterialFromIngredient(item.getDefaultInstance());
                            Material baseStone = MaterialProperty.MATERIAL_REGISTRY.get(Miapi.id("stone/stone"));
                            if (old != null && baseStone != null && old == baseStone) {
                                GeneratedMaterialFromCopy generatedMaterial = new GeneratedMaterialFromCopy(item.getDefaultInstance(), old);
                                basicGeneratedMaterials.add(generatedMaterial);
                                if (GeneratedMaterialManager.verboseLogging()) {
                                    Miapi.LOGGER.info("Generated Stone Material " + String.valueOf(generatedMaterial.getID()));
                                }
                            }
                        }
                    }
                    catch (Exception e) {
                        Miapi.LOGGER.error("could not generate stone Material for " + item.getDescriptionId(), (Throwable)e);
                    }
                });
            }
            SmithingRecipeUtil.setupSmithingRecipe(generatedMaterials, false, material -> {
                MaterialProperty.MATERIAL_REGISTRY.register(material.getID(), (Material)material);
                ((MiapiEvents.CreateMaterialModularConvertersEvent)MiapiEvents.GENERATE_MATERIAL_CONVERTERS.invoker()).generated((Material)material, material.toolItems, material.armorItems, Environment.isClient());
            }, access, null);
            if (GeneratedMaterialManager.verboseLogging()) {
                Miapi.LOGGER.info("MIAPI FINISHED MATERIAL GENERATION");
            }
        }
        catch (Exception e) {
            Miapi.LOGGER.error("MAJOR ISSUE DURING MATERIAL CREATION", (Throwable)e);
        }
    }

    public static boolean isSameTier(Tier first, Tier second) {
        if (first.equals((Object)second)) {
            return true;
        }
        try {
            if (!first.getIncorrectBlocksForDrops().equals((Object)second.getIncorrectBlocksForDrops())) {
                return false;
            }
        }
        catch (RuntimeException runtimeException) {
            return false;
        }
        try {
            if (!GeneratedMaterialManager.isSameIngredient(first.getRepairIngredient(), second.getRepairIngredient())) {
                return false;
            }
        }
        catch (RuntimeException runtimeException) {
            return false;
        }
        return true;
    }

    public static Tier selectBetterTier(Tier first, Tier second) {
        if (first.getAttackDamageBonus() == second.getAttackDamageBonus()) {
            return first.getSpeed() > second.getSpeed() ? first : second;
        }
        if (first.getAttackDamageBonus() > second.getAttackDamageBonus()) {
            return first;
        }
        return second;
    }

    public static boolean isSameIngredient(Ingredient first, Ingredient second) {
        Set secondItems = Arrays.stream(second.getItems()).collect(Collectors.toSet());
        Set firstItems = Arrays.stream(first.getItems()).collect(Collectors.toSet());
        if (secondItems.size() == firstItems.size()) {
            return firstItems.containsAll(secondItems);
        }
        return false;
    }

    public static boolean isValidItem(Item item) {
        ResourceLocation identifier = BuiltInRegistries.ITEM.getKey((Object)item);
        Pattern pattern = Pattern.compile(MiapiConfig.getServerConfig().generatedMaterials.blockRegex);
        return !pattern.matcher(identifier.toString()).find() && !item.builtInRegistryHolder().is(RegistryInventory.MIAPI_FORBIDDEN_TAG);
    }

    public static boolean verboseLogging() {
        return MiapiConfig.getServerConfig().other.verboseLogging;
    }
}

