/*
 * Decompiled with CFR 0.152.
 */
package smartin.miapi.material.generated;

import com.google.gson.JsonElement;
import com.mojang.datafixers.util.Either;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.component.TypedDataComponent;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.DiggerItem;
import net.minecraft.world.item.HoeItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.PickaxeItem;
import net.minecraft.world.item.ShovelItem;
import net.minecraft.world.item.SwordItem;
import net.minecraft.world.item.component.ItemAttributeModifiers;
import net.minecraft.world.item.enchantment.ItemEnchantments;
import net.minecraft.world.level.storage.loot.functions.LootItemFunctions;
import smartin.miapi.Miapi;
import smartin.miapi.config.MiapiConfig;
import smartin.miapi.config.MiapiServerConfig;
import smartin.miapi.material.generated.GeneratedMaterialManager;
import smartin.miapi.modules.abilities.CopyItemAbility;
import smartin.miapi.modules.abilities.util.AbilityMangerProperty;
import smartin.miapi.modules.properties.ComponentProperty;
import smartin.miapi.modules.properties.CopyItemLoreProperty;
import smartin.miapi.modules.properties.FakeItemTagProperty;
import smartin.miapi.modules.properties.attributes.AttributeProperty;
import smartin.miapi.modules.properties.enchanment.CraftingEnchantProperty;
import smartin.miapi.modules.properties.onHit.CopyItemOnHit;
import smartin.miapi.modules.properties.util.CodecProperty;
import smartin.miapi.modules.properties.util.DoubleOperationResolvable;
import smartin.miapi.modules.properties.util.ModuleProperty;

public class GeneratedMaterialPropertyManager {
    public static Map<String, Map<ModuleProperty<?>, Object>> setup(ResourceLocation id, SwordItem swordItem, DiggerItem axeItem, List<Item> toolMaterials, List<ArmorItem> armorItems, Map<String, Map<ModuleProperty<?>, Object>> old) {
        HashMap properties = new HashMap(old);
        GeneratedMaterialPropertyManager.setupProperties((Item)swordItem, id, "blade", Items.DIAMOND_SWORD, Items.WOODEN_SWORD, properties, null);
        GeneratedMaterialPropertyManager.setupProperties((Item)axeItem, id, "axe", Items.DIAMOND_AXE, Items.WOODEN_AXE, properties, null);
        GeneratedMaterialPropertyManager.setupProperties(toolMaterials.stream().filter(PickaxeItem.class::isInstance).findFirst(), id, "pickaxe", Items.DIAMOND_PICKAXE, Items.WOODEN_PICKAXE, properties, null);
        GeneratedMaterialPropertyManager.setupProperties(toolMaterials.stream().filter(ShovelItem.class::isInstance).findFirst(), id, "shovel", Items.DIAMOND_SHOVEL, Items.WOODEN_SHOVEL, properties, null);
        GeneratedMaterialPropertyManager.setupProperties(toolMaterials.stream().filter(HoeItem.class::isInstance).findFirst(), id, "hoe", Items.DIAMOND_HOE, Items.WOODEN_HOE, properties, null);
        GeneratedMaterialPropertyManager.setupProperties(armorItems.stream().filter(a -> GeneratedMaterialPropertyManager.isEquipment(a, EquipmentSlot.HEAD)).map(a -> a).findFirst(), id, "helmet", Items.DIAMOND_HELMET, Items.IRON_HELMET, properties, (Integer)5);
        GeneratedMaterialPropertyManager.setupProperties(armorItems.stream().filter(a -> GeneratedMaterialPropertyManager.isEquipment(a, EquipmentSlot.CHEST)).map(a -> a).findFirst(), id, "chest", Items.DIAMOND_CHESTPLATE, Items.IRON_CHESTPLATE, properties, (Integer)8);
        GeneratedMaterialPropertyManager.setupProperties(armorItems.stream().filter(a -> GeneratedMaterialPropertyManager.isEquipment(a, EquipmentSlot.LEGS)).map(a -> a).findFirst(), id, "pants", Items.DIAMOND_LEGGINGS, Items.IRON_LEGGINGS, properties, (Integer)7);
        GeneratedMaterialPropertyManager.setupProperties(armorItems.stream().filter(a -> GeneratedMaterialPropertyManager.isEquipment(a, EquipmentSlot.FEET)).map(a -> a).findFirst(), id, "boot", Items.DIAMOND_BOOTS, Items.IRON_BOOTS, properties, (Integer)4);
        return properties;
    }

    public static boolean isEquipment(ArmorItem item, EquipmentSlot slot) {
        if (item.getEquipmentSlot() == slot) {
            return true;
        }
        if (item.getType().getSlot() == slot) {
            return true;
        }
        if (slot == EquipmentSlot.HEAD) {
            return item.getType() == ArmorItem.Type.HELMET;
        }
        if (slot == EquipmentSlot.CHEST) {
            return item.getType() == ArmorItem.Type.CHESTPLATE;
        }
        if (slot == EquipmentSlot.LEGS) {
            return item.getType() == ArmorItem.Type.LEGGINGS;
        }
        if (slot == EquipmentSlot.FEET) {
            return item.getType() == ArmorItem.Type.BOOTS;
        }
        return false;
    }

    private static void setupProperties(Optional<Item> item, ResourceLocation id, String type, Item vanillaCompare, Item vanillaCompare2, Map<String, Map<ModuleProperty<?>, Object>> properties, Integer cost) {
        item.ifPresent(i -> GeneratedMaterialPropertyManager.setupProperties(i, id, type, vanillaCompare, vanillaCompare2, properties, cost));
    }

    private static void setupProperties(Item item, ResourceLocation id, String type, Item vanillaCompare, Item vanillaCompare2, Map<String, Map<ModuleProperty<?>, Object>> properties, Integer cost) {
        HashMap<CodecProperty, Object> propertyMap = new HashMap<CodecProperty, Object>();
        if (GeneratedMaterialPropertyManager.shouldApplyProperty(MiapiConfig.getServerConfig().generatedMaterials.properties.abilityProperty, id.toString())) {
            propertyMap.put(AbilityMangerProperty.property, Map.of(CopyItemAbility.ability, new CopyItemAbility.ItemContext(item)));
        }
        if (GeneratedMaterialPropertyManager.shouldApplyProperty(MiapiConfig.getServerConfig().generatedMaterials.properties.loreProperty, id.toString())) {
            propertyMap.put(CopyItemLoreProperty.property, List.of(BuiltInRegistries.ITEM.wrapAsHolder((Object)item)));
        }
        if (GeneratedMaterialPropertyManager.shouldApplyProperty(MiapiConfig.getServerConfig().generatedMaterials.properties.onHitProperty, id.toString())) {
            propertyMap.put(CopyItemOnHit.property, List.of(BuiltInRegistries.ITEM.wrapAsHolder((Object)item)));
        }
        if (GeneratedMaterialPropertyManager.shouldApplyProperty(MiapiConfig.getServerConfig().generatedMaterials.properties.tagProperty, id.toString())) {
            Set tagsCompare1 = vanillaCompare.builtInRegistryHolder().tags().collect(Collectors.toSet());
            Set tagsCompare2 = vanillaCompare2.builtInRegistryHolder().tags().collect(Collectors.toSet());
            Set commonTags = tagsCompare1.stream().filter(tagsCompare2::contains).collect(Collectors.toSet());
            Stream itemTags = item.builtInRegistryHolder().tags();
            List<String> uniqueTags = itemTags.filter(tag -> !commonTags.contains(tag)).map(tag -> tag.location().toString()).toList();
            propertyMap.put(FakeItemTagProperty.property, uniqueTags);
        }
        if (GeneratedMaterialPropertyManager.shouldApplyProperty(MiapiConfig.getServerConfig().generatedMaterials.properties.componentProperty, id.toString())) {
            Set componentTypes = vanillaCompare.components().stream().map(TypedDataComponent::type).collect(Collectors.toSet());
            Set commonComponents = vanillaCompare2.components().stream().map(TypedDataComponent::type).filter(componentTypes::contains).collect(Collectors.toSet());
            HashMap components = new HashMap();
            item.components().forEach(typedDataComponent -> {
                if (!commonComponents.contains(typedDataComponent.type())) {
                    ResourceLocation componentId = BuiltInRegistries.DATA_COMPONENT_TYPE.getKey((Object)typedDataComponent.type());
                    JsonElement element = GeneratedMaterialPropertyManager.encode(typedDataComponent);
                    components.put(componentId, element);
                }
            });
            propertyMap.put(ComponentProperty.property, components);
        }
        if (GeneratedMaterialPropertyManager.shouldApplyProperty(MiapiConfig.getServerConfig().generatedMaterials.properties.enchantProperty, id.toString())) {
            HashMap enchantments = new HashMap();
            ItemEnchantments itemEnchantments = (ItemEnchantments)GeneratedMaterialPropertyManager.getDefaultStack(item).getOrDefault(DataComponents.ENCHANTMENTS, (Object)ItemEnchantments.EMPTY);
            itemEnchantments.keySet().forEach(enchantment -> {
                DoubleOperationResolvable resolvable = new DoubleOperationResolvable(List.of(new DoubleOperationResolvable.Operation(itemEnchantments.getLevel(enchantment), AttributeModifier.Operation.ADD_VALUE)));
                enchantments.put(((ResourceKey)enchantment.unwrapKey().get()).location(), resolvable);
                if (GeneratedMaterialManager.verboseLogging()) {
                    Miapi.LOGGER.info("detected enchantemnt " + enchantment.getRegisteredName() + " on " + String.valueOf(id));
                }
            });
            propertyMap.put(CraftingEnchantProperty.property, enchantments);
        }
        if (GeneratedMaterialPropertyManager.shouldApplyProperty(MiapiConfig.getServerConfig().generatedMaterials.properties.attributeProperty, id.toString())) {
            List<Holder> firstAttributes = ((ItemAttributeModifiers)GeneratedMaterialPropertyManager.getDefaultStack(vanillaCompare).get(DataComponents.ATTRIBUTE_MODIFIERS)).modifiers().stream().map(ItemAttributeModifiers.Entry::attribute).toList();
            List<Holder> secondAttributes = ((ItemAttributeModifiers)GeneratedMaterialPropertyManager.getDefaultStack(vanillaCompare2).get(DataComponents.ATTRIBUTE_MODIFIERS)).modifiers().stream().map(ItemAttributeModifiers.Entry::attribute).toList();
            List<ItemAttributeModifiers.Entry> modifiers = ((ItemAttributeModifiers)GeneratedMaterialPropertyManager.getDefaultStack(item).get(DataComponents.ATTRIBUTE_MODIFIERS)).modifiers().stream().filter(a -> !firstAttributes.contains(a.attribute()) && !secondAttributes.contains(a.attribute())).filter(a -> a.modifier().operation() == AttributeModifier.Operation.ADD_VALUE).toList();
            if (modifiers.isEmpty()) {
                modifiers = item.getDefaultAttributeModifiers().modifiers().stream().filter(a -> !firstAttributes.contains(a.attribute()) && !secondAttributes.contains(a.attribute())).filter(a -> a.modifier().operation() == AttributeModifier.Operation.ADD_VALUE).toList();
            }
            HashMap attributes = new HashMap();
            modifiers.forEach(e -> {
                DoubleOperationResolvable resolvable = new DoubleOperationResolvable(List.of(new DoubleOperationResolvable.Operation(e.modifier().amount() + "/" + cost + " * [module.cost]")));
                attributes.computeIfAbsent(BuiltInRegistries.ATTRIBUTE.getKey((Object)((Attribute)e.attribute().value())), c -> new HashMap()).computeIfAbsent(AttributeModifier.Operation.ADD_VALUE, c -> new HashMap()).put(Either.left((Object)e.slot()), resolvable);
            });
            propertyMap.put(AttributeProperty.property, attributes);
        }
        properties.put(type, propertyMap);
    }

    public static boolean shouldApplyProperty(MiapiServerConfig.GeneratedMaterialsCategory.GeneratePropertyOption config, String idString) {
        if (!config.enable) {
            return false;
        }
        for (String regex : config.blocked) {
            if (!idString.matches(regex)) continue;
            return false;
        }
        return true;
    }

    public static ItemStack getDefaultStack(Item item) {
        ItemStack itemStack = item.getDefaultInstance();
        try {
            Class<?> itemStackHelperClass = Class.forName("org.betterx.wover.item.api.ItemStackHelper");
            Method method = itemStackHelperClass.getDeclaredMethod("callItemStackSetupIfPossible", ItemStack.class, HolderLookup.Provider.class);
            itemStack = (ItemStack)method.invoke(null, itemStack, Miapi.registryAccess);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return (ItemStack)LootItemFunctions.IDENTITY.apply(itemStack, null);
    }

    public static <T> JsonElement encode(TypedDataComponent<T> typedDataComponent) {
        DataComponentType componentType = typedDataComponent.type();
        Object data = typedDataComponent.value();
        return (JsonElement)componentType.codec().encodeStart((DynamicOps)JsonOps.INSTANCE, data).getOrThrow();
    }
}

