/*
 * Decompiled with CFR 0.152.
 */
package smartin.miapi.material.generated;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Consumer;
import net.minecraft.client.Minecraft;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.SwordItem;
import net.minecraft.world.item.TieredItem;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.item.crafting.SmithingTransformRecipe;
import smartin.miapi.Miapi;
import smartin.miapi.item.MaterialSmithingRecipe;
import smartin.miapi.material.MaterialProperty;
import smartin.miapi.material.base.Material;
import smartin.miapi.material.generated.GeneratedMaterial;
import smartin.miapi.material.generated.GeneratedMaterialManager;
import smartin.miapi.mixin.SmithingTransformRecipeAccessor;

public class SmithingRecipeUtil {
    public static RecipeManager manager = null;

    public static void setupSmithingRecipes(boolean isClient, RegistryAccess registryAccess, RecipeManager manager) {
        List<GeneratedMaterial> materials = MaterialProperty.MATERIAL_REGISTRY.getFlatMap().values().stream().filter(GeneratedMaterial.class::isInstance).map(m -> (GeneratedMaterial)m).toList();
        materials.forEach(m -> MaterialProperty.MATERIAL_REGISTRY.remove(m.key));
        SmithingRecipeUtil.setupSmithingRecipe(materials, isClient, m -> MaterialProperty.MATERIAL_REGISTRY.register(m.key, (Material)m), registryAccess, null);
    }

    public static void setupSmithingRecipe(List<GeneratedMaterial> materials, boolean isClient, Consumer<GeneratedMaterial> register, RegistryAccess registryAccess, RecipeManager recipeManager) {
        try {
            if (recipeManager == null) {
                recipeManager = SmithingRecipeUtil.findManager(isClient);
            }
            if (registryAccess == null || recipeManager == null) {
                Miapi.LOGGER.warn("Could not setup Smithing Materials, could not find Recipes");
                materials.forEach(register);
                return;
            }
            ArrayList<GeneratedMaterial> todo = new ArrayList<GeneratedMaterial>(materials);
            ArrayList done = new ArrayList();
            AtomicBoolean hasMadeProgress = new AtomicBoolean(false);
            do {
                hasMadeProgress.set(false);
                ArrayList<GeneratedMaterial> currentTodo = new ArrayList<GeneratedMaterial>(todo);
                for (GeneratedMaterial material : currentTodo) {
                    if (GeneratedMaterialManager.verboseLogging()) {
                        Miapi.LOGGER.info("testing material " + material.getStringID());
                    }
                    SmithingRecipeUtil.testForSmithingMaterial(recipeManager, registryAccess, material, smithing -> {
                        if (GeneratedMaterialManager.verboseLogging()) {
                            Miapi.LOGGER.info("registered smithing material " + smithing.getStringID());
                        }
                        todo.remove(smithing);
                        done.add(smithing);
                        register.accept((GeneratedMaterial)smithing);
                        hasMadeProgress.set(true);
                    }, normal -> {
                        if (GeneratedMaterialManager.verboseLogging()) {
                            Miapi.LOGGER.info("registered normal generated material " + normal.getStringID());
                        }
                        todo.remove(normal);
                        register.accept((GeneratedMaterial)normal);
                        hasMadeProgress.set(true);
                    });
                }
            } while (hasMadeProgress.get());
            todo.forEach(register);
        }
        catch (RuntimeException e) {
            Miapi.LOGGER.error("Exception during SmithingRecipe setup!", (Throwable)e);
        }
    }

    public static boolean testForSmithingMaterial(RecipeManager manager, RegistryAccess registryManager, GeneratedMaterial material, Consumer<GeneratedMaterial> smithingMaterial, Consumer<GeneratedMaterial> normal) {
        try {
            Optional<SmithingTransformRecipe> optionalRecipe = manager.getAllRecipesFor(RecipeType.SMITHING).stream().map(RecipeHolder::value).filter(SmithingTransformRecipe.class::isInstance).map(SmithingTransformRecipe.class::cast).filter(recipe -> SmithingRecipeUtil.isValidRecipe(recipe, material.getSwordItem(), registryManager)).findAny();
            if (optionalRecipe.isEmpty()) {
                normal.accept(material);
            }
            optionalRecipe.ifPresent(smithingTransformRecipe -> {
                ItemStack templateItem = Arrays.stream(((SmithingTransformRecipeAccessor)smithingTransformRecipe).getTemplate().getItems()).filter(itemStack -> !itemStack.isEmpty()).findAny().orElse(ItemStack.EMPTY);
                if (templateItem.isEmpty()) {
                    normal.accept(material);
                    return;
                }
                Optional<Material> optional = Arrays.stream(((SmithingTransformRecipeAccessor)smithingTransformRecipe).getBase().getItems()).filter(itemStack -> {
                    Item patt0$temp = itemStack.getItem();
                    if (patt0$temp instanceof TieredItem) {
                        TieredItem toolItem = (TieredItem)patt0$temp;
                        Material parentMaterial = MaterialProperty.getMaterialFromIngredient(toolItem.getTier().getRepairIngredient().getItems()[0]);
                        return parentMaterial != null;
                    }
                    return false;
                }).map(itemStack -> MaterialProperty.getMaterialFromIngredient(((TieredItem)itemStack.getItem()).getTier().getRepairIngredient().getItems()[0])).findAny();
                optional.ifPresent(sourceMaterial -> {
                    smithingMaterial.accept(material);
                    SmithingRecipeUtil.addSmithingRecipe(sourceMaterial, material, templateItem, smithingTransformRecipe, registryManager, manager);
                });
            });
        }
        catch (RuntimeException e) {
            Miapi.LOGGER.error("Error during Smithing recipe generation!", (Throwable)e);
        }
        return false;
    }

    static boolean isValidRecipe(SmithingTransformRecipe recipe, SwordItem swordItem, RegistryAccess manager) {
        if (recipe.getResultItem((HolderLookup.Provider)manager).getItem().equals(swordItem)) {
            return true;
        }
        return ((SmithingTransformRecipeAccessor)recipe).getResult().getItem().equals(swordItem);
    }

    public static RecipeManager findManager(boolean isClient) {
        if (isClient) {
            RecipeManager manager;
            if (Minecraft.getInstance().getConnection() != null && (manager = Minecraft.getInstance().getConnection().getRecipeManager()) != null) {
                return manager;
            }
            if (Miapi.server != null) {
                return Miapi.server.getRecipeManager();
            }
        } else {
            if (manager != null) {
                return manager;
            }
            if (Miapi.server != null) {
                return Miapi.server.getRecipeManager();
            }
        }
        return manager;
    }

    public static void addSmithingRecipe(Material sourceMaterial, GeneratedMaterial outputMaterial, ItemStack templateItem, SmithingTransformRecipe smithingTransformRecipe, RegistryAccess registryAccess, RecipeManager recipeManager) {
        ArrayList<RecipeHolder> recipes = recipeManager.getRecipes();
        Object id = "generated_material_recipe." + String.valueOf(outputMaterial.getID()) + "." + String.valueOf(sourceMaterial.getID()) + "." + String.valueOf(BuiltInRegistries.ITEM.getKey((Object)templateItem.getItem()));
        ResourceLocation recipeId = Miapi.id((String)(id = ((String)id).replace(":", ".")));
        if (recipeManager.byKey(recipeId).isEmpty()) {
            Ingredient template = ((SmithingTransformRecipeAccessor)smithingTransformRecipe).getTemplate();
            MaterialSmithingRecipe materialSmithingRecipe = new MaterialSmithingRecipe(template, sourceMaterial.getID(), ((SmithingTransformRecipeAccessor)smithingTransformRecipe).getAddition(), outputMaterial.getID());
            RecipeHolder materialSmithingRecipeRecipeHolder = new RecipeHolder(recipeId, (Recipe)materialSmithingRecipe);
            recipes = new ArrayList<RecipeHolder>(recipes);
            recipes.add(materialSmithingRecipeRecipeHolder);
            if (GeneratedMaterialManager.verboseLogging()) {
                Miapi.LOGGER.warn("added Smithing Recipe for " + String.valueOf(sourceMaterial.getID()) + " to " + String.valueOf(outputMaterial.key) + " via " + String.valueOf(BuiltInRegistries.ITEM.getKey((Object)templateItem.getItem())));
            }
            outputMaterial.setSmithingMaterial(sourceMaterial.getID(), template);
            recipeManager.replaceRecipes(recipes);
        }
    }
}

