/*
 * Decompiled with CFR 0.152.
 */
package smartin.miapi.material.palette;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mojang.blaze3d.platform.NativeImage;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.redpxnda.nucleus.util.Color;
import io.netty.handler.codec.DecoderException;
import java.io.Closeable;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.client.renderer.texture.SpriteContents;
import net.minecraft.resources.ResourceLocation;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import smartin.miapi.Miapi;
import smartin.miapi.client.renderer.NativeImageGetter;
import smartin.miapi.material.base.Material;
import smartin.miapi.material.palette.MaterialRenderController;
import smartin.miapi.material.palette.MaterialRenderControllers;
import smartin.miapi.material.palette.SpriteColorer;
import smartin.miapi.material.palette.SpriteFromJson;

@OnlyIn(value=Dist.CLIENT)
public class MaskColorer
extends SpriteColorer {
    public static Map<String, Masker> maskerRegistry = new HashMap<String, Masker>();
    public static Map<ResourceLocation, MapCodec<? extends Masker>> MASKER_REGISTRY = new HashMap<ResourceLocation, MapCodec<? extends Masker>>();
    public Masker masker;
    public SpriteColorer base;
    public SpriteColorer layer;
    public JsonElement originalJson;

    public MaskColorer(Material material, SpriteColorer base, SpriteColorer layer, Masker masker) {
        super(material);
        this.base = base;
        this.layer = layer;
        this.masker = masker;
    }

    public static MaterialRenderController fromJson(Material material, JsonElement element) {
        try {
            JsonObject object = element.getAsJsonObject();
            JsonElement baseElement = object.get("base");
            MaterialRenderController baseColorer = MaterialRenderControllers.creators.get(baseElement.getAsJsonObject().get("type").getAsString()).createPalette(baseElement, material);
            JsonElement layerElement = object.get("layer");
            MaterialRenderController layerColorer = MaterialRenderControllers.creators.get(layerElement.getAsJsonObject().get("type").getAsString()).createPalette(layerElement, material);
            if (baseColorer instanceof SpriteColorer) {
                SpriteColorer baseSpriteColor = (SpriteColorer)baseColorer;
                if (layerColorer instanceof SpriteColorer) {
                    SpriteColorer layerSpriteColor = (SpriteColorer)layerColorer;
                    Masker masker = MaskColorer.getMaskerFromJson(object.get("mask"));
                    MaskColorer controller = new MaskColorer(material, baseSpriteColor, layerSpriteColor, masker);
                    controller.originalJson = element;
                    return controller;
                }
            }
            return baseColorer;
        }
        catch (Exception e) {
            Miapi.LOGGER.error("Could not setup MaskPalette for " + String.valueOf(material.getID()), (Throwable)e);
            return null;
        }
    }

    public static Masker getMaskerFromJson(JsonElement element) {
        JsonObject object = element.getAsJsonObject();
        String type = object.get("type").getAsString();
        ResourceLocation id = Miapi.id(type);
        return (Masker)((Pair)MASKER_REGISTRY.get(id).codec().decode((DynamicOps)JsonOps.INSTANCE, (Object)element).getOrThrow(s -> new DecoderException("could not decode mask " + s))).getFirst();
    }

    @Override
    public Color getAverageColor() {
        return this.masker.average(this.base.getAverageColor(), this.layer.getAverageColor());
    }

    @Override
    public NativeImage transform(SpriteContents originalSprite) {
        return this.masker.mask(this.base.transform(originalSprite), this.layer.transform(originalSprite));
    }

    @Override
    public boolean doTick() {
        return this.base.doTick() || this.layer.doTick() || this.masker.isAnimated();
    }

    @Override
    public void close() throws IOException {
        this.masker.close();
        this.base.close();
        this.layer.close();
    }

    static {
        maskerRegistry.put("texture", new SpriteMasker(null, false));
        MASKER_REGISTRY.put(Miapi.id("texture"), SpriteMasker.MAP_CODEC);
    }

    public static interface Masker
    extends Closeable {
        public NativeImage mask(NativeImage var1, NativeImage var2);

        public Color average(Color var1, Color var2);

        public Masker fromJson(JsonElement var1);

        public boolean isAnimated();
    }

    public static class SpriteMasker
    implements Masker,
    Closeable {
        public static MapCodec<SpriteMasker> DIRECT_MAP_CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)SpriteFromJson.MAP_CODEC.forGetter(c -> c.maskingSprite), (App)Miapi.FIXED_BOOL_CODEC.optionalFieldOf("offset", (Object)false).forGetter(c -> c.offsetRandom)).apply((Applicative)instance, SpriteMasker::new));
        public static MapCodec<SpriteMasker> DEEP_MAP_CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)SpriteFromJson.CODEC.fieldOf("sprite").forGetter(c -> c.maskingSprite), (App)Miapi.FIXED_BOOL_CODEC.optionalFieldOf("offset", (Object)false).forGetter(c -> c.offsetRandom)).apply((Applicative)instance, SpriteMasker::new));
        public static MapCodec<SpriteMasker> MAP_CODEC = Miapi.withAlternative(DIRECT_MAP_CODEC, DEEP_MAP_CODEC);
        SpriteFromJson maskingSprite;
        boolean offsetRandom = false;
        public int offsetAble = 12;
        public NativeImage lastImage = null;

        public SpriteMasker(SpriteFromJson contents, boolean offsetRandom) {
            this.maskingSprite = contents;
            this.offsetRandom = offsetRandom;
        }

        @Override
        public NativeImage mask(NativeImage base, NativeImage other) {
            NativeImageGetter.ImageHolder nativeImage = this.maskingSprite.getNativeImage();
            if (this.lastImage == null) {
                this.lastImage = new NativeImage(base.getWidth(), base.getHeight(), true);
                this.lastImage.untrack();
            }
            if (this.lastImage != null && (this.lastImage.getHeight() != base.getHeight() || this.lastImage.getWidth() != base.getWidth())) {
                this.lastImage.close();
                this.lastImage = new NativeImage(base.getWidth(), base.getHeight(), true);
                this.lastImage.untrack();
            }
            int xOffset = this.offsetRandom ? Math.abs(this.offsetAble * 13 + this.offsetAble * 17) : 0;
            int yOffset = this.offsetRandom ? Math.abs(this.offsetAble * 7 + this.offsetAble * 31) : 0;
            for (int width = 0; width < base.getWidth(); ++width) {
                for (int height = 0; height < base.getHeight(); ++height) {
                    if (this.isAnimated()) {
                        int baseColor = base.getPixelRGBA(width, height);
                        int otherColor = other.getPixelRGBA(width, height);
                        int blendColor = this.offsetRandom ? nativeImage.getColor((width + xOffset) % nativeImage.getWidth(), (height + yOffset) % nativeImage.getHeight()) : nativeImage.getColor(width % nativeImage.getWidth(), height % nativeImage.getHeight());
                        this.lastImage.setPixelRGBA(width, height, this.blendAlt(baseColor, otherColor, blendColor));
                        continue;
                    }
                    this.blend(base, other, width, height, nativeImage.nativeImage, (width + xOffset) % nativeImage.getWidth(), (height + yOffset) % nativeImage.getHeight(), this.lastImage);
                }
            }
            if (this.maskingSprite != null) {
                this.maskingSprite.markUse();
            }
            return this.lastImage;
        }

        public void blend(NativeImage base, NativeImage other, int nativeX, int nativeY, NativeImage blend, int blendX, int blendY, NativeImage output) {
            int baseColor = base.getPixelRGBA(nativeX, nativeY);
            int baseRed = baseColor >> base.format().redOffset() & 0xFF;
            int baseGreen = baseColor >> base.format().greenOffset() & 0xFF;
            int baseBlue = baseColor >> base.format().blueOffset() & 0xFF;
            int baseAlpha = baseColor >> base.format().alphaOffset() & 0xFF;
            int otherColor = other.getPixelRGBA(nativeX, nativeY);
            int otherRed = otherColor >> other.format().redOffset() & 0xFF;
            int otherGreen = otherColor >> other.format().greenOffset() & 0xFF;
            int otherBlue = otherColor >> other.format().blueOffset() & 0xFF;
            int otherAlpha = otherColor >> other.format().alphaOffset() & 0xFF;
            int blendColor = blend.getPixelRGBA(blendX, blendY);
            int blendRed = blendColor >> blend.format().redOffset() & 0xFF;
            int blendGreen = blendColor >> blend.format().greenOffset() & 0xFF;
            int blendBlue = blendColor >> blend.format().blueOffset() & 0xFF;
            int blendAlpha = blendColor >> blend.format().alphaOffset() & 0xFF;
            if (blendAlpha == 0) {
                output.setPixelRGBA(nativeX, nativeY, base.getPixelRGBA(nativeX, nativeY));
                return;
            }
            int blendedRed = (blendRed * otherRed + (255 - blendRed) * baseRed) / 255;
            int blendedGreen = (blendGreen * otherGreen + (255 - blendGreen) * baseGreen) / 255;
            int blendedBlue = (blendBlue * otherBlue + (255 - blendBlue) * baseBlue) / 255;
            int blendedAlpha = (blendAlpha * otherAlpha + (255 - blendAlpha) * baseAlpha) / 255;
            int blendedColor = blendedRed << output.format().redOffset() | blendedGreen << output.format().greenOffset() | blendedBlue << output.format().blueOffset() | blendedAlpha << output.format().alphaOffset();
            output.setPixelRGBA(nativeX, nativeY, blendedColor);
        }

        public int blendAlt(int base, int other, int blend) {
            int baseRed = base >> 24 & 0xFF;
            int baseGreen = base >> 16 & 0xFF;
            int baseBlue = base >> 8 & 0xFF;
            int baseAlpha = base & 0xFF;
            int otherRed = other >> 24 & 0xFF;
            int otherGreen = other >> 16 & 0xFF;
            int otherBlue = other >> 8 & 0xFF;
            int otherAlpha = other & 0xFF;
            int blendRed = blend >> 24 & 0xFF;
            int blendGreen = blend >> 16 & 0xFF;
            int blendBlue = blend >> 8 & 0xFF;
            int blendAlpha = blend & 0xFF;
            int blendedRed = (blendRed * otherRed + (255 - blendRed) * baseRed) / 255;
            int blendedGreen = (blendGreen * otherGreen + (255 - blendGreen) * baseGreen) / 255;
            int blendedBlue = (blendBlue * otherBlue + (255 - blendBlue) * baseBlue) / 255;
            int blendedAlpha = (blendAlpha * otherAlpha + (255 - blendAlpha) * baseAlpha) / 255;
            return blendedRed << 24 | blendedGreen << 16 | blendedBlue << 8 | blendedAlpha;
        }

        @Override
        public Color average(Color base, Color other) {
            return base;
        }

        @Override
        public Masker fromJson(JsonElement element) {
            SpriteFromJson sprite = SpriteFromJson.getFromJson(element);
            boolean offset = element.getAsJsonObject().has("offset") && element.getAsJsonObject().get("offset").getAsBoolean();
            return new SpriteMasker(sprite, offset);
        }

        @Override
        public boolean isAnimated() {
            return this.maskingSprite.isAnimated();
        }

        @Override
        public void close() throws IOException {
            if (this.lastImage != null) {
                this.lastImage.close();
                this.lastImage = null;
            }
        }
    }
}

