/*
 * Decompiled with CFR 0.152.
 */
package smartin.miapi.material.palette;

import com.google.gson.JsonElement;
import com.mojang.blaze3d.platform.NativeImage;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.redpxnda.nucleus.util.Color;
import com.redpxnda.nucleus.util.MiscUtil;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.texture.SpriteContents;
import net.minecraft.client.renderer.texture.TextureAtlas;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.Resource;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.util.FastColor;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import org.jetbrains.annotations.Nullable;
import smartin.miapi.client.atlas.MaterialAtlasManager;
import smartin.miapi.client.atlas.MaterialSpriteManager;
import smartin.miapi.client.renderer.NativeImageGetter;
import smartin.miapi.material.palette.SpriteColorer;

@OnlyIn(value=Dist.CLIENT)
public class SpriteFromJson {
    public static final Map<String, ResourceLocation> atlasIdShortcuts = (Map)MiscUtil.initialize(new HashMap(), m -> {
        m.put("block", TextureAtlas.LOCATION_BLOCKS);
        m.put("particle", TextureAtlas.LOCATION_PARTICLES);
        m.put("material", MaterialAtlasManager.MATERIAL_ATLAS_ID);
    });
    public Supplier<NativeImageGetter.ImageHolder> imageSupplier;
    public boolean isAnimated;
    @Nullable
    public TextureAtlasSprite rawSprite = null;
    public static final Codec<SpriteFromJson> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.STRING.fieldOf("atlas").forGetter(sprite -> {
        for (Map.Entry<String, ResourceLocation> entry : atlasIdShortcuts.entrySet()) {
            if (!entry.getValue().equals((Object)sprite.rawSprite.atlasLocation())) continue;
            return entry.getKey();
        }
        return sprite.rawSprite.atlasLocation().toString();
    }), (App)Codec.STRING.fieldOf("texture").forGetter(sprite -> sprite.rawSprite.contents().name().toString()), (App)Codec.BOOL.optionalFieldOf("forceTick", (Object)false).forGetter(sprite -> sprite.isAnimated)).apply((Applicative)instance, SpriteFromJson::new));
    public static final MapCodec<SpriteFromJson> MAP_CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)Codec.STRING.fieldOf("atlas").forGetter(sprite -> {
        for (Map.Entry<String, ResourceLocation> entry : atlasIdShortcuts.entrySet()) {
            if (!entry.getValue().equals((Object)sprite.rawSprite.atlasLocation())) continue;
            return entry.getKey();
        }
        return sprite.rawSprite.atlasLocation().toString();
    }), (App)Codec.STRING.fieldOf("texture").forGetter(sprite -> sprite.rawSprite.contents().name().toString()), (App)Codec.BOOL.optionalFieldOf("forceTick", (Object)false).forGetter(sprite -> sprite.isAnimated)).apply((Applicative)instance, SpriteFromJson::new));

    public static SpriteFromJson getFromJson(JsonElement element) {
        return (SpriteFromJson)((Pair)MAP_CODEC.codec().decode((DynamicOps)JsonOps.INSTANCE, (Object)element).getOrThrow()).getFirst();
    }

    public SpriteFromJson(String atlasKey, String texturePath, boolean forceTick) {
        ResourceLocation atlasId = atlasIdShortcuts.getOrDefault(atlasKey, ResourceLocation.parse((String)atlasKey));
        ResourceLocation textureId = ResourceLocation.parse((String)texturePath);
        this.rawSprite = (TextureAtlasSprite)Minecraft.getInstance().getTextureAtlas(atlasId).apply(textureId);
        SpriteContents contents = this.rawSprite.contents();
        this.imageSupplier = () -> NativeImageGetter.get(contents);
        this.isAnimated = forceTick || SpriteColorer.isAnimatedSpriteStatic(contents);
    }

    public static NativeImage loadTexture(ResourceManager resourceManager, ResourceLocation id) {
        try {
            NativeImage nativeImage;
            Resource resource = resourceManager.getResourceOrThrow(id);
            try (InputStream inputStream = resource.open();){
                nativeImage = NativeImage.read((InputStream)inputStream);
            }
            return nativeImage;
        }
        catch (Exception ex) {
            throw new IllegalArgumentException("Failed to fetch texture '" + String.valueOf(id) + "' for json sprite data!", ex);
        }
    }

    public void markUse() {
        if (this.isAnimated() && this.rawSprite != null) {
            MaterialSpriteManager.markTextureAsAnimatedInUse(this.rawSprite);
        }
    }

    boolean isAnimated() {
        return this.isAnimated;
    }

    public NativeImageGetter.ImageHolder getNativeImage() {
        return this.imageSupplier.get();
    }

    public Color getAverageColor() {
        int red = 0;
        int green = 0;
        int blue = 0;
        int count = 0;
        NativeImageGetter.ImageHolder img = this.getNativeImage();
        for (int x = 0; x < img.getWidth(); ++x) {
            for (int y = 0; y < img.getHeight(); ++y) {
                int color = img.getColor(x, y);
                red += FastColor.ABGR32.red((int)color);
                green += FastColor.ABGR32.green((int)color);
                blue += FastColor.ABGR32.blue((int)color);
                ++count;
            }
        }
        return new Color(red / count, green / count, blue / count, 255);
    }
}

