/*
 * Decompiled with CFR 0.152.
 */
package smartin.miapi.material.palette;

import com.mojang.blaze3d.platform.NativeImage;
import java.io.IOException;
import net.minecraft.client.renderer.texture.SpriteContents;
import net.minecraft.util.FastColor;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import smartin.miapi.client.renderer.NativeImageGetter;
import smartin.miapi.material.base.Material;
import smartin.miapi.material.palette.SpriteColorer;

@OnlyIn(value=Dist.CLIENT)
public abstract class SpritePixelReplacer
extends SpriteColorer {
    protected NativeImage lastImage = null;

    public SpritePixelReplacer(Material material) {
        super(material);
    }

    public abstract int getReplacementColor(int var1, int var2, int var3);

    @Override
    public NativeImage transform(SpriteContents originalSprite) {
        NativeImageGetter.ImageHolder rawImage = NativeImageGetter.get(originalSprite);
        if (this.lastImage == null) {
            this.lastImage = new NativeImage(rawImage.getWidth(), rawImage.getHeight(), true);
            this.lastImage.untrack();
        }
        if (this.lastImage != null && (this.lastImage.getHeight() != rawImage.getHeight() || this.lastImage.getWidth() != rawImage.getWidth())) {
            this.lastImage.close();
            this.lastImage = new NativeImage(rawImage.getWidth(), rawImage.getHeight(), true);
            this.lastImage.untrack();
        }
        for (int x = 0; x < rawImage.getWidth(); ++x) {
            for (int y = 0; y < rawImage.getHeight(); ++y) {
                int abgr = rawImage.getColor(x, y);
                int opacity = FastColor.ABGR32.alpha((int)abgr);
                if (opacity < 5 && opacity > -1) {
                    this.lastImage.setPixelRGBA(x, y, 0);
                    continue;
                }
                this.lastImage.setPixelRGBA(x, y, this.getReplacementColor(x, y, abgr));
            }
        }
        return this.lastImage;
    }

    @Override
    public void close() throws IOException {
        if (this.lastImage != null) {
            this.lastImage.close();
            this.lastImage = null;
        }
    }
}

