/*
 * Decompiled with CFR 0.152.
 */
package smartin.miapi.mixin;

import net.minecraft.world.entity.Entity;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.ModifyVariable;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import smartin.miapi.events.MiapiEvents;
import smartin.miapi.modules.properties.armor.ExhaustionProperty;
import smartin.miapi.modules.properties.armor.StepCancelingProperty;

@Mixin(value={Entity.class})
public abstract class EntityMixin {
    @Inject(method={"startRiding(Lnet/minecraft/world/entity/Entity;)Z"}, at={@At(value="TAIL")})
    private void miapi$startRidingEvent(Entity vehicle, CallbackInfoReturnable<Boolean> cir) {
        if (((Boolean)cir.getReturnValue()).booleanValue()) {
            ((MiapiEvents.EntityRide)MiapiEvents.START_RIDING.invoker()).ride((Entity)this, vehicle);
        }
    }

    @Inject(method={"stopRiding()V"}, at={@At(value="TAIL")})
    private void miapi$stopRidingEvent(CallbackInfo ci) {
        Entity entity = (Entity)this;
        ((MiapiEvents.EntityRide)MiapiEvents.STOP_RIDING.invoker()).ride(entity, entity.getVehicle());
    }

    @ModifyVariable(method={"vibrationAndSoundEffectsFromBlock(Lnet/minecraft/core/BlockPos;Lnet/minecraft/world/level/block/state/BlockState;ZZLnet/minecraft/world/phys/Vec3;)Z"}, at=@At(value="RETURN"), ordinal=1)
    private boolean miapi$adjustMakeStepNoiseEvent(boolean value) {
        Entity entity = (Entity)this;
        ExhaustionProperty.step(entity);
        return StepCancelingProperty.makesStepNoise(entity, value);
    }

    @ModifyVariable(method={"vibrationAndSoundEffectsFromBlock(Lnet/minecraft/core/BlockPos;Lnet/minecraft/world/level/block/state/BlockState;ZZLnet/minecraft/world/phys/Vec3;)Z"}, at=@At(value="RETURN"), ordinal=0)
    private boolean miapi$adjustMakeStepNoiseSound(boolean value) {
        Entity entity = (Entity)this;
        return StepCancelingProperty.makesStepNoise(entity, value);
    }
}

