/*
 * Decompiled with CFR 0.152.
 */
package smartin.miapi.mixin.client;

import com.mojang.blaze3d.vertex.PoseStack;
import java.util.Optional;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.layers.ElytraLayer;
import net.minecraft.client.renderer.entity.player.PlayerRenderer;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import smartin.miapi.item.modular.items.armor.ModularElytraItem;
import smartin.miapi.mixin.client.ElytraFeatureRendererAccessor;
import smartin.miapi.mixin.client.LivingEntityRendererAccessor;

@Mixin(value={ElytraLayer.class})
public class PlayerEntityModelMixin<T extends LivingEntity> {
    @Inject(method={"Lnet/minecraft/client/renderer/entity/layers/ElytraLayer;render(Lcom/mojang/blaze3d/vertex/PoseStack;Lnet/minecraft/client/renderer/MultiBufferSource;ILnet/minecraft/world/entity/LivingEntity;FFFFFF)V"}, at={@At(value="HEAD")})
    public void adjustElytraAngles(PoseStack poseStack, MultiBufferSource buffer, int packedLight, T livingEntity, float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks, float netHeadYaw, float headPitch, CallbackInfo ci) {
        ItemStack itemStack;
        PlayerRenderer livingEntityRenderer;
        Optional<Object> elytraFeatureRenderer;
        EntityRenderer entityRenderer = Minecraft.getInstance().getEntityRenderDispatcher().getRenderer(livingEntity);
        if (entityRenderer instanceof PlayerRenderer && (elytraFeatureRenderer = ((LivingEntityRendererAccessor)(livingEntityRenderer = (PlayerRenderer)entityRenderer)).getFeatures().stream().filter(a -> a instanceof ElytraLayer).findAny()).isPresent() && !(itemStack = livingEntity.getItemBySlot(EquipmentSlot.CHEST)).is(Items.ELYTRA) && itemStack.getItem() instanceof ModularElytraItem) {
            ((ElytraFeatureRendererAccessor)elytraFeatureRenderer.get()).getElytra().setupAnim(livingEntity, limbSwing, limbSwingAmount, ageInTicks, netHeadYaw, headPitch);
        }
    }
}

