/*
 * Decompiled with CFR 0.152.
 */
package smartin.miapi.modules;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.reflect.TypeToken;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import net.minecraft.core.RegistryAccess;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import smartin.miapi.Miapi;
import smartin.miapi.config.MiapiConfig;
import smartin.miapi.datapack.ReloadEvents;
import smartin.miapi.item.modular.VisualModularItem;
import smartin.miapi.modules.ModuleInstance;
import smartin.miapi.modules.properties.util.MergeType;
import smartin.miapi.modules.properties.util.ModuleProperty;
import smartin.miapi.registries.RegistryInventory;

public record ItemModule(ResourceLocation id, Map<ModuleProperty<?>, Object> properties) {
    public static final String MODULE_KEY = "modules";
    public static final ItemModule empty = new ItemModule(Miapi.id("empty"), new HashMap());
    public static final ItemModule internal = new ItemModule(Miapi.id("internal"), new HashMap());

    public static ItemModule loadFromData(boolean isClient, ResourceLocation path, JsonElement data, RegistryAccess registryAccess) {
        try {
            JsonObject moduleJson = data.getAsJsonObject();
            Type type = new TypeToken<Map<String, JsonElement>>(){}.getType();
            HashMap decodedProperties = new HashMap();
            String id = path.toString();
            id = id.replace("miapi/modules/", "");
            id = id.replace(".json", "");
            ResourceLocation revisedID = ResourceLocation.parse((String)id);
            Map rawProperties = moduleJson.asMap();
            rawProperties.forEach((key, json) -> ItemModule.isValidProperty(key, path, json, isClient, pair -> decodedProperties.put((ModuleProperty)pair.getFirst(), pair.getSecond())));
            return new ItemModule(revisedID, decodedProperties);
        }
        catch (Exception e) {
            Miapi.LOGGER.warn("Could not load Module " + String.valueOf(path), (Throwable)e);
            return null;
        }
    }

    public static <T> T merge(ModuleProperty<T> property, Object left, Object right, MergeType mergeType) {
        return (T)property.merge(left, right, mergeType);
    }

    private static void isValidProperty(String key, ResourceLocation path, JsonElement data, boolean isClient, Consumer<Pair<ModuleProperty<?>, Object>> onValid) {
        ModuleProperty property = RegistryInventory.MODULE_PROPERTY_MIAPI_REGISTRY.get(Miapi.id(key));
        if (property != null) {
            try {
                boolean valid = property.load(Miapi.id(key), data, isClient);
                if (valid) {
                    onValid.accept(new Pair((Object)property, property.decode(data)));
                }
            }
            catch (Exception e) {
                Miapi.LOGGER.error("Failure during moduleLoad, Error in Module " + path.toString() + " with property " + key + " with data " + String.valueOf(data) + "with error " + e.getLocalizedMessage(), (Throwable)e);
            }
        } else {
            Miapi.LOGGER.error("Module " + String.valueOf(path) + " contains invalid property " + key);
            Miapi.LOGGER.error("This indicates either a broken Module, Outdated API version or missing dependency!");
        }
    }

    public static ModuleInstance getModules(ItemStack stack) {
        if (ReloadEvents.isInReload()) {
            if (MiapiConfig.getServerConfig().other.verboseLogging) {
                Miapi.LOGGER.info("Item cannot have modules during a reload.");
            }
            return new ModuleInstance(empty);
        }
        if (stack.getItem() instanceof VisualModularItem && !ReloadEvents.isInReload()) {
            JsonElement compareToJson;
            ModuleInstance root = (ModuleInstance)stack.get(ModuleInstance.MODULE_INSTANCE_COMPONENT);
            if (root != null) {
                for (ModuleInstance moduleInstance : root.allSubModules()) {
                    moduleInstance.contextStack = stack;
                }
            }
            if (root != null && root.allSubModules().size() == 1 && (compareToJson = (JsonElement)stack.get(ModuleInstance.MODULE_BACKUP)) != null) {
                ModuleInstance compareTo = (ModuleInstance)((Pair)ModuleInstance.CODEC.decode((DynamicOps)JsonOps.INSTANCE, (Object)compareToJson).getOrThrow()).getFirst();
                if (root.allSubModules().size() != compareTo.allSubModules().size()) {
                    Miapi.LOGGER.error("MODULE DECODE ISSUE!?! " + String.valueOf(root));
                    Miapi.LOGGER.error("SHOULD HAVE BEEN" + String.valueOf(compareTo));
                    Miapi.LOGGER.error("ATTEMPTING AUTO FIX");
                    compareTo.clearCaches();
                    for (ModuleInstance moduleInstance : compareTo.allSubModules()) {
                        moduleInstance.lookup = root.lookup;
                        moduleInstance.registryAccess = root.registryAccess;
                    }
                    compareTo.writeToItem(stack);
                    return ItemModule.getModules(stack);
                }
            }
            return root;
        }
        return new ModuleInstance(empty);
    }

    public static List<ModuleInstance> createFlatList(ModuleInstance root) {
        ArrayList<ModuleInstance> flatList = new ArrayList<ModuleInstance>();
        ArrayList<ModuleInstance> queue = new ArrayList<ModuleInstance>();
        queue.add(root);
        while (!queue.isEmpty()) {
            ModuleInstance module = (ModuleInstance)queue.removeFirst();
            if (module == null) continue;
            flatList.add(module);
            ArrayList submodules = new ArrayList();
            module.subModules.keySet().stream().sorted().forEach(id -> submodules.add(module.subModules.get(id)));
            queue.addAll(0, submodules);
        }
        return flatList;
    }

    public boolean isEmpty() {
        return this.equals(empty);
    }

    @Override
    public boolean equals(Object other) {
        if (other instanceof ItemModule) {
            ItemModule otherModule = (ItemModule)other;
            return this.id.equals((Object)otherModule.id);
        }
        return false;
    }
}

