/*
 * Decompiled with CFR 0.152.
 */
package smartin.miapi.modules;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.function.Supplier;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.network.chat.Component;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.resources.RegistryOps;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import org.jetbrains.annotations.Nullable;
import smartin.miapi.Miapi;
import smartin.miapi.item.modular.PropertyResolver;
import smartin.miapi.item.modular.StatResolver;
import smartin.miapi.material.MaterialProperty;
import smartin.miapi.material.base.Material;
import smartin.miapi.mixin.RegistryOpsAccessor;
import smartin.miapi.modules.ItemModule;
import smartin.miapi.modules.cache.DataCache;
import smartin.miapi.modules.cache.ModularItemCache;
import smartin.miapi.modules.properties.slot.SlotProperty;
import smartin.miapi.modules.properties.util.MergeType;
import smartin.miapi.modules.properties.util.ModuleProperty;
import smartin.miapi.registries.RegistryInventory;

public class ModuleInstance {
    public static Codec<ModuleInstance> CODEC;
    public static DataComponentType<ModuleInstance> MODULE_INSTANCE_COMPONENT;
    public static DataComponentType<JsonElement> MODULE_BACKUP;
    @Nullable
    public RegistryAccess registryAccess;
    @Nullable
    public RegistryOps.RegistryInfoLookup lookup;
    public ResourceLocation moduleID;
    public ItemModule module;
    @Nullable
    public ModuleInstance parent;
    public Map<String, ModuleInstance> subModules = new LinkedHashMap<String, ModuleInstance>();
    public Map<ResourceLocation, JsonElement> moduleData = new HashMap<ResourceLocation, JsonElement>();
    public Map<ModuleProperty<?>, Object> properties = null;
    public final Object propertyThreadLock = new Object();
    public Map<ModuleProperty<?>, Object> initializedProperties = new ConcurrentHashMap();
    public Map<ModuleProperty<?>, Object> itemMergedProperties = new ConcurrentHashMap();
    public Map<String, Object> cachedData = new ConcurrentHashMap<String, Object>();
    public Map<String, Object> itemStackCache = new ConcurrentHashMap<String, Object>();
    public String slotName = null;
    @Nullable
    public ItemStack contextStack = null;

    public static <T> Codec<T> registrySavingCodec(final Codec<T> baseCodec, final BiConsumer<T, RegistryOps.RegistryInfoLookup> applyLookup) {
        return new Codec<T>(){

            public <T1> DataResult<Pair<T, T1>> decode(DynamicOps<T1> ops, T1 input) {
                DataResult basicResult = baseCodec.decode(ops, input);
                if (ops instanceof RegistryOps) {
                    RegistryOps registryOps = (RegistryOps)ops;
                    if (basicResult.isSuccess()) {
                        applyLookup.accept(((Pair)basicResult.getOrThrow()).getFirst(), ((RegistryOpsAccessor)registryOps).getLookupProvider());
                    }
                }
                return basicResult;
            }

            public <T1> DataResult<T1> encode(T input, DynamicOps<T1> ops, T1 prefix) {
                return baseCodec.encode(input, ops, prefix);
            }
        };
    }

    public ModuleInstance(ItemModule module) {
        this.moduleID = module.id();
        this.module = module;
        ModularItemCache.modules.addInstance(this);
    }

    public ModuleInstance(ResourceLocation module, Map<String, ModuleInstance> subModules, Map<ResourceLocation, JsonElement> data) {
        this.moduleID = module;
        this.subModules = subModules;
        this.moduleData = new HashMap<ResourceLocation, JsonElement>(data);
        subModules.values().forEach(subModule -> {
            subModule.parent = this;
        });
        this.module = RegistryInventory.ITEM_MODULE_MIAPI_REGISTRY.get(module.toString());
        if (this.module == null) {
            this.module = ItemModule.empty;
            Miapi.LOGGER.warn("could not find module " + String.valueOf(module) + " substituting with empty module");
        }
        this.sortSubModule();
        ModularItemCache.modules.addInstance(this);
    }

    public List<ModuleInstance> allSubModules() {
        return ItemModule.createFlatList(this);
    }

    public void setSubModule(String id, ModuleInstance submodule) {
        this.removeSubModule(id);
        this.subModules.put(id, submodule);
        submodule.slotName = id;
        submodule.parent = this;
        this.sortSubModule();
        this.getRoot().clearCaches();
    }

    public void removeSubModule(String id) {
        ModuleInstance oldModule = this.subModules.get(id);
        if (oldModule != null) {
            // empty if block
        }
        this.subModules.remove(id);
        this.getRoot().clearCaches();
    }

    public Map<String, ModuleInstance> getSubModuleMap() {
        return new LinkedHashMap<String, ModuleInstance>(this.subModules);
    }

    @Nullable
    public ModuleInstance getSubModule(String id) {
        return this.subModules.get(id);
    }

    @Nullable
    public ModuleInstance getParent() {
        return this.parent;
    }

    @Nullable
    public <T> T getProperty(ModuleProperty<T> property) {
        Object propertyData = this.initializedProperties.get(property);
        if (propertyData != null) {
            return (T)propertyData;
        }
        if (this.properties == null) {
            PropertyResolver.resolve(this.getRoot());
        }
        if (this.properties == null) {
            Miapi.LOGGER.error("property resolve failed! ");
            Miapi.LOGGER.error("Could not resolve Property " + property.toString() + " ");
            Miapi.LOGGER.error("for Module " + String.valueOf(this.moduleID));
            return null;
        }
        Object propertyDataRaw = this.properties.get(property);
        if (propertyDataRaw != null) {
            Object data = propertyDataRaw;
            data = property.initialize(data, this);
            this.initializedProperties.put(property, data);
            return (T)data;
        }
        return null;
    }

    @Nullable
    public <T> T getPropertyItemStack(ModuleProperty<T> property) {
        if (this.itemMergedProperties.containsKey(property)) {
            return (T)this.itemMergedProperties.get(property);
        }
        Object propertyData = null;
        ModuleInstance lastDataOwner = null;
        ModuleInstance root = this.getRoot();
        for (ModuleInstance moduleInstance : root.allSubModules()) {
            T toMergeData = moduleInstance.getProperty(property);
            if (toMergeData == null) continue;
            if (propertyData == null) {
                propertyData = toMergeData;
                lastDataOwner = moduleInstance;
                continue;
            }
            propertyData = property.merge(propertyData, lastDataOwner, toMergeData, moduleInstance, MergeType.SMART);
        }
        if (property != null && propertyData != null) {
            this.itemMergedProperties.put(property, propertyData);
        }
        return propertyData;
    }

    public ModuleInstance getRoot() {
        ModuleInstance root = this;
        while (root.parent != null) {
            root = root.parent;
        }
        return root;
    }

    public ModuleInstance copy() {
        ArrayList<String> position = new ArrayList<String>();
        this.calculatePosition(position);
        ModuleInstance root = this.getRoot().deepCopy();
        root.registryAccess = this.registryAccess;
        root.lookup = this.lookup;
        root.allSubModules().forEach(m -> {
            m.registryAccess = this.registryAccess;
            m.lookup = this.lookup;
        });
        return root.getPosition(position);
    }

    public void calculatePosition(List<String> position) {
        if (this.parent != null) {
            this.parent.calculatePosition(position);
            position.add(this.getId());
        }
    }

    public ModuleInstance getPosition(List<String> position) {
        String pos;
        ModuleInstance subModule;
        if (!position.isEmpty() && (subModule = this.subModules.get(pos = position.removeFirst())) != null) {
            return subModule.getPosition(position);
        }
        return this;
    }

    @Nullable
    public String getId() {
        if (this.parent != null) {
            for (Map.Entry<String, ModuleInstance> entry : this.parent.subModules.entrySet()) {
                if (entry.getValue() != this) continue;
                return entry.getKey();
            }
        }
        return null;
    }

    public void sortSubModule() {
        SlotProperty.getInstance().getData(this.module);
        LinkedHashMap<String, ModuleInstance> sortedMap = new LinkedHashMap<String, ModuleInstance>();
        SlotProperty.asSortedList(SlotProperty.getInstance().getData(this.module).orElse(new LinkedHashMap())).forEach(slot -> {
            ModuleInstance moduleInstance = this.subModules.get(slot.id);
            if (moduleInstance != null) {
                moduleInstance.parent = this;
                moduleInstance.slotName = slot.id;
                sortedMap.put(slot.id, moduleInstance);
            }
        });
        this.subModules = sortedMap;
    }

    private ModuleInstance deepCopy() {
        ModuleInstance copy = new ModuleInstance(this.module);
        copy.moduleID = this.moduleID;
        copy.registryAccess = this.registryAccess;
        copy.moduleData = new HashMap<ResourceLocation, JsonElement>(this.moduleData);
        this.subModules.forEach((id, subModule) -> {
            ModuleInstance subModuleCopy = subModule.deepCopy();
            copy.setSubModule((String)id, subModuleCopy);
            subModule.registryAccess = this.registryAccess;
        });
        copy.slotName = this.slotName;
        return copy;
    }

    public void writeToItem(ItemStack stack) {
        this.clearCaches();
        this.writeToItem(stack, true);
    }

    public void writeToItem(ItemStack stack, boolean clearCache) {
        if (clearCache) {
            this.clearCaches();
        }
        JsonElement element = (JsonElement)CODEC.encodeStart((DynamicOps)JsonOps.INSTANCE, (Object)this).getOrThrow();
        stack.set(MODULE_INSTANCE_COMPONENT, (Object)this.copy());
        stack.set(MODULE_BACKUP, (Object)element);
    }

    public void clearCaches() {
        this.getRoot().allSubModules().forEach(ModuleInstance::clearCachesOnlyThis);
    }

    public void clearCachesOnlyThis() {
        this.properties = null;
        this.itemMergedProperties.clear();
        this.cachedData.clear();
        this.itemStackCache.clear();
        this.initializedProperties.clear();
    }

    public void clearCachesSoftOnlyThis() {
        this.cachedData.clear();
        this.itemStackCache.clear();
        this.initializedProperties.clear();
    }

    @OnlyIn(value=Dist.CLIENT)
    public Component getModuleName() {
        String moduleName = this.module.id().toString();
        moduleName = moduleName.replace(":", ".");
        moduleName = moduleName.replaceAll("/", ".");
        Material material = MaterialProperty.getMaterial(this);
        if (material != null) {
            return Component.translatable((String)("miapi.module." + moduleName), (Object[])new Object[]{material.getTranslation()});
        }
        return StatResolver.translateAndResolve("miapi.module." + moduleName, this);
    }

    @OnlyIn(value=Dist.CLIENT)
    public Component getModuleDescription() {
        String moduleName = this.module.id().toString();
        moduleName = moduleName.replace(":", ".");
        moduleName = moduleName.replaceAll("/", ".");
        Material material = MaterialProperty.getMaterial(this);
        if (material != null) {
            return Component.translatable((String)("miapi.module." + moduleName + ".description"), (Object[])new Object[]{material.getTranslation()});
        }
        return StatResolver.translateAndResolve("miapi.module." + moduleName + ".description", this);
    }

    public Optional<ModuleInstance> parseTo(String[] data) {
        if (data.length == 0) {
            return Optional.of(this);
        }
        String[] newArray = Arrays.copyOfRange(data, 1, data.length);
        if ("parent".equals(data[0])) {
            if (this.parent != null) {
                return this.parent.parseTo(newArray);
            }
        } else {
            try {
                String id = data[0];
                if (this.subModules.containsKey(id)) {
                    return this.subModules.get(id).parseTo(newArray);
                }
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return Optional.empty();
    }

    public String[] getStringPosition() {
        ArrayList<String> position = new ArrayList<String>();
        ModuleInstance parser = this;
        while (this.parent != null) {
            ModuleInstance filter = parser;
            Optional<Map.Entry> next = this.parent.subModules.entrySet().stream().filter(e -> ((ModuleInstance)e.getValue()).equals(filter)).findFirst();
            if (next.isEmpty()) {
                return position.toArray(new String[0]);
            }
            position.add((String)next.get().getKey());
            parser = (ModuleInstance)next.get().getValue();
        }
        return position.toArray(new String[0]);
    }

    public <T> T getFromCache(String key, Supplier<T> fallback) {
        Object data = this.cachedData.get(key);
        if (data != null) {
            return (T)data;
        }
        DataCache.ModuleCacheSupplier cacheSupplier = ModularItemCache.MODULE_CACHE_SUPPLIER.get(key);
        if (cacheSupplier != null && (data = cacheSupplier.apply(this)) != null) {
            this.cachedData.put(key, data);
            return (T)data;
        }
        return fallback.get();
    }

    public <T> T getFromCache(String key, ItemStack itemStack, T fallback) {
        return ModularItemCache.get(itemStack, key, fallback);
    }

    public <T> T getFromCache(String key, ItemStack itemStack, Supplier<T> fallback) {
        return ModularItemCache.get(itemStack, key, fallback);
    }

    public <T> T getFromCache(String key, ItemStack itemStack, Map<String, ModularItemCache.CacheObjectSupplier> supplierMap, Supplier<T> fallback) {
        Object data = this.cachedData.get(key);
        if (data != null) {
            return (T)data;
        }
        ModularItemCache.CacheObjectSupplier cacheSupplier = supplierMap.get(key);
        if (cacheSupplier != null && (data = cacheSupplier.apply(itemStack)) != null) {
            this.cachedData.put(key, data);
            return (T)data;
        }
        return fallback.get();
    }

    public Map<ResourceLocation, JsonElement> getSaveData() {
        HashMap<ResourceLocation, JsonElement> map = new HashMap<ResourceLocation, JsonElement>();
        this.moduleData.forEach((id, data) -> {
            if (data != null) {
                map.put((ResourceLocation)id, this.nullSave((JsonElement)data));
            }
        });
        return map;
    }

    public JsonElement nullSave(JsonElement element) {
        if (element.isJsonObject()) {
            JsonObject obj = element.getAsJsonObject();
            JsonObject cleanedObj = new JsonObject();
            for (String key : obj.keySet()) {
                JsonElement value = obj.get(key);
                if (value.isJsonNull()) continue;
                cleanedObj.add(key, this.nullSave(value));
            }
            return cleanedObj;
        }
        if (element.isJsonArray()) {
            JsonArray arr = element.getAsJsonArray();
            JsonArray cleanedArr = new JsonArray();
            for (JsonElement item : arr) {
                if (item.isJsonNull()) continue;
                cleanedArr.add(this.nullSave(item));
            }
            return cleanedArr;
        }
        return element;
    }

    public String toString() {
        return ((JsonElement)CODEC.encodeStart((DynamicOps)JsonOps.INSTANCE, (Object)this).getOrThrow()).toString();
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof ModuleInstance)) {
            return false;
        }
        ModuleInstance other = (ModuleInstance)object;
        if (!this.module.equals(other.module)) {
            return false;
        }
        if (!this.moduleData.equals(other.moduleData)) {
            return false;
        }
        if (this.subModules.size() != other.subModules.size()) {
            return false;
        }
        for (Map.Entry<String, ModuleInstance> entry : this.subModules.entrySet()) {
            ModuleInstance otherSubModule = other.subModules.get(entry.getKey());
            if (otherSubModule != null && entry.getValue().equals(otherSubModule)) continue;
            return false;
        }
        if (this.slotName != null && other.slotName != null) {
            return this.slotName.equals(other.slotName);
        }
        return this.slotName == null && other.slotName == null;
    }

    public int hashCode() {
        return super.hashCode();
    }

    static {
        MODULE_BACKUP = DataComponentType.builder().persistent(StatResolver.Codecs.JSONELEMENT_CODEC).networkSynchronized(ByteBufCodecs.fromCodec(StatResolver.Codecs.JSONELEMENT_CODEC)).build();
        Codec dataJsonCodec = Codec.unboundedMap(Miapi.ID_CODEC, StatResolver.Codecs.JSONELEMENT_CODEC).xmap(i -> i, Function.identity());
        Codec basicCodec = Codec.recursive((String)"module_instance", selfCodec -> RecordCodecBuilder.create(instance -> instance.group((App)ResourceLocation.CODEC.fieldOf("key").forGetter(moduleInstance -> moduleInstance.moduleID), (App)Codec.unboundedMap((Codec)Codec.STRING, (Codec)selfCodec).xmap(i -> i, Function.identity()).optionalFieldOf("child", new LinkedHashMap()).forGetter(moduleInstance -> moduleInstance.subModules), (App)dataJsonCodec.optionalFieldOf("data", new HashMap()).forGetter(ModuleInstance::getSaveData)).apply((Applicative)instance, ModuleInstance::new)));
        CODEC = ModuleInstance.registrySavingCodec(basicCodec, (m, l) -> m.allSubModules().forEach(moduleInstance -> {
            moduleInstance.lookup = l;
        }));
        MODULE_INSTANCE_COMPONENT = DataComponentType.builder().persistent(CODEC).networkSynchronized(ByteBufCodecs.fromCodec(CODEC)).build();
    }
}

