/*
 * Decompiled with CFR 0.152.
 */
package smartin.miapi.modules.abilities;

import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DynamicOps;
import com.redpxnda.nucleus.codec.auto.AutoCodec;
import com.redpxnda.nucleus.codec.behavior.CodecBehavior;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.CropBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import smartin.miapi.item.modular.StatResolver;
import smartin.miapi.modules.ModuleInstance;
import smartin.miapi.modules.abilities.util.ItemAbilityManager;
import smartin.miapi.modules.abilities.util.ItemUseDefaultCooldownAbility;
import smartin.miapi.modules.abilities.util.ItemUseMinHoldAbility;

public class AreaHarvestReplant
implements ItemUseDefaultCooldownAbility<AreaHarvestJson>,
ItemUseMinHoldAbility<AreaHarvestJson> {
    public static String KEY = "area_harvest_ability";
    public static Codec<AreaHarvestJson> CODEC = AutoCodec.of(AreaHarvestJson.class).codec();

    @Override
    public boolean allowedOnItem(ItemStack itemStack, Level world, Player player, InteractionHand hand, ItemAbilityManager.AbilityHitContext abilityHitContext) {
        if (abilityHitContext.hitEntity() == null && abilityHitContext.hitResult() != null) {
            BlockState state = abilityHitContext.hitResult().getLevel().getBlockState(abilityHitContext.hitResult().getClickedPos());
            return this.isGrown(state);
        }
        return false;
    }

    public boolean isGrown(BlockState state) {
        Block block = state.getBlock();
        if (block instanceof CropBlock) {
            CropBlock cropBlock = (CropBlock)block;
            return cropBlock.isMaxAge(state);
        }
        return false;
    }

    @Override
    public UseAnim getUseAction(ItemStack itemStack) {
        return UseAnim.BRUSH;
    }

    @Override
    public int getMaxUseTime(ItemStack itemStack, LivingEntity entity) {
        return 10;
    }

    @Override
    public InteractionResultHolder<ItemStack> use(Level world, Player user, InteractionHand hand) {
        return null;
    }

    @Override
    public InteractionResult useOnBlock(UseOnContext context) {
        Player player;
        ItemStack itemStack = context.getItemInHand();
        if (!context.getLevel().isClientSide() && (player = context.getPlayer()) instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            int blocksHarvested = 0;
            int range = ((AreaHarvestJson)this.getSpecialContext((ItemStack)itemStack)).range.evaluatedOutput;
            BlockState state = context.getLevel().getBlockState(context.getClickedPos());
            BlockPos origin = context.getClickedPos();
            if (this.isGrown(state)) {
                for (int x = -range; x <= range; ++x) {
                    for (int y = -range; y <= range; ++y) {
                        Block block;
                        BlockPos currentPos = origin.offset(x, 0, y);
                        BlockState blockState = context.getLevel().getBlockState(currentPos);
                        if (!this.isGrown(blockState) || !((block = blockState.getBlock()) instanceof CropBlock)) continue;
                        CropBlock cropBlock = (CropBlock)block;
                        block = context.getLevel();
                        if (!(block instanceof ServerLevel)) continue;
                        ServerLevel serverWorld = (ServerLevel)block;
                        BlockEntity blockEntity = blockState.hasBlockEntity() ? context.getLevel().getBlockEntity(currentPos) : null;
                        List stacks = Block.getDrops((BlockState)blockState, (ServerLevel)serverWorld, (BlockPos)currentPos, (BlockEntity)blockEntity, (Entity)serverPlayer, (ItemStack)ItemStack.EMPTY);
                        serverWorld.setBlockAndUpdate(currentPos, cropBlock.getStateForAge(0));
                        stacks.forEach(arg_0 -> ((ServerPlayer)serverPlayer).spawnAtLocation(arg_0));
                        ++blocksHarvested;
                    }
                }
            }
            itemStack.hurtAndBreak(blocksHarvested, (LivingEntity)serverPlayer, this.getEquipmentSlot(context.getHand()));
            return InteractionResult.sidedSuccess((boolean)context.getLevel().isClientSide());
        }
        return InteractionResult.FAIL;
    }

    @Override
    public <K> AreaHarvestJson decode(DynamicOps<K> ops, K prefix) {
        return (AreaHarvestJson)((Pair)CODEC.decode(ops, prefix).getOrThrow()).getFirst();
    }

    @Override
    public AreaHarvestJson initialize(AreaHarvestJson data, ModuleInstance moduleInstance) {
        return data.initialize(moduleInstance);
    }

    @Override
    public AreaHarvestJson getDefaultContext() {
        return null;
    }

    @Override
    public int getCooldown(ItemStack itemstack) {
        return ((AreaHarvestJson)this.getSpecialContext((ItemStack)itemstack)).cooldown.evaluatedOutput;
    }

    @Override
    public int getMinHoldTime(ItemStack itemStack) {
        return ((AreaHarvestJson)this.getSpecialContext((ItemStack)itemStack)).minUseTime.evaluatedOutput;
    }

    public static class AreaHarvestJson {
        @CodecBehavior.Optional
        @AutoCodec.Name(value="min_hold_time")
        public StatResolver.IntegerFromStat minUseTime = new StatResolver.IntegerFromStat(0);
        @CodecBehavior.Optional
        public StatResolver.IntegerFromStat cooldown = new StatResolver.IntegerFromStat(0);
        @CodecBehavior.Optional
        public StatResolver.IntegerFromStat range = new StatResolver.IntegerFromStat(1);

        public AreaHarvestJson initialize(ModuleInstance moduleInstance) {
            AreaHarvestJson init = new AreaHarvestJson();
            init.cooldown = this.cooldown;
            init.minUseTime = this.minUseTime;
            init.range = this.range;
            init.cooldown.evaluate(moduleInstance);
            init.minUseTime.evaluate(moduleInstance);
            init.range.evaluate(moduleInstance);
            return init;
        }
    }
}

