/*
 * Decompiled with CFR 0.152.
 */
package smartin.miapi.modules.abilities;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Multimap;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DynamicOps;
import com.redpxnda.nucleus.codec.auto.AutoCodec;
import com.redpxnda.nucleus.codec.behavior.CodecBehavior;
import com.redpxnda.nucleus.pose.server.ServerPoseFacet;
import java.util.ArrayList;
import net.minecraft.core.Holder;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import smartin.miapi.Miapi;
import smartin.miapi.attributes.AttributeRegistry;
import smartin.miapi.item.modular.StatResolver;
import smartin.miapi.modules.ModuleInstance;
import smartin.miapi.modules.abilities.util.AbilityMangerProperty;
import smartin.miapi.modules.abilities.util.EntityAttributeAbility;
import smartin.miapi.modules.abilities.util.ItemAbilityManager;
import smartin.miapi.modules.properties.LoreProperty;
import smartin.miapi.modules.properties.util.DoubleOperationResolvable;

public class BlockAbility
extends EntityAttributeAbility<BlockAbilityJson> {
    public static Codec<BlockAbilityJson> CODEC = AutoCodec.of(BlockAbilityJson.class).codec();
    ResourceLocation id = Miapi.id("block_ability_temporary_attribute");

    public BlockAbility() {
        LoreProperty.bottomLoreSuppliers.add(itemStack -> {
            ArrayList<MutableComponent> texts = new ArrayList<MutableComponent>();
            if (AbilityMangerProperty.isPrimaryAbility(this, itemStack)) {
                MutableComponent raw = Component.translatable((String)"miapi.ability.block.lore");
                texts.add(raw);
            }
            return texts;
        });
    }

    @Override
    protected Multimap<Holder<Attribute>, AttributeModifier> getAttributes(ItemStack itemStack) {
        ArrayListMultimap multimap = ArrayListMultimap.create();
        BlockAbilityJson json = (BlockAbilityJson)this.getSpecialContext(itemStack);
        double value = json.blocking.getValue();
        value = BlockAbility.calculate(value);
        multimap.put((Object)Attributes.MOVEMENT_SPEED, (Object)new AttributeModifier(this.id, -(value / 2.0) / 100.0, AttributeModifier.Operation.ADD_MULTIPLIED_TOTAL));
        multimap.put(AttributeRegistry.DAMAGE_RESISTANCE, (Object)new AttributeModifier(this.id, value, AttributeModifier.Operation.ADD_VALUE));
        return multimap;
    }

    public static double calculate(double value) {
        return 160.0 / (1.0 + Math.exp(-value / 50.0)) - 80.0;
    }

    @Override
    public boolean allowedOnItem(ItemStack itemStack, Level world, Player player, InteractionHand hand, ItemAbilityManager.AbilityHitContext abilityHitContext) {
        return true;
    }

    @Override
    public int getMaxUseTime(ItemStack itemStack, LivingEntity entity) {
        return 72000;
    }

    @Override
    public InteractionResultHolder<ItemStack> use(Level world, Player user, InteractionHand hand) {
        this.setAnimation(user, hand);
        return super.use(world, user, hand);
    }

    @Override
    public ItemStack finishUsing(ItemStack stack, Level world, LivingEntity user) {
        this.resetAnimation(user);
        return super.finishUsing(stack, world, user);
    }

    @Override
    public void onStoppedUsingAfter(ItemStack stack, Level world, LivingEntity user, int remainingUseTicks) {
        this.resetAnimation(user);
        super.onStoppedUsingAfter(stack, world, user, remainingUseTicks);
    }

    @Override
    public void onStoppedHolding(ItemStack stack, Level world, LivingEntity user) {
        this.resetAnimation(user);
        super.onStoppedHolding(stack, world, user);
    }

    @Override
    public BlockAbilityJson getDefaultContext() {
        return null;
    }

    public void setAnimation(Player p, InteractionHand hand) {
        ServerPlayer player;
        ServerPoseFacet facet;
        if (p instanceof ServerPlayer && (facet = (ServerPoseFacet)ServerPoseFacet.KEY.get((Entity)(player = (ServerPlayer)p))) != null) {
            facet.set("miapi:block", player, hand);
        }
    }

    public void resetAnimation(LivingEntity entity) {
        ServerPlayer player;
        ServerPoseFacet facet;
        if (entity instanceof ServerPlayer && (facet = (ServerPoseFacet)ServerPoseFacet.KEY.get((Entity)(player = (ServerPlayer)entity))) != null) {
            facet.reset(player);
        }
    }

    @Override
    public int getCooldown(ItemStack itemstack) {
        return ((BlockAbilityJson)this.getSpecialContext((ItemStack)itemstack)).cooldown.evaluatedOutput;
    }

    @Override
    public int getMinHoldTime(ItemStack itemStack) {
        return ((BlockAbilityJson)this.getSpecialContext((ItemStack)itemStack)).minUseTime.evaluatedOutput;
    }

    @Override
    public <K> BlockAbilityJson decode(DynamicOps<K> ops, K prefix) {
        return (BlockAbilityJson)((Pair)CODEC.decode(ops, prefix).getOrThrow()).getFirst();
    }

    @Override
    public BlockAbilityJson initialize(BlockAbilityJson data, ModuleInstance moduleInstance) {
        return data.initialize(moduleInstance);
    }

    public static class BlockAbilityJson {
        @CodecBehavior.Optional
        @AutoCodec.Name(value="min_hold_time")
        public StatResolver.IntegerFromStat minUseTime = new StatResolver.IntegerFromStat(0);
        @CodecBehavior.Optional
        public StatResolver.IntegerFromStat cooldown = new StatResolver.IntegerFromStat(0);
        public DoubleOperationResolvable blocking = new DoubleOperationResolvable(10.0);

        public BlockAbilityJson initialize(ModuleInstance moduleInstance) {
            BlockAbilityJson init = new BlockAbilityJson();
            init.minUseTime = this.minUseTime;
            init.cooldown = this.cooldown;
            this.minUseTime.evaluate(moduleInstance);
            this.cooldown.evaluate(moduleInstance);
            init.blocking = this.blocking.initialize(moduleInstance);
            return init;
        }
    }
}

