/*
 * Decompiled with CFR 0.152.
 */
package smartin.miapi.modules.abilities;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.minecraft.core.Vec3i;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LightningBolt;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import smartin.miapi.modules.ModuleInstance;
import smartin.miapi.modules.abilities.util.ItemAbilityManager;
import smartin.miapi.modules.abilities.util.ItemUseDefaultCooldownAbility;
import smartin.miapi.modules.abilities.util.ItemUseMinHoldAbility;
import smartin.miapi.modules.properties.util.DoubleOperationResolvable;
import smartin.miapi.modules.properties.util.MergeType;

public class CastLightingAbility
implements ItemUseDefaultCooldownAbility<CastLightingContext>,
ItemUseMinHoldAbility<CastLightingContext> {
    public static String KEY = "cast_lighting";

    @Override
    public int getCooldown(ItemStack itemStack) {
        return (int)((CastLightingContext)this.getSpecialContext(itemStack)).cooldown().getValue();
    }

    @Override
    public int getMinHoldTime(ItemStack itemStack) {
        return (int)((CastLightingContext)this.getSpecialContext(itemStack)).minHold().getValue();
    }

    @Override
    public boolean allowedOnItem(ItemStack itemStack, Level world, Player player, InteractionHand hand, ItemAbilityManager.AbilityHitContext abilityHitContext) {
        return Math.pow(((CastLightingContext)this.getSpecialContext(itemStack)).maxRange().getValue(), 2.0) >= abilityHitContext.hitResult().getClickedPos().distToCenterSqr(player.getX(), player.getY(), player.getZ());
    }

    @Override
    public UseAnim getUseAction(ItemStack itemStack) {
        return UseAnim.SPEAR;
    }

    @Override
    public int getMaxUseTime(ItemStack itemStack, LivingEntity livingEntity) {
        return 7200;
    }

    @Override
    public InteractionResultHolder<ItemStack> use(Level world, Player user, InteractionHand hand) {
        return null;
    }

    @Override
    public InteractionResult useOnBlock(UseOnContext context) {
        ItemStack itemStack = context.getItemInHand();
        Player player = context.getPlayer();
        CastLightingContext castLightingContext = (CastLightingContext)this.getSpecialContext(itemStack);
        Player player2 = context.getPlayer();
        if (player2 instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player2;
            if (Math.pow(castLightingContext.maxRange().getValue(), 2.0) >= context.getClickedPos().distToCenterSqr(player.getX(), player.getY(), player.getZ())) {
                context.getClickedPos();
                int i = 0;
                while ((double)i < castLightingContext.lighting().getValue()) {
                    LightningBolt lightningEntity = (LightningBolt)EntityType.LIGHTNING_BOLT.create(context.getLevel());
                    assert (lightningEntity != null);
                    lightningEntity.moveTo(Vec3.atBottomCenterOf((Vec3i)context.getClickedPos()));
                    lightningEntity.setCause(serverPlayer);
                    context.getLevel().addFreshEntity((Entity)lightningEntity);
                    ++i;
                }
                return InteractionResult.SUCCESS;
            }
        }
        return InteractionResult.FAIL;
    }

    @Override
    public <K> CastLightingContext decode(DynamicOps<K> ops, K prefix) {
        return (CastLightingContext)((Pair)CastLightingContext.CODEC.decode(ops, prefix).getOrThrow()).getFirst();
    }

    @Override
    public CastLightingContext getDefaultContext() {
        return new CastLightingContext(SoundEvents.EMPTY, new DoubleOperationResolvable(10.0), new DoubleOperationResolvable(1.0), new DoubleOperationResolvable(40.0), new DoubleOperationResolvable(6.0));
    }

    @Override
    public CastLightingContext initialize(CastLightingContext json, ModuleInstance moduleInstance) {
        return json.initialize(moduleInstance);
    }

    @Override
    public CastLightingContext merge(CastLightingContext left, CastLightingContext right, MergeType mergeType) {
        return CastLightingContext.merge(left, right, mergeType);
    }

    public record CastLightingContext(SoundEvent onThrow, DoubleOperationResolvable minHold, DoubleOperationResolvable lighting, DoubleOperationResolvable cooldown, DoubleOperationResolvable maxRange) {
        public static final Codec<CastLightingContext> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)SoundEvent.DIRECT_CODEC.optionalFieldOf("on_throw", (Object)SoundEvents.EMPTY).forGetter(CastLightingContext::onThrow), (App)DoubleOperationResolvable.CODEC.optionalFieldOf("min_hold", (Object)new DoubleOperationResolvable(10.0)).forGetter(CastLightingContext::minHold), (App)DoubleOperationResolvable.CODEC.optionalFieldOf("lighting", (Object)new DoubleOperationResolvable(1.0)).forGetter(CastLightingContext::lighting), (App)DoubleOperationResolvable.CODEC.optionalFieldOf("cooldown", (Object)new DoubleOperationResolvable(50.0)).forGetter(CastLightingContext::maxRange), (App)DoubleOperationResolvable.CODEC.optionalFieldOf("max_range", (Object)new DoubleOperationResolvable(5.0)).forGetter(CastLightingContext::maxRange)).apply((Applicative)instance, CastLightingContext::new));

        public CastLightingContext initialize(ModuleInstance moduleInstance) {
            SoundEvent initializedOnThrow = this.onThrow;
            DoubleOperationResolvable initializedMinHold = this.minHold.initialize(moduleInstance);
            DoubleOperationResolvable initializedLighting = this.lighting.initialize(moduleInstance);
            DoubleOperationResolvable initializedCooldown = this.cooldown.initialize(moduleInstance);
            DoubleOperationResolvable initializedMaxRange = this.maxRange.initialize(moduleInstance);
            return new CastLightingContext(initializedOnThrow, initializedMinHold, initializedLighting, initializedCooldown, initializedMaxRange);
        }

        public static CastLightingContext merge(CastLightingContext left, CastLightingContext right, MergeType mergeType) {
            SoundEvent mergedOnThrow = MergeType.EXTEND.equals((Object)mergeType) && left.onThrow != null ? left.onThrow : right.onThrow;
            DoubleOperationResolvable mergedMinHold = left.minHold.merge(right.minHold, mergeType);
            DoubleOperationResolvable mergedLighting = left.lighting.merge(right.lighting, mergeType);
            DoubleOperationResolvable mergedCooldown = left.cooldown.merge(right.cooldown, mergeType);
            DoubleOperationResolvable mergedMaxRange = left.maxRange.merge(right.maxRange, mergeType);
            return new CastLightingContext(mergedOnThrow, mergedMinHold, mergedLighting, mergedCooldown, mergedMaxRange);
        }
    }
}

