/*
 * Decompiled with CFR 0.152.
 */
package smartin.miapi.modules.abilities;

import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DynamicOps;
import com.redpxnda.nucleus.codec.auto.AutoCodec;
import com.redpxnda.nucleus.codec.behavior.CodecBehavior;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.food.FoodProperties;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.level.Level;
import smartin.miapi.modules.ModuleInstance;
import smartin.miapi.modules.abilities.util.ItemAbilityManager;
import smartin.miapi.modules.abilities.util.ItemUseDefaultCooldownAbility;
import smartin.miapi.modules.abilities.util.ItemUseMinHoldAbility;
import smartin.miapi.modules.properties.util.DoubleOperationResolvable;
import smartin.miapi.modules.properties.util.MergeType;

public class EatAbility
implements ItemUseDefaultCooldownAbility<EatRawData>,
ItemUseMinHoldAbility<EatRawData> {
    public static final String KEY = "eat";

    @Override
    public boolean allowedOnItem(ItemStack itemStack, Level world, Player player, InteractionHand hand, ItemAbilityManager.AbilityHitContext abilityHitContext) {
        EatRawData data = (EatRawData)this.getSpecialContext(itemStack);
        return data != null && (data.alwaysEdible || player.getFoodData().needsFood());
    }

    @Override
    public UseAnim getUseAction(ItemStack itemStack) {
        return UseAnim.EAT;
    }

    @Override
    public int getMaxUseTime(ItemStack itemStack, LivingEntity entity) {
        return ((EatRawData)this.getSpecialContext(itemStack)).eatTicks();
    }

    @Override
    public InteractionResultHolder<ItemStack> use(Level world, Player user, InteractionHand hand) {
        if (user.getCooldowns().isOnCooldown(user.getItemInHand(hand).getItem())) {
            return InteractionResultHolder.pass((Object)user.getItemInHand(hand));
        }
        user.startUsingItem(hand);
        return InteractionResultHolder.consume((Object)user.getItemInHand(hand));
    }

    @Override
    public void usageTick(Level world, LivingEntity user, ItemStack stack, int remainingUseTicks) {
        if (remainingUseTicks <= 0) {
            user.releaseUsingItem();
            EatRawData context = (EatRawData)this.getSpecialContext(stack);
            boolean isClient = user.level().isClientSide;
            if (isClient) {
                user.level().playLocalSound(user.getX(), user.getY(), user.getZ(), user.getEatingSound(stack), SoundSource.NEUTRAL, 1.0f, 1.0f + (world.random.nextFloat() - world.random.nextFloat()) * 0.4f, true);
            }
            if (user instanceof Player) {
                Player player = (Player)user;
                if (!isClient) {
                    player.getFoodData().eat(context.getNutrition(), (float)context.getSaturation());
                    context.effects.forEach(possibleEffect -> {
                        if (user.level().getRandom().nextFloat() < possibleEffect.probability()) {
                            player.addEffect(new MobEffectInstance(possibleEffect.effect()));
                        }
                    });
                    if (player instanceof ServerPlayer) {
                        ServerPlayer serverPlayerEntity = (ServerPlayer)player;
                        if (context.consumeOnEat()) {
                            stack.shrink(1);
                        } else {
                            stack.hurtAndBreak(context.durabilityDamage(), (LivingEntity)serverPlayerEntity, this.getEquipmentSlot(user.getUsedItemHand()));
                        }
                    }
                } else {
                    user.level().playLocalSound(user.getX(), user.getY(), user.getZ(), SoundEvents.PLAYER_BURP, SoundSource.NEUTRAL, 0.5f, world.random.nextFloat() * 0.1f + 0.9f, true);
                }
            }
        }
    }

    @Override
    public <K> EatRawData decode(DynamicOps<K> ops, K prefix) {
        return (EatRawData)((Pair)EatRawData.codec.decode(ops, prefix).getOrThrow()).getFirst();
    }

    @Override
    public EatRawData getDefaultContext() {
        return null;
    }

    @Override
    public int getCooldown(ItemStack itemStack) {
        return ((EatRawData)this.getSpecialContext(itemStack)).getCooldown();
    }

    @Override
    public int getMinHoldTime(ItemStack itemStack) {
        return ((EatRawData)this.getSpecialContext(itemStack)).eatTicks();
    }

    public static class EatRawData {
        public static final Codec<EatRawData> codec = AutoCodec.of(EatRawData.class).codec();
        public DoubleOperationResolvable nutrition;
        public DoubleOperationResolvable saturation;
        public DoubleOperationResolvable eat_ticks = new DoubleOperationResolvable(32.0);
        public DoubleOperationResolvable cooldown = new DoubleOperationResolvable(0.0);
        @CodecBehavior.Optional
        public DoubleOperationResolvable durability = new DoubleOperationResolvable(0.0);
        @CodecBehavior.Optional
        public boolean alwaysEdible = false;
        @CodecBehavior.Override(value="effect_codec")
        public static Codec<List<FoodProperties.PossibleEffect>> effect_codec = Codec.list((Codec)FoodProperties.PossibleEffect.CODEC);
        @CodecBehavior.Optional
        public List<FoodProperties.PossibleEffect> effects = new ArrayList<FoodProperties.PossibleEffect>();

        public EatRawData initialize(ModuleInstance instance) {
            this.nutrition.initialize(instance);
            this.saturation.initialize(instance);
            this.durability.initialize(instance);
            return this;
        }

        public EatRawData merge(EatRawData merge, MergeType mergeType) {
            return EatRawData.merge(this, merge, mergeType);
        }

        public static EatRawData merge(EatRawData left, EatRawData right, MergeType mergeType) {
            EatRawData rawData = new EatRawData();
            rawData.nutrition = DoubleOperationResolvable.merge(left.nutrition, right.nutrition, mergeType);
            rawData.saturation = DoubleOperationResolvable.merge(left.saturation, right.saturation, mergeType);
            rawData.durability = DoubleOperationResolvable.merge(left.durability, right.durability, mergeType);
            if (MergeType.OVERWRITE.equals((Object)mergeType)) {
                rawData.effects = right.effects;
            } else {
                ArrayList<FoodProperties.PossibleEffect> mergedEffects = new ArrayList<FoodProperties.PossibleEffect>(left.effects);
                mergedEffects.addAll(right.effects);
                rawData.effects = mergedEffects;
            }
            rawData.alwaysEdible = left.alwaysEdible || right.alwaysEdible;
            return rawData;
        }

        int getNutrition() {
            return (int)this.nutrition.evaluate(0.0, 1.0);
        }

        int getCooldown() {
            return (int)this.cooldown.evaluate(0.0, 0.0);
        }

        double getSaturation() {
            return this.saturation.evaluate(0.0, 1.0);
        }

        int eatTicks() {
            return (int)this.eat_ticks.evaluate(0.0, 32.0);
        }

        int durabilityDamage() {
            return (int)this.eat_ticks.evaluate(0.0, 0.0);
        }

        boolean consumeOnEat() {
            return this.eat_ticks.evaluate(0.0) == null;
        }
    }
}

