/*
 * Decompiled with CFR 0.152.
 */
package smartin.miapi.modules.abilities;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import smartin.miapi.modules.ModuleInstance;
import smartin.miapi.modules.abilities.util.ItemAbilityManager;
import smartin.miapi.modules.abilities.util.ItemUseDefaultCooldownAbility;
import smartin.miapi.modules.abilities.util.ItemUseMinHoldAbility;
import smartin.miapi.modules.properties.util.DoubleOperationResolvable;
import smartin.miapi.modules.properties.util.MergeType;

public class SonicBoomAbility
implements ItemUseDefaultCooldownAbility<SonicBoomContext>,
ItemUseMinHoldAbility<SonicBoomContext> {
    public static String KEY = "sonic_boom";

    @Override
    public int getCooldown(ItemStack itemStack) {
        return (int)((SonicBoomContext)this.getSpecialContext(itemStack)).cooldown().getValue();
    }

    @Override
    public int getMinHoldTime(ItemStack itemStack) {
        return (int)((SonicBoomContext)this.getSpecialContext(itemStack)).minHold().getValue();
    }

    @Override
    public boolean allowedOnItem(ItemStack itemStack, Level world, Player player, InteractionHand hand, ItemAbilityManager.AbilityHitContext abilityHitContext) {
        return true;
    }

    @Override
    public UseAnim getUseAction(ItemStack itemStack) {
        return UseAnim.SPYGLASS;
    }

    @Override
    public int getMaxUseTime(ItemStack itemStack, LivingEntity entity) {
        return 72000;
    }

    @Override
    public InteractionResultHolder<ItemStack> use(Level world, Player user, InteractionHand hand) {
        if (user.getCooldowns().isOnCooldown(user.getItemInHand(hand).getItem())) {
            return InteractionResultHolder.pass((Object)user.getItemInHand(hand));
        }
        user.startUsingItem(hand);
        return InteractionResultHolder.consume((Object)user.getItemInHand(hand));
    }

    @Override
    public void onStoppedUsingAfter(ItemStack stack, Level world, LivingEntity user, int remainingUseTicks) {
        SonicBoomContext context = (SonicBoomContext)this.getSpecialContext(stack);
        if (user instanceof Player) {
            Player player = (Player)user;
            if ((double)(this.getMaxUseTime(stack, user) - remainingUseTicks) >= context.minHold().getValue() && world instanceof ServerLevel) {
                ServerLevel serverLevel = (ServerLevel)world;
                double range = context.maxRange().getValue();
                AABB aabb = new AABB(player.getX() - range, player.getY() - range, player.getZ() - range, player.getX() + range, player.getY() + range, player.getZ() + range);
                List entities = world.getEntitiesOfClass(LivingEntity.class, aabb, entity -> entity != player && entity.isAlive());
                for (LivingEntity target : entities) {
                    double damage = context.damage().getValue();
                    target.hurt(player.damageSources().sonicBoom((Entity)target), (float)damage);
                    serverLevel.sendParticles((ParticleOptions)ParticleTypes.SONIC_BOOM, target.getX(), target.getY(), target.getZ(), 10, 0.5, 0.5, 0.5, 0.1);
                }
                player.playSound(context.onBoom(), 1.0f, 1.0f);
                player.getCooldowns().addCooldown(stack.getItem(), (int)context.cooldown().getValue());
                player.swing(player.getUsedItemHand());
            }
        }
    }

    @Override
    public <K> SonicBoomContext decode(DynamicOps<K> ops, K prefix) {
        return (SonicBoomContext)((Pair)SonicBoomContext.CODEC.decode(ops, prefix).getOrThrow()).getFirst();
    }

    @Override
    public SonicBoomContext getDefaultContext() {
        return new SonicBoomContext(SoundEvents.WARDEN_SONIC_BOOM, new DoubleOperationResolvable(15.0), new DoubleOperationResolvable(10.0), new DoubleOperationResolvable(20.0), new DoubleOperationResolvable(5.0));
    }

    @Override
    public SonicBoomContext initialize(SonicBoomContext json, ModuleInstance moduleInstance) {
        return json.initialize(moduleInstance);
    }

    @Override
    public SonicBoomContext merge(SonicBoomContext left, SonicBoomContext right, MergeType mergeType) {
        return SonicBoomContext.merge(left, right, mergeType);
    }

    public record SonicBoomContext(SoundEvent onBoom, DoubleOperationResolvable minHold, DoubleOperationResolvable damage, DoubleOperationResolvable cooldown, DoubleOperationResolvable maxRange) {
        public static final Codec<SonicBoomContext> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)SoundEvent.DIRECT_CODEC.optionalFieldOf("on_boom", (Object)SoundEvents.WARDEN_SONIC_BOOM).forGetter(SonicBoomContext::onBoom), (App)DoubleOperationResolvable.CODEC.optionalFieldOf("min_hold", (Object)new DoubleOperationResolvable(15.0)).forGetter(SonicBoomContext::minHold), (App)DoubleOperationResolvable.CODEC.optionalFieldOf("damage", (Object)new DoubleOperationResolvable(10.0)).forGetter(SonicBoomContext::damage), (App)DoubleOperationResolvable.CODEC.optionalFieldOf("cooldown", (Object)new DoubleOperationResolvable(20.0)).forGetter(SonicBoomContext::cooldown), (App)DoubleOperationResolvable.CODEC.optionalFieldOf("max_range", (Object)new DoubleOperationResolvable(5.0)).forGetter(SonicBoomContext::maxRange)).apply((Applicative)instance, SonicBoomContext::new));

        public SonicBoomContext initialize(ModuleInstance moduleInstance) {
            DoubleOperationResolvable initializedMinHold = this.minHold.initialize(moduleInstance);
            DoubleOperationResolvable initializedDamage = this.damage.initialize(moduleInstance);
            DoubleOperationResolvable initializedCooldown = this.cooldown.initialize(moduleInstance);
            DoubleOperationResolvable initializedMaxRange = this.maxRange.initialize(moduleInstance);
            return new SonicBoomContext(this.onBoom, initializedMinHold, initializedDamage, initializedCooldown, initializedMaxRange);
        }

        public static SonicBoomContext merge(SonicBoomContext left, SonicBoomContext right, MergeType mergeType) {
            SoundEvent mergedOnBoom = MergeType.EXTEND.equals((Object)mergeType) && left.onBoom != null ? left.onBoom : right.onBoom;
            DoubleOperationResolvable mergedMinHold = left.minHold.merge(right.minHold, mergeType);
            DoubleOperationResolvable mergedDamage = left.damage.merge(right.damage, mergeType);
            DoubleOperationResolvable mergedCooldown = left.cooldown.merge(right.cooldown, mergeType);
            DoubleOperationResolvable mergedMaxRange = left.maxRange.merge(right.maxRange, mergeType);
            return new SonicBoomContext(mergedOnBoom, mergedMinHold, mergedDamage, mergedCooldown, mergedMaxRange);
        }
    }
}

