/*
 * Decompiled with CFR 0.152.
 */
package smartin.miapi.modules.abilities.gun;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.Vec3;
import smartin.miapi.Miapi;
import smartin.miapi.modules.abilities.gun.GunContextProperty;
import smartin.miapi.network.modern.ModernNetworking;

public class GunMagazineComponent {
    public static final Codec<List<ItemStack>> CODEC = ItemStack.CODEC.listOf();
    public static final DataComponentType<List<ItemStack>> STACK_STORAGE_COMPONENT = DataComponentType.builder().persistent(CODEC).networkSynchronized(ByteBufCodecs.fromCodec(CODEC)).build();
    public static final ResourceLocation PACKET_ID = Miapi.id("miapi", "c2s_hitscan_shot");

    public static void addBullet(ItemStack gun, ItemStack bullet) {
        List<ItemStack> magazine = List.copyOf((Collection)gun.getOrDefault(STACK_STORAGE_COMPONENT, List.of()));
        magazine = new ArrayList(magazine);
        magazine.add(bullet);
        gun.set(STACK_STORAGE_COMPONENT, magazine);
    }

    public static Optional<ItemStack> removeBullet(ItemStack gun) {
        List magazine = List.copyOf((Collection)gun.getOrDefault(STACK_STORAGE_COMPONENT, List.of()));
        if (!magazine.isEmpty()) {
            magazine = new ArrayList(magazine);
            ItemStack removed = (ItemStack)magazine.removeFirst();
            gun.set(STACK_STORAGE_COMPONENT, magazine);
            return Optional.of(removed);
        }
        return Optional.empty();
    }

    public static int getBulletCount(ItemStack gun) {
        return ((List)gun.getOrDefault(STACK_STORAGE_COMPONENT, List.of())).size();
    }

    public static void emptyMagazine(ItemStack gun) {
        gun.set(STACK_STORAGE_COMPONENT, List.of());
    }

    public static void shoot(Level world, Player player, boolean isHitscan) {
        if (isHitscan) {
            if (world.isClientSide) {
                GunMagazineComponent.handleClientHitscan(player);
            }
        } else {
            GunMagazineComponent.handleProjectileShot(world, player);
        }
    }

    private static void handleClientHitscan(Player player) {
        Vec3 start = player.getEyePosition();
        Vec3 look = player.getLookAngle();
        double range = GunContextProperty.getGunContext(player.getMainHandItem()).range().getValue();
        Vec3 end = start.add(look.scale(range));
        BlockHitResult hitResult = player.level().clip(new ClipContext(start, end, ClipContext.Block.OUTLINE, ClipContext.Fluid.NONE, (Entity)player));
        Optional<Integer> entityHit = Optional.empty();
        if (hitResult instanceof EntityHitResult) {
            EntityHitResult entityHitResult = (EntityHitResult)hitResult;
            entityHit = Optional.of(entityHitResult.getEntity().getId());
        }
        ModernNetworking.sendToServer(PACKET_ID, ShotPacketData.PACKET_CODEC, new ShotPacketData(hitResult.getLocation(), entityHit), player.level().registryAccess());
    }

    private static void handleProjectileShot(Level world, Player player) {
    }

    static {
        ModernNetworking.registerC2SReceiver(PACKET_ID, ShotPacketData.PACKET_CODEC, (packetData, player, access) -> {
            Level world = player.level();
            ItemStack weapon = player.getWeaponItem();
            if (!world.isClientSide && GunMagazineComponent.getBulletCount(weapon) > 0) {
                double maxRange = GunContextProperty.getGunContext(weapon).range().getValue();
                Vec3 shooterPos = player.getEyePosition();
                if (packetData.hitPosition.distanceTo(shooterPos) <= maxRange) {
                    packetData.hitEntityId.ifPresent(entityID -> {
                        LivingEntity target;
                        Entity patt0$temp = player.level().getEntity(entityID.intValue());
                        if (patt0$temp instanceof LivingEntity && (target = (LivingEntity)patt0$temp) != player) {
                            double damage = GunContextProperty.getGunContext(weapon).baseDamage().getValue();
                            Optional<ItemStack> optionalBullet = GunMagazineComponent.removeBullet(weapon);
                            optionalBullet.ifPresent(bullet -> target.hurt(player.damageSources().playerAttack(player), (float)damage));
                        }
                    });
                }
            }
        });
    }

    public static class ShotPacketData {
        public final Vec3 hitPosition;
        public final Optional<Integer> hitEntityId;
        public static final Codec<ShotPacketData> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Vec3.CODEC.fieldOf("hitPosition").forGetter(data -> data.hitPosition), (App)Codec.INT.optionalFieldOf("hitEntityId").forGetter(data -> data.hitEntityId)).apply((Applicative)instance, ShotPacketData::new));
        public static final StreamCodec<RegistryFriendlyByteBuf, ShotPacketData> PACKET_CODEC = ByteBufCodecs.fromCodecWithRegistries(CODEC);

        public ShotPacketData(Vec3 hitPosition, Optional<Integer> hitEntityId) {
            this.hitPosition = hitPosition;
            this.hitEntityId = hitEntityId;
        }
    }
}

