/*
 * Decompiled with CFR 0.152.
 */
package smartin.miapi.modules.abilities.gun;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.redpxnda.nucleus.pose.server.ServerPoseFacet;
import java.util.Optional;
import java.util.function.Predicate;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import smartin.miapi.Miapi;
import smartin.miapi.modules.abilities.gun.GunContextProperty;
import smartin.miapi.modules.abilities.gun.GunMagazineComponent;
import smartin.miapi.modules.abilities.util.CodecAbility;
import smartin.miapi.modules.abilities.util.ItemAbilityManager;

public class ReloadSingleBulletAbility
implements CodecAbility<ReloadAbilityContext> {
    public static ResourceLocation KEY = Miapi.id("gun_reload_single");

    @Override
    public boolean allowedOnItem(ItemStack itemStack, Level world, Player player, InteractionHand hand, ItemAbilityManager.AbilityHitContext abilityHitContext) {
        boolean hasSpace = (double)GunMagazineComponent.getBulletCount(itemStack) < GunContextProperty.getGunContext(itemStack).magazineSize().getValue();
        boolean hasAbility = this.getSpecialContext(itemStack) != null;
        return hasAbility && hasSpace;
    }

    @Override
    public UseAnim getUseAction(ItemStack itemStack) {
        return UseAnim.NONE;
    }

    @Override
    public int getMaxUseTime(ItemStack itemStack, LivingEntity livingEntity) {
        return (int)Math.ceil(((ReloadAbilityContext)this.getSpecialContext((ItemStack)itemStack)).reloadDelaySeconds * 20.0f);
    }

    @Override
    public InteractionResultHolder<ItemStack> use(Level world, Player player, InteractionHand hand) {
        ItemStack gun = player.getItemInHand(hand);
        ReloadAbilityContext context = (ReloadAbilityContext)this.getSpecialContext(gun);
        if (context == null || (double)GunMagazineComponent.getBulletCount(gun) >= GunContextProperty.getGunContext(gun).magazineSize().getValue()) {
            return InteractionResultHolder.pass((Object)gun);
        }
        player.startUsingItem(hand);
        return InteractionResultHolder.consume((Object)gun);
    }

    @Override
    public void onStoppedUsing(ItemStack gun, Level world, LivingEntity entity, int timeCharged) {
        SoundEvent event;
        if (!(entity instanceof Player)) {
            return;
        }
        Player player = (Player)entity;
        ReloadAbilityContext context = (ReloadAbilityContext)this.getSpecialContext(gun);
        if (context == null) {
            return;
        }
        int chargeDuration = this.getMaxUseTime(gun, entity) - timeCharged;
        if (chargeDuration < this.getMaxUseTime(gun, entity)) {
            return;
        }
        Optional<ItemStack> bullet = player.getInventory().items.stream().filter(context.bulletFilter).findFirst();
        if (bullet.isEmpty()) {
            return;
        }
        bullet.get().shrink(1);
        GunMagazineComponent.addBullet(gun, new ItemStack((ItemLike)bullet.get().getItem()));
        if (context.reloadSound != null && (event = (SoundEvent)((Registry)world.registryAccess().registry(Registries.SOUND_EVENT).get()).get(context.reloadSound)) != null) {
            world.playSound(null, entity.getX(), entity.getY(), entity.getZ(), event, entity.getSoundSource(), 1.0f, 1.0f);
        }
        if (context.reloadAnim != null) {
            this.setAnimation(player, InteractionHand.MAIN_HAND, context.reloadAnim);
            world.getServer().execute(() -> this.resetAnimation((LivingEntity)player));
        }
    }

    private void setAnimation(Player player, InteractionHand hand, ResourceLocation location) {
        ServerPlayer serverPlayer;
        ServerPoseFacet facet;
        if (player instanceof ServerPlayer && (facet = (ServerPoseFacet)ServerPoseFacet.KEY.get((Entity)(serverPlayer = (ServerPlayer)player))) != null) {
            facet.set(location.toString(), serverPlayer, hand);
        }
    }

    private void resetAnimation(LivingEntity entity) {
        ServerPlayer serverPlayer;
        ServerPoseFacet facet;
        if (entity instanceof ServerPlayer && (facet = (ServerPoseFacet)ServerPoseFacet.KEY.get((Entity)(serverPlayer = (ServerPlayer)entity))) != null) {
            facet.reset(serverPlayer);
        }
    }

    @Override
    public Codec<ReloadAbilityContext> getCodec() {
        return ReloadAbilityContext.CODEC;
    }

    public static class ReloadAbilityContext {
        public static final Codec<ReloadAbilityContext> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.FLOAT.fieldOf("reloadDelaySeconds").forGetter(context -> Float.valueOf(context.reloadDelaySeconds)), (App)ResourceLocation.CODEC.optionalFieldOf("reloadAnim").forGetter(context -> Optional.ofNullable(context.reloadAnim)), (App)ResourceLocation.CODEC.optionalFieldOf("reloadSound").forGetter(context -> Optional.ofNullable(context.reloadSound))).apply((Applicative)instance, ReloadAbilityContext::new));
        public final float reloadDelaySeconds;
        public final Predicate<ItemStack> bulletFilter;
        public final ResourceLocation reloadAnim;
        public final ResourceLocation reloadSound;

        public ReloadAbilityContext(float reloadDelaySeconds, Optional<ResourceLocation> reloadAnim, Optional<ResourceLocation> reloadSound) {
            this.reloadDelaySeconds = reloadDelaySeconds;
            this.bulletFilter = i -> true;
            this.reloadAnim = reloadAnim.orElse(null);
            this.reloadSound = reloadSound.orElse(null);
        }
    }
}

