/*
 * Decompiled with CFR 0.152.
 */
package smartin.miapi.modules.abilities.key;

import java.util.Map;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import smartin.miapi.Environment;
import smartin.miapi.Miapi;
import smartin.miapi.client.MiapiClient;
import smartin.miapi.config.MiapiConfig;
import smartin.miapi.datapack.ReloadEvents;
import smartin.miapi.modules.abilities.key.KeyBindFacet;
import smartin.miapi.modules.abilities.key.MiapiBinding;
import smartin.miapi.modules.abilities.util.ItemAbilityManager;
import smartin.miapi.network.modern.ModernNetworking;
import smartin.miapi.registries.MiapiRegistry;

public class KeyBindManager {
    public static MiapiRegistry<MiapiBinding> BINDING_REGISTRY = MiapiRegistry.getInstance(MiapiBinding.class);
    public static ResourceLocation PACKET_ID = Miapi.id("c2s_binding_sync");
    public static StreamCodec<RegistryFriendlyByteBuf, ResourceLocation> PACKET_CODEC = ByteBufCodecs.fromCodecWithRegistriesTrusted(Miapi.ID_CODEC);

    public static void setup() {
        KeyBindFacet.KEY.cls();
        ModernNetworking.registerC2SReceiver(PACKET_ID, PACKET_CODEC, (id, player, access) -> {
            if (id.toString().equals("miapi:none")) {
                ItemAbilityManager.serverKeyBindID.remove(player, id);
            } else {
                ItemAbilityManager.serverKeyBindID.put((Player)player, (ResourceLocation)id);
            }
        });
        ReloadEvents.END.subscribe((isClient, registryAccess) -> {
            if (isClient && MiapiConfig.clientConfigObject != null) {
                MiapiConfig.clientConfigObject.save();
            }
        });
    }

    public static void processKeybind(boolean isClient, ResourceLocation id, String data) {
        if (BINDING_REGISTRY.get(id = KeyBindManager.minimizeID(id)) == null) {
            BINDING_REGISTRY.register(id, MiapiBinding.decode(id, data));
        } else {
            MiapiBinding old = BINDING_REGISTRY.get(id);
            MiapiBinding newBinding = MiapiBinding.decode(id, data);
            old.itemInteraction = newBinding.itemInteraction;
            old.entityInteraction = newBinding.entityInteraction;
            old.blockInteraction = newBinding.blockInteraction;
            old.category = newBinding.category;
        }
        MiapiBinding binding = BINDING_REGISTRY.get(id);
        if (KeyBindManager.clientRegister(isClient, binding)) {
            MiapiConfig.getClientConfig().other.bindings.put(binding.id, binding);
        }
    }

    public static void configLoad(Map<ResourceLocation, MiapiBinding> bindings) {
        bindings.forEach((key, binding) -> {
            binding.setID((ResourceLocation)key);
            if (BINDING_REGISTRY.get(binding.id) == null) {
                BINDING_REGISTRY.register(binding.id, (MiapiBinding)binding);
            }
            if (KeyBindManager.clientRegister(Environment.isClient(), binding)) {
                MiapiConfig.getClientConfig().other.bindings.put(binding.id, (MiapiBinding)binding);
            }
        });
    }

    public static boolean clientRegister(boolean isClient, MiapiBinding binding) {
        if (binding != null && isClient && !binding.isClientRegistered && MiapiClient.KEY_BINDINGS.get(binding.id) == null) {
            MiapiClient.KEY_BINDINGS.register(binding.id, binding.asKeyMapping());
            binding.isClientRegistered = true;
            return true;
        }
        return false;
    }

    public static void updateServerId(ResourceLocation id, Player player) {
        ModernNetworking.sendToServer(PACKET_ID, PACKET_CODEC, id, player.level().registryAccess());
    }

    public static ResourceLocation minimizeID(ResourceLocation resourceLocation) {
        return Miapi.id(resourceLocation.toString().replace(".json", "").replace("miapi/key_binding/", ""));
    }
}

