/*
 * Decompiled with CFR 0.152.
 */
package smartin.miapi.modules.abilities.toolabilities;

import com.mojang.datafixers.util.Pair;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Predicate;
import net.minecraft.core.BlockPos;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import smartin.miapi.mixin.HoeItemAccessor;
import smartin.miapi.modules.abilities.util.ToolAbilities;

public class HoeAbility
extends ToolAbilities {
    public static final String KEY = "hoe_ability";

    @Override
    public Optional<BlockState> getBlockState(BlockState blockState, UseOnContext context) {
        return Optional.empty();
    }

    @Override
    public InteractionResult useOnBlock(UseOnContext context) {
        Level world = context.getLevel();
        BlockPos blockPos = context.getClickedPos();
        Pair<Predicate<UseOnContext>, Consumer<UseOnContext>> pair = HoeItemAccessor.getTILLING_ACTIONS().get(world.getBlockState(blockPos).getBlock());
        if (pair == null) {
            return InteractionResult.PASS;
        }
        Predicate predicate = (Predicate)pair.getFirst();
        Consumer consumer = (Consumer)pair.getSecond();
        if (predicate.test(context)) {
            Player playerEntity = context.getPlayer();
            world.playSound(playerEntity, blockPos, SoundEvents.HOE_TILL, SoundSource.BLOCKS, 1.0f, 1.0f);
            if (!world.isClientSide) {
                consumer.accept(context);
                if (playerEntity != null) {
                    context.getItemInHand().hurtAndBreak(1, (LivingEntity)playerEntity, this.getEquipmentSlot(context.getHand()));
                }
            }
            return InteractionResult.sidedSuccess((boolean)world.isClientSide);
        }
        return InteractionResult.PASS;
    }
}

