/*
 * Decompiled with CFR 0.152.
 */
package smartin.miapi.modules.abilities.util;

import com.google.common.collect.Multimap;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.core.Holder;
import net.minecraft.stats.Stats;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.level.Level;
import smartin.miapi.modules.abilities.util.ItemUseDefaultCooldownAbility;
import smartin.miapi.modules.abilities.util.ItemUseMinHoldAbility;

public abstract class EntityAttributeAbility<T>
implements ItemUseDefaultCooldownAbility<T>,
ItemUseMinHoldAbility<T> {
    Map<LivingEntity, Multimap<Holder<Attribute>, AttributeModifier>> playerEntityMultimapMap = new HashMap<LivingEntity, Multimap<Holder<Attribute>, AttributeModifier>>();

    protected abstract Multimap<Holder<Attribute>, AttributeModifier> getAttributes(ItemStack var1);

    @Override
    public InteractionResultHolder<ItemStack> use(Level world, Player user, InteractionHand hand) {
        ItemStack itemStack = user.getItemInHand(hand);
        user.startUsingItem(hand);
        Multimap<Holder<Attribute>, AttributeModifier> attributeAttributePropertyMultimap = this.getAttributes(itemStack);
        user.getAttributes().addTransientAttributeModifiers(attributeAttributePropertyMultimap);
        this.playerEntityMultimapMap.put((LivingEntity)user, attributeAttributePropertyMultimap);
        return InteractionResultHolder.consume((Object)itemStack);
    }

    private void remove(ItemStack itemStack, LivingEntity livingEntity) {
        Multimap<Holder<Attribute>, AttributeModifier> map;
        if (livingEntity instanceof Player) {
            Player playerEntity = (Player)livingEntity;
            playerEntity.awardStat(Stats.ITEM_USED.get((Object)itemStack.getItem()));
        }
        if ((map = this.playerEntityMultimapMap.get(livingEntity)) != null) {
            livingEntity.getAttributes().removeAttributeModifiers(map);
        }
    }

    @Override
    public ItemStack finishUsing(ItemStack stack, Level world, LivingEntity user) {
        this.remove(stack, user);
        return stack;
    }

    @Override
    public void onStoppedUsingAfter(ItemStack stack, Level world, LivingEntity user, int remainingUseTicks) {
        this.remove(stack, user);
    }

    @Override
    public void onStoppedHolding(ItemStack stack, Level world, LivingEntity user) {
        this.remove(stack, user);
    }

    @Override
    public UseAnim getUseAction(ItemStack itemStack) {
        return UseAnim.NONE;
    }
}

